/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v9_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CommerceOrderUpgradeProcess
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this._updateCommerceOrder();
    }

    private List<Integer> _getCommerceShipmentStatuses(Connection connection, long commerceOrderId) throws SQLException {
        PreparedStatement preparedStatement2 = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select distinct CommerceShipment.status from ", "CommerceShipment left join CommerceShipmentItem on ", "CommerceShipmentItem.commerceShipmentId = ", "CommerceShipment.commerceShipmentId inner join ", "CommerceOrderItem on CommerceOrderItem.commerceOrderItemId = ", "CommerceShipmentItem.commerceOrderItemId where ", "CommerceOrderItem.commerceOrderId = ?"}));
        preparedStatement2.setLong(1, commerceOrderId);
        ArrayList<Integer> commerceShipmentStatuses = new ArrayList<Integer>();
        try (ResultSet resultSet2 = preparedStatement2.executeQuery();){
            while (resultSet2.next()) {
                int status = resultSet2.getInt("status");
                commerceShipmentStatuses.add(status);
            }
        }
        return commerceShipmentStatuses;
    }

    private boolean _isAllOrderItemsShipped(Connection connection, long commerceOrderId) throws Exception {
        PreparedStatement preparedStatement4 = connection.prepareStatement("select shippedQuantity, quantity from CommerceOrderItem where commerceOrderId = ?");
        preparedStatement4.setLong(1, commerceOrderId);
        try (ResultSet resultSet4 = preparedStatement4.executeQuery();){
            while (resultSet4.next()) {
                int quantity = resultSet4.getInt(1);
                int shippedQuantity = resultSet4.getInt(2);
                if (shippedQuantity >= quantity || !this._isShippable(connection, commerceOrderId)) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private boolean _isShippable(Connection connection, long commerceOrderId) throws Exception {
        PreparedStatement preparedStatement3 = connection.prepareStatement("select distinct shippable from CommerceOrderItem where commerceOrderId = ?");
        preparedStatement3.setLong(1, commerceOrderId);
        try (ResultSet resultSet3 = preparedStatement3.executeQuery();){
            while (resultSet3.next()) {
                boolean shippable = resultSet3.getBoolean("shippable");
                if (!shippable) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean _isTransitionCriteriaMetCompletedCommerceOrderStatus(int orderStatus, boolean shippable) {
        return orderStatus == 15 || orderStatus == 10 && !shippable;
    }

    private boolean _isTransitionCriteriaMetShippedCommerceOrderStatus(int orderStatus, boolean allOrderItemsShipped) {
        return (orderStatus == 10 || orderStatus == 14) && allOrderItemsShipped;
    }

    private void _updateCommerceOrder() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select commerceOrderId, orderStatus from CommerceOrder where orderStatus = ? or orderStatus = ?");){
            preparedStatement1.setInt(1, 14);
            preparedStatement1.setInt(2, 15);
            try (ResultSet resultSet1 = preparedStatement1.executeQuery();){
                while (resultSet1.next()) {
                    long commerceOrderId = resultSet1.getLong(1);
                    int orderStatus = resultSet1.getInt(2);
                    List<Integer> commerceShipmentStatuses = this._getCommerceShipmentStatuses(this.connection, commerceOrderId);
                    boolean shippable = this._isShippable(this.connection, commerceOrderId);
                    if (orderStatus == 14) {
                        this._updateShippedCommerceOrderStatus(commerceOrderId, orderStatus, this._isAllOrderItemsShipped(this.connection, commerceOrderId), commerceShipmentStatuses);
                        continue;
                    }
                    if (orderStatus != 15) continue;
                    this._updateCompletedCommerceOrderStatus(commerceOrderId, orderStatus, shippable, commerceShipmentStatuses);
                }
            }
        }
    }

    private void _updateCompletedCommerceOrderStatus(long commerceOrderId, int orderStatus, boolean shippable, List<Integer> commerceShipmentStatuses) throws Exception {
        if (this._isTransitionCriteriaMetCompletedCommerceOrderStatus(orderStatus, shippable) && commerceShipmentStatuses.size() == 1 && commerceShipmentStatuses.get(0) == 3) {
            this.runSQL(StringBundler.concat((Object[])new Object[]{"update CommerceOrder set orderStatus = ", 0, " where commerceOrderId = ", commerceOrderId}));
        }
    }

    private void _updateShippedCommerceOrderStatus(long commerceOrderId, int orderStatus, boolean allOrderItemsShipped, List<Integer> commerceShipmentStatuses) throws Exception {
        if (this._isTransitionCriteriaMetShippedCommerceOrderStatus(orderStatus, allOrderItemsShipped)) {
            this.runSQL(StringBundler.concat((Object[])new Object[]{"update CommerceOrder set orderStatus = ", 15, " where commerceOrderId = ", commerceOrderId}));
            if (commerceShipmentStatuses.size() == 1 && commerceShipmentStatuses.get(0) == 3) {
                this.runSQL(StringBundler.concat((Object[])new Object[]{"update CommerceOrder set orderStatus = ", 0, " where commerceOrderId = ", commerceOrderId}));
            }
        }
    }
}

