/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.permission;

import com.liferay.commerce.context.CommerceGroupThreadLocal;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.permission.CommerceOrderTypePermission;
import com.liferay.commerce.service.CommerceOrderTypeLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceOrderTypePermission.class})
public class CommerceOrderTypePermissionImpl
implements CommerceOrderTypePermission {
    @Reference
    private CommerceOrderTypeLocalService _commerceOrderTypeLocalService;

    public void check(PermissionChecker permissionChecker, CommerceOrderType commerceOrderType, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceOrderType, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceOrderType.class.getName(), commerceOrderType.getCommerceOrderTypeId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long commerceOrderTypeId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, commerceOrderTypeId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CommerceOrderType.class.getName(), commerceOrderTypeId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CommerceOrderType commerceOrderType, String actionId) throws PortalException {
        return this.contains(permissionChecker, commerceOrderType.getCommerceOrderTypeId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long commerceOrderTypeId, String actionId) throws PortalException {
        CommerceOrderType commerceOrderType = this._commerceOrderTypeLocalService.fetchCommerceOrderType(commerceOrderTypeId);
        if (commerceOrderType == null) {
            return false;
        }
        return this._contains(permissionChecker, commerceOrderType, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long[] commerceOrderTypeIds, String actionId) throws PortalException {
        if (ArrayUtil.isEmpty((long[])commerceOrderTypeIds)) {
            return false;
        }
        for (long commerceOrderTypeId : commerceOrderTypeIds) {
            if (this.contains(permissionChecker, commerceOrderTypeId, actionId)) continue;
            return false;
        }
        return true;
    }

    private boolean _contains(PermissionChecker permissionChecker, CommerceOrderType commerceOrderType, String actionId) throws PortalException {
        if (permissionChecker.isCompanyAdmin(commerceOrderType.getCompanyId()) || permissionChecker.isOmniadmin()) {
            return true;
        }
        if (permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), CommerceOrderType.class.getName(), commerceOrderType.getCommerceOrderTypeId(), permissionChecker.getUserId(), actionId) && commerceOrderType.getUserId() == permissionChecker.getUserId()) {
            return true;
        }
        return permissionChecker.hasPermission(CommerceGroupThreadLocal.get(), CommerceOrderType.class.getName(), commerceOrderType.getCommerceOrderTypeId(), actionId);
    }
}

