/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.exception.DuplicateCommerceShipmentExternalReferenceCodeException;
import com.liferay.commerce.exception.NoSuchShipmentException;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentTable;
import com.liferay.commerce.model.impl.CommerceShipmentImpl;
import com.liferay.commerce.model.impl.CommerceShipmentModelImpl;
import com.liferay.commerce.service.persistence.CommerceShipmentPersistence;
import com.liferay.commerce.service.persistence.CommerceShipmentUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUID;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceShipmentPersistence.class})
public class CommerceShipmentPersistenceImpl
extends BasePersistenceImpl<CommerceShipment>
implements CommerceShipmentPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceShipmentImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "commerceShipment.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(commerceShipment.uuid IS NULL OR commerceShipment.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "commerceShipment.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(commerceShipment.uuid IS NULL OR commerceShipment.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "commerceShipment.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "commerceShipment.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(commerceShipment.uuid IS NULL OR commerceShipment.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "commerceShipment.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private FinderPath _finderPathWithPaginationCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "commerceShipment.groupId = ?";
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_7 = "commerceShipment.groupId IN (";
    private FinderPath _finderPathWithPaginationFindByG_C;
    private FinderPath _finderPathWithoutPaginationFindByG_C;
    private FinderPath _finderPathCountByG_C;
    private FinderPath _finderPathWithPaginationCountByG_C;
    private static final String _FINDER_COLUMN_G_C_GROUPID_2 = "commerceShipment.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_GROUPID_7 = "commerceShipment.groupId IN (";
    private static final String _FINDER_COLUMN_G_C_COMMERCEADDRESSID_2 = "commerceShipment.commerceAddressId = ?";
    private FinderPath _finderPathWithPaginationFindByG_S;
    private FinderPath _finderPathWithoutPaginationFindByG_S;
    private FinderPath _finderPathCountByG_S;
    private FinderPath _finderPathWithPaginationCountByG_S;
    private static final String _FINDER_COLUMN_G_S_GROUPID_2 = "commerceShipment.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_S_GROUPID_7 = "commerceShipment.groupId IN (";
    private static final String _FINDER_COLUMN_G_S_STATUS_2 = "commerceShipment.status = ?";
    private FinderPath _finderPathFetchByERC_C;
    private FinderPath _finderPathCountByERC_C;
    private static final String _FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_2 = "commerceShipment.externalReferenceCode = ? AND ";
    private static final String _FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_3 = "(commerceShipment.externalReferenceCode IS NULL OR commerceShipment.externalReferenceCode = '') AND ";
    private static final String _FINDER_COLUMN_ERC_C_COMPANYID_2 = "commerceShipment.companyId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCESHIPMENT = "SELECT commerceShipment FROM CommerceShipment commerceShipment";
    private static final String _SQL_SELECT_COMMERCESHIPMENT_WHERE = "SELECT commerceShipment FROM CommerceShipment commerceShipment WHERE ";
    private static final String _SQL_COUNT_COMMERCESHIPMENT = "SELECT COUNT(commerceShipment) FROM CommerceShipment commerceShipment";
    private static final String _SQL_COUNT_COMMERCESHIPMENT_WHERE = "SELECT COUNT(commerceShipment) FROM CommerceShipment commerceShipment WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceShipment.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceShipment exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceShipment exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});
    @Reference
    private PortalUUID _portalUUID;

    public List<CommerceShipment> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<CommerceShipment> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<CommerceShipment> findByUuid(String uuid, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByUuid(String uuid, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (uuid.equals(commerceShipment.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findByUuid_First(String uuid, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByUuid_First(uuid, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByUuid_First(String uuid, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findByUuid_Last(String uuid, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByUuid_Last(uuid, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByUuid_Last(String uuid, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findByUuid_PrevAndNext(long commerceShipmentId, String uuid, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        uuid = Objects.toString(uuid, "");
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getByUuid_PrevAndNext(session, commerceShipment, uuid, orderByComparator, true), commerceShipment, this.getByUuid_PrevAndNext(session, commerceShipment, uuid, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getByUuid_PrevAndNext(Session session, CommerceShipment commerceShipment, String uuid, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (CommerceShipment commerceShipment : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceShipment findByUUID_G(String uuid, long groupId) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByUUID_G(uuid, groupId);
        if (commerceShipment == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchShipmentException(sb.toString());
        }
        return commerceShipment;
    }

    public CommerceShipment fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public CommerceShipment fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        CommerceShipment commerceShipment;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs, (BasePersistence)this);
        }
        if (result instanceof CommerceShipment && (!Objects.equals(uuid, (commerceShipment = (CommerceShipment)result).getUuid()) || groupId != commerceShipment.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(commerceShipment.uuid IS NULL OR commerceShipment.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("commerceShipment.uuid = ? AND ");
            }
            sb.append("commerceShipment.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    CommerceShipment commerceShipment2 = (CommerceShipment)list.get(0);
                    result = commerceShipment2;
                    this.cacheResult(commerceShipment2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceShipment)result;
    }

    public CommerceShipment removeByUUID_G(String uuid, long groupId) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByUUID_G(uuid, groupId);
        return (CommerceShipment)this.remove((BaseModel)commerceShipment);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(commerceShipment.uuid IS NULL OR commerceShipment.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("commerceShipment.uuid = ? AND ");
            }
            sb.append("commerceShipment.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipment> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<CommerceShipment> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<CommerceShipment> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (uuid.equals(commerceShipment.getUuid()) && companyId == commerceShipment.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(commerceShipment.uuid IS NULL OR commerceShipment.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("commerceShipment.uuid = ? AND ");
            }
            sb.append("commerceShipment.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findByUuid_C_First(String uuid, long companyId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findByUuid_C_Last(String uuid, long companyId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findByUuid_C_PrevAndNext(long commerceShipmentId, String uuid, long companyId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        uuid = Objects.toString(uuid, "");
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getByUuid_C_PrevAndNext(session, commerceShipment, uuid, companyId, orderByComparator, true), commerceShipment, this.getByUuid_C_PrevAndNext(session, commerceShipment, uuid, companyId, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getByUuid_C_PrevAndNext(Session session, CommerceShipment commerceShipment, String uuid, long companyId, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(commerceShipment.uuid IS NULL OR commerceShipment.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("commerceShipment.uuid = ? AND ");
        }
        sb.append("commerceShipment.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (CommerceShipment commerceShipment : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(commerceShipment.uuid IS NULL OR commerceShipment.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("commerceShipment.uuid = ? AND ");
            }
            sb.append("commerceShipment.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipment> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<CommerceShipment> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<CommerceShipment> findByGroupId(long groupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByGroupId(long groupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByGroupId;
                finderArgs = new Object[]{groupId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (groupId == commerceShipment.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            sb.append("commerceShipment.groupId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findByGroupId_First(long groupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByGroupId_First(groupId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByGroupId_First(long groupId, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findByGroupId_Last(long groupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByGroupId_Last(long groupId, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findByGroupId_PrevAndNext(long commerceShipmentId, long groupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getByGroupId_PrevAndNext(session, commerceShipment, groupId, orderByComparator, true), commerceShipment, this.getByGroupId_PrevAndNext(session, commerceShipment, groupId, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getByGroupId_PrevAndNext(Session session, CommerceShipment commerceShipment, long groupId, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        sb.append("commerceShipment.groupId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public List<CommerceShipment> findByGroupId(long[] groupIds) {
        return this.findByGroupId(groupIds, -1, -1, null);
    }

    public List<CommerceShipment> findByGroupId(long[] groupIds, int start, int end) {
        return this.findByGroupId(groupIds, start, end, null);
    }

    public List<CommerceShipment> findByGroupId(long[] groupIds, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByGroupId(groupIds, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByGroupId(long[] groupIds, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        if (groupIds.length == 1) {
            return this.findByGroupId(groupIds[0], start, end, orderByComparator);
        }
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderArgs = new Object[]{StringUtil.merge((long[])groupIds)};
            }
        } else if (useFinderCache) {
            finderArgs = new Object[]{StringUtil.merge((long[])groupIds), start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(this._finderPathWithPaginationFindByGroupId, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (ArrayUtil.contains((long[])groupIds, (long)commerceShipment.getGroupId())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
            }
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(this._finderPathWithPaginationFindByGroupId, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByGroupId(long groupId) {
        for (CommerceShipment commerceShipment : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            sb.append("commerceShipment.groupId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByGroupId(long[] groupIds) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        Object[] finderArgs = new Object[]{StringUtil.merge((long[])groupIds)};
        Long count = (Long)this.finderCache.getResult(this._finderPathWithPaginationCountByGroupId, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
            }
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathWithPaginationCountByGroupId, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipment> findByG_C(long groupId, long commerceAddressId) {
        return this.findByG_C(groupId, commerceAddressId, -1, -1, null);
    }

    public List<CommerceShipment> findByG_C(long groupId, long commerceAddressId, int start, int end) {
        return this.findByG_C(groupId, commerceAddressId, start, end, null);
    }

    public List<CommerceShipment> findByG_C(long groupId, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByG_C(groupId, commerceAddressId, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByG_C(long groupId, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_C;
                finderArgs = new Object[]{groupId, commerceAddressId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_C;
            finderArgs = new Object[]{groupId, commerceAddressId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (groupId == commerceShipment.getGroupId() && commerceAddressId == commerceShipment.getCommerceAddressId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            sb.append("commerceShipment.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_C_COMMERCEADDRESSID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(commerceAddressId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findByG_C_First(long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByG_C_First(groupId, commerceAddressId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", commerceAddressId=");
        sb.append(commerceAddressId);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByG_C_First(long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findByG_C(groupId, commerceAddressId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findByG_C_Last(long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByG_C_Last(groupId, commerceAddressId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", commerceAddressId=");
        sb.append(commerceAddressId);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByG_C_Last(long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countByG_C(groupId, commerceAddressId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findByG_C(groupId, commerceAddressId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findByG_C_PrevAndNext(long commerceShipmentId, long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getByG_C_PrevAndNext(session, commerceShipment, groupId, commerceAddressId, orderByComparator, true), commerceShipment, this.getByG_C_PrevAndNext(session, commerceShipment, groupId, commerceAddressId, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getByG_C_PrevAndNext(Session session, CommerceShipment commerceShipment, long groupId, long commerceAddressId, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        sb.append("commerceShipment.groupId = ? AND ");
        sb.append(_FINDER_COLUMN_G_C_COMMERCEADDRESSID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(commerceAddressId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public List<CommerceShipment> findByG_C(long[] groupIds, long commerceAddressId) {
        return this.findByG_C(groupIds, commerceAddressId, -1, -1, null);
    }

    public List<CommerceShipment> findByG_C(long[] groupIds, long commerceAddressId, int start, int end) {
        return this.findByG_C(groupIds, commerceAddressId, start, end, null);
    }

    public List<CommerceShipment> findByG_C(long[] groupIds, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByG_C(groupIds, commerceAddressId, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByG_C(long[] groupIds, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        if (groupIds.length == 1) {
            return this.findByG_C(groupIds[0], commerceAddressId, start, end, orderByComparator);
        }
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderArgs = new Object[]{StringUtil.merge((long[])groupIds), commerceAddressId};
            }
        } else if (useFinderCache) {
            finderArgs = new Object[]{StringUtil.merge((long[])groupIds), commerceAddressId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(this._finderPathWithPaginationFindByG_C, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (ArrayUtil.contains((long[])groupIds, (long)commerceShipment.getGroupId()) && commerceAddressId == commerceShipment.getCommerceAddressId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
                sb.append(" AND ");
            }
            sb.append(_FINDER_COLUMN_G_C_COMMERCEADDRESSID_2);
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceAddressId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(this._finderPathWithPaginationFindByG_C, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByG_C(long groupId, long commerceAddressId) {
        for (CommerceShipment commerceShipment : this.findByG_C(groupId, commerceAddressId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countByG_C(long groupId, long commerceAddressId) {
        FinderPath finderPath = this._finderPathCountByG_C;
        Object[] finderArgs = new Object[]{groupId, commerceAddressId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            sb.append("commerceShipment.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_C_COMMERCEADDRESSID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(commerceAddressId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByG_C(long[] groupIds, long commerceAddressId) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        Object[] finderArgs = new Object[]{StringUtil.merge((long[])groupIds), commerceAddressId};
        Long count = (Long)this.finderCache.getResult(this._finderPathWithPaginationCountByG_C, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
                sb.append(" AND ");
            }
            sb.append(_FINDER_COLUMN_G_C_COMMERCEADDRESSID_2);
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceAddressId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathWithPaginationCountByG_C, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipment> findByG_S(long groupId, int status) {
        return this.findByG_S(groupId, status, -1, -1, null);
    }

    public List<CommerceShipment> findByG_S(long groupId, int status, int start, int end) {
        return this.findByG_S(groupId, status, start, end, null);
    }

    public List<CommerceShipment> findByG_S(long groupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByG_S(groupId, status, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByG_S(long groupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_S;
                finderArgs = new Object[]{groupId, status};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_S;
            finderArgs = new Object[]{groupId, status, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (groupId == commerceShipment.getGroupId() && status == commerceShipment.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            sb.append("commerceShipment.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_S_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findByG_S_First(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByG_S_First(groupId, status, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByG_S_First(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findByG_S(groupId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findByG_S_Last(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByG_S_Last(groupId, status, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", status=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchShipmentException(sb.toString());
    }

    public CommerceShipment fetchByG_S_Last(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countByG_S(groupId, status);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findByG_S(groupId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findByG_S_PrevAndNext(long commerceShipmentId, long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getByG_S_PrevAndNext(session, commerceShipment, groupId, status, orderByComparator, true), commerceShipment, this.getByG_S_PrevAndNext(session, commerceShipment, groupId, status, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getByG_S_PrevAndNext(Session session, CommerceShipment commerceShipment, long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        sb.append("commerceShipment.groupId = ? AND ");
        sb.append(_FINDER_COLUMN_G_S_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public List<CommerceShipment> findByG_S(long[] groupIds, int status) {
        return this.findByG_S(groupIds, status, -1, -1, null);
    }

    public List<CommerceShipment> findByG_S(long[] groupIds, int status, int start, int end) {
        return this.findByG_S(groupIds, status, start, end, null);
    }

    public List<CommerceShipment> findByG_S(long[] groupIds, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByG_S(groupIds, status, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByG_S(long[] groupIds, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        if (groupIds.length == 1) {
            return this.findByG_S(groupIds[0], status, start, end, orderByComparator);
        }
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderArgs = new Object[]{StringUtil.merge((long[])groupIds), status};
            }
        } else if (useFinderCache) {
            finderArgs = new Object[]{StringUtil.merge((long[])groupIds), status, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(this._finderPathWithPaginationFindByG_S, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (ArrayUtil.contains((long[])groupIds, (long)commerceShipment.getGroupId()) && status == commerceShipment.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
                sb.append(" AND ");
            }
            sb.append(_FINDER_COLUMN_G_S_STATUS_2);
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(this._finderPathWithPaginationFindByG_S, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeByG_S(long groupId, int status) {
        for (CommerceShipment commerceShipment : this.findByG_S(groupId, status, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countByG_S(long groupId, int status) {
        FinderPath finderPath = this._finderPathCountByG_S;
        Object[] finderArgs = new Object[]{groupId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            sb.append("commerceShipment.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_S_STATUS_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByG_S(long[] groupIds, int status) {
        if (groupIds == null) {
            groupIds = new long[]{};
        } else if (groupIds.length > 1) {
            groupIds = ArrayUtil.sortedUnique((long[])groupIds);
        }
        Object[] finderArgs = new Object[]{StringUtil.merge((long[])groupIds), status};
        Long count = (Long)this.finderCache.getResult(this._finderPathWithPaginationCountByG_S, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler();
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            if (groupIds.length > 0) {
                sb.append("(");
                sb.append("commerceShipment.groupId IN (");
                sb.append(StringUtil.merge((long[])groupIds));
                sb.append(")");
                sb.append(")");
                sb.append(" AND ");
            }
            sb.append(_FINDER_COLUMN_G_S_STATUS_2);
            sb.setStringAt(CommerceShipmentPersistenceImpl.removeConjunction((String)sb.stringAt(sb.index() - 1)), sb.index() - 1);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathWithPaginationCountByG_S, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceShipment findByERC_C(String externalReferenceCode, long companyId) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByERC_C(externalReferenceCode, companyId);
        if (commerceShipment == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append(", companyId=");
            sb.append(companyId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchShipmentException(sb.toString());
        }
        return commerceShipment;
    }

    public CommerceShipment fetchByERC_C(String externalReferenceCode, long companyId) {
        return this.fetchByERC_C(externalReferenceCode, companyId, true);
    }

    public CommerceShipment fetchByERC_C(String externalReferenceCode, long companyId, boolean useFinderCache) {
        CommerceShipment commerceShipment;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{externalReferenceCode, companyId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByERC_C, finderArgs, (BasePersistence)this);
        }
        if (result instanceof CommerceShipment && (!Objects.equals(externalReferenceCode, (commerceShipment = (CommerceShipment)result).getExternalReferenceCode()) || companyId != commerceShipment.getCompanyId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_2);
            }
            sb.append("commerceShipment.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                queryPos.add(companyId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByERC_C, finderArgs, (Object)list);
                    }
                } else {
                    CommerceShipment commerceShipment2 = (CommerceShipment)list.get(0);
                    result = commerceShipment2;
                    this.cacheResult(commerceShipment2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceShipment)result;
    }

    public CommerceShipment removeByERC_C(String externalReferenceCode, long companyId) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByERC_C(externalReferenceCode, companyId);
        return (CommerceShipment)this.remove((BaseModel)commerceShipment);
    }

    public int countByERC_C(String externalReferenceCode, long companyId) {
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        FinderPath finderPath = this._finderPathCountByERC_C;
        Object[] finderArgs = new Object[]{externalReferenceCode, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_ERC_C_EXTERNALREFERENCECODE_2);
            }
            sb.append("commerceShipment.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceShipmentPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(CommerceShipment.class);
        this.setModelImplClass(CommerceShipmentImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CommerceShipmentTable.INSTANCE);
    }

    public void cacheResult(CommerceShipment commerceShipment) {
        this.entityCache.putResult(CommerceShipmentImpl.class, (Serializable)Long.valueOf(commerceShipment.getPrimaryKey()), (Serializable)commerceShipment);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{commerceShipment.getUuid(), commerceShipment.getGroupId()}, (Object)commerceShipment);
        this.finderCache.putResult(this._finderPathFetchByERC_C, new Object[]{commerceShipment.getExternalReferenceCode(), commerceShipment.getCompanyId()}, (Object)commerceShipment);
    }

    public void cacheResult(List<CommerceShipment> commerceShipments) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && commerceShipments.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (CommerceShipment commerceShipment : commerceShipments) {
            if (this.entityCache.getResult(CommerceShipmentImpl.class, (Serializable)Long.valueOf(commerceShipment.getPrimaryKey())) != null) continue;
            this.cacheResult(commerceShipment);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceShipmentImpl.class);
        this.finderCache.clearCache(CommerceShipmentImpl.class);
    }

    public void clearCache(CommerceShipment commerceShipment) {
        this.entityCache.removeResult(CommerceShipmentImpl.class, (BaseModel)commerceShipment);
    }

    public void clearCache(List<CommerceShipment> commerceShipments) {
        for (CommerceShipment commerceShipment : commerceShipments) {
            this.entityCache.removeResult(CommerceShipmentImpl.class, (BaseModel)commerceShipment);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(CommerceShipmentImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceShipmentImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CommerceShipmentModelImpl commerceShipmentModelImpl) {
        Object[] args = new Object[]{commerceShipmentModelImpl.getUuid(), commerceShipmentModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)commerceShipmentModelImpl);
        args = new Object[]{commerceShipmentModelImpl.getExternalReferenceCode(), commerceShipmentModelImpl.getCompanyId()};
        this.finderCache.putResult(this._finderPathCountByERC_C, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByERC_C, args, (Object)commerceShipmentModelImpl);
    }

    public CommerceShipment create(long commerceShipmentId) {
        CommerceShipmentImpl commerceShipment = new CommerceShipmentImpl();
        commerceShipment.setNew(true);
        commerceShipment.setPrimaryKey(commerceShipmentId);
        String uuid = this._portalUUID.generate();
        commerceShipment.setUuid(uuid);
        commerceShipment.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceShipment;
    }

    public CommerceShipment remove(long commerceShipmentId) throws NoSuchShipmentException {
        return this.remove(Long.valueOf(commerceShipmentId));
    }

    public CommerceShipment remove(Serializable primaryKey) throws NoSuchShipmentException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment commerceShipment = (CommerceShipment)session.get(CommerceShipmentImpl.class, primaryKey);
            if (commerceShipment == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchShipmentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceShipment commerceShipment2 = (CommerceShipment)this.remove((BaseModel)commerceShipment);
            return commerceShipment2;
        }
        catch (NoSuchShipmentException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment removeImpl(CommerceShipment commerceShipment) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceShipment)) {
                commerceShipment = (CommerceShipment)session.get(CommerceShipmentImpl.class, commerceShipment.getPrimaryKeyObj());
            }
            if (commerceShipment != null) {
                session.delete((Object)commerceShipment);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceShipment != null) {
            this.clearCache(commerceShipment);
        }
        return commerceShipment;
    }

    public CommerceShipment updateImpl(CommerceShipment commerceShipment) {
        boolean isNew = commerceShipment.isNew();
        if (!(commerceShipment instanceof CommerceShipmentModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceShipment.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceShipment);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceShipment proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceShipment implementation " + commerceShipment.getClass());
        }
        CommerceShipmentModelImpl commerceShipmentModelImpl = (CommerceShipmentModelImpl)commerceShipment;
        if (Validator.isNull((String)commerceShipment.getUuid())) {
            String uuid = this._portalUUID.generate();
            commerceShipment.setUuid(uuid);
        }
        if (Validator.isNull((String)commerceShipment.getExternalReferenceCode())) {
            commerceShipment.setExternalReferenceCode(commerceShipment.getUuid());
        } else {
            CommerceShipment ercCommerceShipment = this.fetchByERC_C(commerceShipment.getExternalReferenceCode(), commerceShipment.getCompanyId());
            if (isNew ? ercCommerceShipment != null : ercCommerceShipment != null && commerceShipment.getCommerceShipmentId() != ercCommerceShipment.getCommerceShipmentId()) {
                throw new DuplicateCommerceShipmentExternalReferenceCodeException("Duplicate commerce shipment with external reference code " + commerceShipment.getExternalReferenceCode() + " and company " + commerceShipment.getCompanyId());
            }
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && commerceShipment.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceShipment.setCreateDate(date);
            } else {
                commerceShipment.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!commerceShipmentModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceShipment.setModifiedDate(date);
            } else {
                commerceShipment.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceShipment);
            } else {
                commerceShipment = (CommerceShipment)session.merge((Object)commerceShipment);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CommerceShipmentImpl.class, (BaseModel)commerceShipmentModelImpl, false, true);
        this.cacheUniqueFindersCache(commerceShipmentModelImpl);
        if (isNew) {
            commerceShipment.setNew(false);
        }
        commerceShipment.resetOriginalValues();
        return commerceShipment;
    }

    public CommerceShipment findByPrimaryKey(Serializable primaryKey) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = (CommerceShipment)this.fetchByPrimaryKey(primaryKey);
        if (commerceShipment == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchShipmentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceShipment;
    }

    public CommerceShipment findByPrimaryKey(long commerceShipmentId) throws NoSuchShipmentException {
        return this.findByPrimaryKey(Long.valueOf(commerceShipmentId));
    }

    public CommerceShipment fetchByPrimaryKey(long commerceShipmentId) {
        return (CommerceShipment)this.fetchByPrimaryKey(Long.valueOf(commerceShipmentId));
    }

    public List<CommerceShipment> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceShipment> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceShipment> findAll(int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findAll(int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCESHIPMENT);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCESHIPMENT;
                sql = sql.concat(" ORDER BY commerceShipment.createDate DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceShipment commerceShipment : this.findAll()) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCESHIPMENT);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "commerceShipmentId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_COMMERCESHIPMENT;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceShipmentModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathFetchByUUID_G = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, true);
        this._finderPathCountByUUID_G = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, true);
        this._finderPathCountByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, false);
        this._finderPathWithPaginationCountByGroupId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByGroupId", new String[]{Long.class.getName()}, new String[]{"groupId"}, false);
        this._finderPathWithPaginationFindByG_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId", "commerceAddressId"}, true);
        this._finderPathWithoutPaginationFindByG_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "commerceAddressId"}, true);
        this._finderPathCountByG_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "commerceAddressId"}, false);
        this._finderPathWithPaginationCountByG_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByG_C", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "commerceAddressId"}, false);
        this._finderPathWithPaginationFindByG_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId", "status"}, true);
        this._finderPathWithoutPaginationFindByG_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"groupId", "status"}, true);
        this._finderPathCountByG_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"groupId", "status"}, false);
        this._finderPathWithPaginationCountByG_S = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByG_S", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"groupId", "status"}, false);
        this._finderPathFetchByERC_C = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByERC_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"externalReferenceCode", "companyId"}, true);
        this._finderPathCountByERC_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByERC_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"externalReferenceCode", "companyId"}, false);
        CommerceShipmentUtil.setPersistence((CommerceShipmentPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        CommerceShipmentUtil.setPersistence(null);
        this.entityCache.removeCache(CommerceShipmentImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.commerce.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.commerce.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.commerce.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

