/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v8_4_1;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.util.ArrayList;
import java.util.List;

public class CommerceAccountRoleUpgradeProcess
extends UpgradeProcess {
    private final CompanyLocalService _companyLocalService;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public CommerceAccountRoleUpgradeProcess(CompanyLocalService companyLocalService, ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._companyLocalService = companyLocalService;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        ArrayList<String> actionIds = new ArrayList<String>();
        actionIds.add("MANAGE_ADDRESSES");
        actionIds.add("VIEW_ADDRESSES");
        this._resourceActionLocalService.checkResourceActions("com.liferay.commerce.order", actionIds);
        this._companyLocalService.forEachCompanyId(companyId -> {
            this._updateCommerceAccountRoles((long)companyId, "Account Administrator", "com.liferay.commerce.order", (List<String>)actionIds);
            this._updateCommerceAccountRoles((long)companyId, "Buyer", "com.liferay.commerce.order", (List<String>)actionIds);
            this._updateCommerceAccountRoles((long)companyId, "Order Manager", "com.liferay.commerce.order", (List<String>)actionIds);
        });
    }

    private void _addResourcePermission(long companyId, Role role, String resourceName, String actionId) throws PortalException {
        this._resourcePermissionLocalService.addResourcePermission(companyId, resourceName, 3, String.valueOf(0L), role.getRoleId(), actionId);
    }

    private void _updateCommerceAccountRoles(long companyId, String name, String resourceName, List<String> actionIds) throws PortalException {
        Role role = this._roleLocalService.fetchRole(companyId, name);
        if (role == null) {
            return;
        }
        for (String actionId : actionIds) {
            this._addResourcePermission(companyId, role, resourceName, actionId);
        }
    }
}

