/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.security.permission.resource;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.context.CommerceContextThreadLocal;
import com.liferay.commerce.context.CommerceGroupThreadLocal;
import com.liferay.commerce.internal.util.AccountEntryUtil;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.Arrays;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountEntry", "service.ranking:Integer=100"}, service={ModelResourcePermission.class})
public class AccountEntryModelResourcePermission
implements ModelResourcePermission<AccountEntry> {
    private static final List<String> _permissions = Arrays.asList("MANAGE_ADDRESSES", "MANAGE_USERS", "UPDATE", "VIEW", "VIEW_ACCOUNT_GROUPS", "VIEW_ACCOUNT_ROLES", "VIEW_ADDRESSES", "VIEW_USERS");
    @Reference(target="(component.name=com.liferay.account.internal.security.permission.resource.AccountEntryModelResourcePermission)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private CommerceChannelAccountEntryRelLocalService _commerceChannelAccountEntryRelLocalService;

    public void check(PermissionChecker permissionChecker, AccountEntry accountEntry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), accountEntry.getAccountEntryId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long accountEntryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountEntryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), accountEntryId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, AccountEntry accountEntry, String actionId) throws PortalException {
        return this.contains(permissionChecker, accountEntry.getAccountEntryId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long accountEntryId, String actionId) throws PortalException {
        if (this._accountEntryModelResourcePermission.contains(permissionChecker, accountEntryId, actionId)) {
            return true;
        }
        if (accountEntryId == 0L) {
            return permissionChecker.hasPermission(null, AccountEntry.class.getName(), 0L, "MANAGE_AVAILABLE_ACCOUNTS_VIA_USER_CHANNEL_REL");
        }
        if (_permissions.contains(actionId) && this._accountEntryModelResourcePermission.contains(permissionChecker, accountEntryId, "MANAGE_AVAILABLE_ACCOUNTS_VIA_USER_CHANNEL_REL")) {
            User user = permissionChecker.getUser();
            CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = null;
            long commerceChannelId = AccountEntryUtil.getCommerceChannelId(CommerceContextThreadLocal.get(), CommerceGroupThreadLocal.get());
            if (commerceChannelId > 0L) {
                commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntryId, User.class.getName(), user.getUserId(), commerceChannelId, 7);
            }
            if (commerceChannelAccountEntryRel != null) {
                return true;
            }
            commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntryId, User.class.getName(), user.getUserId(), 0L, 7);
            if (commerceChannelAccountEntryRel != null) {
                return true;
            }
        }
        return false;
    }

    public String getModelName() {
        return AccountEntry.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._accountEntryModelResourcePermission.getPortletResourcePermission();
    }
}

