/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.order.status.CommerceOrderStatusRegistry;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"commerce.order.status.key=22", "commerce.order.status.priority:Integer=50"}, service={CommerceOrderStatus.class})
public class QuoteProcessedCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 22;
    public static final int PRIORITY = 50;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderStatusRegistry _commerceOrderStatusRegistry;
    @Reference
    private Language _language;
    @Reference(target="(resource.name=com.liferay.commerce.order)")
    private PortletResourcePermission _portletResourcePermission;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId, boolean secure) throws PortalException {
        commerceOrder.setOrderStatus(22);
        commerceOrder = this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
        return this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
    }

    public int getKey() {
        return 22;
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, CommerceOrderConstants.getOrderStatusLabel((int)22));
    }

    public int getPriority() {
        return 50;
    }

    public boolean isComplete(CommerceOrder commerceOrder) {
        return commerceOrder.getOrderStatus() == 22;
    }

    public boolean isEnabled(CommerceOrder commerceOrder) throws PortalException {
        return commerceOrder.isQuote();
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        return (commerceOrder.getOrderStatus() == 21 || commerceOrder.getOrderStatus() == 20) && this._portletResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_QUOTES");
    }
}

