/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.system;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionTable;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Product;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductResource;
import com.liferay.object.field.builder.BooleanObjectFieldBuilder;
import com.liferay.object.field.builder.LongIntegerObjectFieldBuilder;
import com.liferay.object.field.builder.TextObjectFieldBuilder;
import com.liferay.object.model.ObjectField;
import com.liferay.object.system.BaseSystemObjectDefinitionManager;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=true, service={SystemObjectDefinitionManager.class})
public class CPDefinitionSystemObjectDefinitionManager
extends BaseSystemObjectDefinitionManager {
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private ProductResource.Factory _productResourceFactory;

    public long addBaseModel(User user, Map<String, Object> values) throws Exception {
        ProductResource productResource = this._buildProductResource(user);
        Product product = productResource.postProduct(this._toProduct(values));
        this.setExtendedProperties(Product.class.getName(), product, user, values);
        return product.getId();
    }

    public BaseModel<?> deleteBaseModel(BaseModel<?> baseModel) throws PortalException {
        return this._cpDefinitionLocalService.deleteCPDefinition((CPDefinition)baseModel);
    }

    public BaseModel<?> fetchBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this._cProductLocalService.fetchCProductByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public BaseModel<?> getBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CProduct cProduct = this._cProductLocalService.getCProductByExternalReferenceCode(externalReferenceCode, companyId);
        return this._cpDefinitionLocalService.getCProductCPDefinition(cProduct.getCProductId(), cProduct.getLatestVersion());
    }

    public String getBaseModelExternalReferenceCode(long primaryKey) throws PortalException {
        CProduct cProduct = this._cProductLocalService.getCProduct(primaryKey);
        return cProduct.getExternalReferenceCode();
    }

    public String getExternalReferenceCode() {
        return "L_COMMERCE_PRODUCT_DEFINITION";
    }

    public JaxRsApplicationDescriptor getJaxRsApplicationDescriptor() {
        return new JaxRsApplicationDescriptor("Liferay.Headless.Commerce.Admin.Catalog", "headless-commerce-admin-catalog", "products", "v1.0");
    }

    public Map<Locale, String> getLabelMap() {
        return this.createLabelMap("cp-definition");
    }

    public Class<?> getModelClass() {
        return CPDefinition.class;
    }

    public List<ObjectField> getObjectFields() {
        return Arrays.asList(new BooleanObjectFieldBuilder().labelMap(this.createLabelMap("active")).name("active").required(true).system(true).build(), new LongIntegerObjectFieldBuilder().labelMap(this.createLabelMap("catalog-id")).name("catalogId").required(true).system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("description")).name("description").system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("name")).name("name").required(true).system(true).build(), new TextObjectFieldBuilder().dbColumnName("CPDefinitionId").labelMap(this.createLabelMap("product-id")).name("productId").system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("product-type")).name("productType").required(true).system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("short-description")).name("shortDescription").system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("sku")).name("skuFormatted").system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("thumbnail")).name("thumbnail").system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("uuid")).name("uuid").system(true).build());
    }

    public Map<Locale, String> getPluralLabelMap() {
        return this.createLabelMap("cp-definitions");
    }

    public Column<?, Long> getPrimaryKeyColumn() {
        return CPDefinitionTable.INSTANCE.CPDefinitionId;
    }

    public String getRESTDTOIdPropertyName() {
        return "productId";
    }

    public String getScope() {
        return "company";
    }

    public Table getTable() {
        return CPDefinitionTable.INSTANCE;
    }

    public String getTitleObjectFieldName() {
        return "name";
    }

    public int getVersion() {
        return 2;
    }

    public void updateBaseModel(long primaryKey, User user, Map<String, Object> values) throws Exception {
        ProductResource productResource = this._buildProductResource(user);
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(primaryKey);
        productResource.patchProduct(Long.valueOf(cpDefinition.getCProductId()), this._toProduct(values));
        this.setExtendedProperties(Product.class.getName(), JSONUtil.put((String)"id", (Object)primaryKey), user, values);
    }

    private ProductResource _buildProductResource(User user) {
        ProductResource.Builder builder = this._productResourceFactory.create();
        return builder.checkPermissions(false).preferredLocale(user.getLocale()).user(user).build();
    }

    private Product _toProduct(final Map<String, Object> values) {
        return new Product(){
            {
                this.active = GetterUtil.getBoolean(values.get("active"));
                this.catalogId = GetterUtil.getLong(values.get("catalogId"));
                this.description = CPDefinitionSystemObjectDefinitionManager.this.getLanguageIdMap("description", values);
                this.externalReferenceCode = GetterUtil.getString(values.get("externalReferenceCode"));
                this.name = CPDefinitionSystemObjectDefinitionManager.this.getLanguageIdMap("name", values);
                this.productId = GetterUtil.getLong(values.get("productId"));
                this.productType = GetterUtil.getString(values.get("productType"));
                this.shortDescription = CPDefinitionSystemObjectDefinitionManager.this.getLanguageIdMap("shortDescription", values);
                this.skuFormatted = GetterUtil.getString(values.get("skuFormatted"));
                this.thumbnail = GetterUtil.getString(values.get("thumbnail"));
            }
        };
    }
}

