/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.impl.CommerceOrderItemImpl;
import com.liferay.commerce.service.persistence.CommerceOrderItemFinder;
import com.liferay.commerce.service.persistence.impl.CommerceOrderItemFinderBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceOrderItemFinder.class})
public class CommerceOrderItemFinderImpl
extends CommerceOrderItemFinderBaseImpl
implements CommerceOrderItemFinder {
    public static final String COUNT_BY_G_A_O = CommerceOrderItemFinder.class.getName() + ".countByG_A_O";
    public static final String FIND_BY_AVAILABLE_QUANTITY = CommerceOrderItemFinder.class.getName() + ".findByAvailableQuantity";
    public static final String FIND_BY_G_A_O = CommerceOrderItemFinder.class.getName() + ".findByG_A_O";
    public static final String GET_COMMERCE_ORDER_ITEMS_QUANTITY = CommerceOrderItemFinder.class.getName() + ".getCommerceOrderItemsQuantity";
    public static final String SUM_VALUE = "SUM_VALUE";
    @Reference
    private CustomSQL _customSQL;

    public int countByG_A_O(long groupId, long commerceAccountId, int[] orderStatuses) {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_A_O);
            sql = this.replaceOrderStatus(sql, orderStatuses);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(commerceAccountId);
            queryPos.add(groupId);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceOrderItem> findByAvailableQuantity(long commerceOrderId) {
        return this.findByAvailableQuantity(commerceOrderId, -1, -1);
    }

    public List<CommerceOrderItem> findByAvailableQuantity(long commerceOrderId, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_AVAILABLE_QUANTITY);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommerceOrderItem", CommerceOrderItemImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(commerceOrderId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceOrderItem> findByG_A_O(long groupId, long commerceAccountId, int[] orderStatuses, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_A_O);
            sql = this.replaceOrderStatus(sql, orderStatuses);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CommerceOrderItem", CommerceOrderItemImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(commerceAccountId);
            queryPos.add(groupId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int getCommerceOrderItemsQuantity(long commerceOrderId) {
        Session session = null;
        try {
            Long sum;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), GET_COMMERCE_ORDER_ITEMS_QUANTITY);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar(SUM_VALUE, Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(commerceOrderId);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (sum = (Long)iterator.next()) != null) {
                int n = sum.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String replaceOrderStatus(String sql, int[] orderStatuses) {
        StringBundler sb = new StringBundler(orderStatuses.length);
        for (int i = 0; i < orderStatuses.length; ++i) {
            sb.append(orderStatuses[i]);
            if (i == orderStatuses.length - 1) continue;
            sb.append(", ");
        }
        return StringUtil.replace((String)sql, (String)"[$ORDER_STATUS$]", (String)sb.toString());
    }
}

