/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.commerce.service.base.CommerceOrderItemServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceOrderItem"}, service={AopService.class})
public class CommerceOrderItemServiceImpl
extends CommerceOrderItemServiceBaseImpl {
    @Reference
    protected CommerceProductViewPermission commerceProductViewPermission;
    @Reference
    protected CPInstanceLocalService cpInstanceLocalService;
    @Reference(target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)")
    private ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference(target="(resource.name=com.liferay.commerce.order)")
    private PortletResourcePermission _portletResourcePermission;

    public CommerceOrderItem addCommerceOrderItem(long commerceOrderId, long cpInstanceId, String json, int quantity, long replacedCPInstanceId, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderItemLocalService.addCommerceOrderItem(this.getUserId(), commerceOrderId, cpInstanceId, json, quantity, replacedCPInstanceId, shippedQuantity, commerceContext, serviceContext);
    }

    public CommerceOrderItem addOrUpdateCommerceOrderItem(long commerceOrderId, long cpInstanceId, String json, int quantity, long replacedCPInstanceId, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        AccountEntry accountEntry = commerceContext.getAccountEntry();
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this._commerceOrderService.getCommerceOrder(commerceOrderId), "UPDATE");
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        this.commerceProductViewPermission.check(this.getPermissionChecker(), accountEntry.getAccountEntryId(), commerceContext.getCommerceChannelGroupId(), cpInstance.getCPDefinitionId());
        return this.commerceOrderItemLocalService.addOrUpdateCommerceOrderItem(this.getUserId(), commerceOrderId, cpInstanceId, json, quantity, replacedCPInstanceId, shippedQuantity, commerceContext, serviceContext);
    }

    public int countSubscriptionCommerceOrderItems(long commerceOrderId) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.countSubscriptionCommerceOrderItems(commerceOrderId);
    }

    public void deleteCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        this.commerceOrderItemLocalService.deleteCommerceOrderItem(this.getUserId(), commerceOrderItem);
    }

    public void deleteCommerceOrderItem(long commerceOrderItemId, CommerceContext commerceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        this.commerceOrderItemLocalService.deleteCommerceOrderItem(this.getUserId(), commerceOrderItem, commerceContext);
    }

    public void deleteCommerceOrderItems(long commerceOrderId) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        this.commerceOrderItemLocalService.deleteCommerceOrderItems(this.getUserId(), commerceOrderId);
    }

    public void deleteMissingCommerceOrderItems(long commerceOrderId, Long[] commerceOrderItemIds, String[] externalReferenceCodes) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        this.commerceOrderItemLocalService.deleteMissingCommerceOrderItems(this.getUserId(), commerceOrderId, commerceOrderItemIds, externalReferenceCodes);
    }

    public CommerceOrderItem fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceOrderItem != null) {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        }
        return commerceOrderItem;
    }

    public CommerceOrderItem fetchCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.fetchCommerceOrderItem(commerceOrderItemId);
        if (commerceOrderItem != null) {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        }
        return commerceOrderItem;
    }

    public List<CommerceOrderItem> getAvailableForShipmentCommerceOrderItems(long commerceOrderId) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getAvailableForShipmentCommerceOrderItems(commerceOrderId);
    }

    public List<CommerceOrderItem> getChildCommerceOrderItems(long parentCommerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.fetchCommerceOrderItem(parentCommerceOrderItemId);
        if (commerceOrderItem != null) {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
            return this.commerceOrderItemLocalService.getChildCommerceOrderItems(parentCommerceOrderItemId);
        }
        return Collections.emptyList();
    }

    public int getCommerceInventoryWarehouseItemQuantity(long commerceOrderItemId, long commerceInventoryWarehouseId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        return this.commerceOrderItemLocalService.getCommerceInventoryWarehouseItemQuantity(commerceOrderItemId, commerceInventoryWarehouseId);
    }

    public CommerceOrderItem getCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
        return commerceOrderItem;
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItems(commerceOrderId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long groupId, long commerceAccountId, int[] orderStatuses, int start, int end) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), commerceAccountId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItems(groupId, commerceAccountId, orderStatuses, start, end);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItemsCount(commerceOrderId);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId, long cpInstanceId) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItemsCount(commerceOrderId, cpInstanceId);
    }

    public int getCommerceOrderItemsCount(long groupId, long commerceAccountId, int[] orderStatuses) throws PortalException {
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), commerceAccountId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItemsCount(groupId, commerceAccountId, orderStatuses);
    }

    public int getCommerceOrderItemsQuantity(long commerceOrderId) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.getCommerceOrderItemsQuantity(commerceOrderId);
    }

    public List<CommerceOrderItem> getSupplierCommerceOrderItems(long customerCommerceOrderItemId, int start, int end) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.fetchCommerceOrderItem(customerCommerceOrderItemId);
        if (commerceOrderItem != null) {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "VIEW");
            return this.commerceOrderItemLocalService.getSupplierCommerceOrderItems(customerCommerceOrderItemId, start, end);
        }
        return Collections.emptyList();
    }

    public CommerceOrderItem importCommerceOrderItem(String externalReferenceCode, long commerceOrderItemId, long commerceOrderId, long cpInstanceId, String cpMeasurementUnitKey, BigDecimal decimalQuantity, int quantity, int shippedQuantity, ServiceContext serviceContext) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "UPDATE");
        return this.commerceOrderItemLocalService.importCommerceOrderItem(this.getUserId(), externalReferenceCode, commerceOrderItemId, commerceOrderId, cpInstanceId, cpMeasurementUnitKey, decimalQuantity, quantity, shippedQuantity, serviceContext);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, long parentCommerceOrderItemId, String keywords, int start, int end, Sort sort) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.searchCommerceOrderItems(commerceOrderId, parentCommerceOrderItemId, keywords, start, end, sort);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, String keywords, int start, int end, Sort sort) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.searchCommerceOrderItems(commerceOrderId, keywords, start, end, sort);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, String name, String sku, boolean andOperator, int start, int end, Sort sort) throws PortalException {
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "VIEW");
        return this.commerceOrderItemLocalService.searchCommerceOrderItems(commerceOrderId, name, sku, andOperator, start, end, sort);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(this.getUserId(), commerceOrderItemId, quantity, commerceContext, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, long cpMeasurementUnitId, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(this.getUserId(), commerceOrderItemId, cpMeasurementUnitId, quantity, commerceContext, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, long cpMeasurementUnitId, int quantity, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(this.getUserId(), commerceOrderItemId, cpMeasurementUnitId, quantity, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, String json, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(this.getUserId(), commerceOrderItem.getCommerceOrderItemId(), json, quantity, commerceContext, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItemDeliveryDate(long commerceOrderItemId, Date requestedDeliveryDate) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemDeliveryDate(commerceOrderItemId, requestedDeliveryDate);
    }

    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, long shippingAddressId, String deliveryGroup, String printedNote) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemInfo(commerceOrderItemId, shippingAddressId, deliveryGroup, printedNote);
    }

    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, long shippingAddressId, String deliveryGroup, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemInfo(commerceOrderItemId, shippingAddressId, deliveryGroup, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, String deliveryGroup, long shippingAddressId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        return this.commerceOrderItemService.updateCommerceOrderItemInfo(commerceOrderItemId, shippingAddressId, deliveryGroup, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear);
    }

    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal discountAmount, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel4, BigDecimal finalPrice, BigDecimal promoPrice, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemPrices(commerceOrderItemId, discountAmount, discountPercentageLevel1, discountPercentageLevel2, discountPercentageLevel3, discountPercentageLevel4, finalPrice, promoPrice, unitPrice);
    }

    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal discountAmount, BigDecimal discountAmountWithTaxAmount, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel1WithTaxAmount, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel2WithTaxAmount, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel3WithTaxAmount, BigDecimal discountPercentageLevel4, BigDecimal discountPercentageLevel4WithTaxAmount, BigDecimal finalPrice, BigDecimal finalPriceWithTaxAmount, BigDecimal promoPrice, BigDecimal promoPriceWithTaxAmount, BigDecimal unitPrice, BigDecimal unitPriceWithTaxAmount) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemPrices(commerceOrderItemId, discountAmount, discountAmountWithTaxAmount, discountPercentageLevel1, discountPercentageLevel1WithTaxAmount, discountPercentageLevel2, discountPercentageLevel2WithTaxAmount, discountPercentageLevel3, discountPercentageLevel3WithTaxAmount, discountPercentageLevel4, discountPercentageLevel4WithTaxAmount, finalPrice, finalPriceWithTaxAmount, promoPrice, promoPriceWithTaxAmount, unitPrice, unitPriceWithTaxAmount);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemUnitPrice(commerceOrderItemId, unitPrice);
    }

    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal decimalQuantity, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemUnitPrice(this.getUserId(), commerceOrderItemId, decimalQuantity, unitPrice);
    }

    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, int quantity, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderItem.getCommerceOrderId());
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrder.getGroupId(), "MANAGE_COMMERCE_ORDER_PRICES");
        return this.commerceOrderItemLocalService.updateCommerceOrderItemUnitPrice(this.getUserId(), commerceOrderItemId, quantity, unitPrice);
    }

    public CommerceOrderItem updateCustomFields(long commerceOrderItemId, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateCustomFields(commerceOrderItemId, serviceContext);
    }

    public CommerceOrderItem updateExternalReferenceCode(long commerceOrderItemId, String externalReferenceCode) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderItem.getCommerceOrderId(), "UPDATE");
        return this.commerceOrderItemLocalService.updateExternalReferenceCode(commerceOrderItemId, externalReferenceCode);
    }
}

