/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v8_1_2;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.util.Collections;

public class CommerceAccountRoleUpgradeProcess
extends UpgradeProcess {
    private final CompanyLocalService _companyLocalService;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public CommerceAccountRoleUpgradeProcess(CompanyLocalService companyLocalService, ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._companyLocalService = companyLocalService;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._resourceActionLocalService.checkResourceActions("com.liferay.commerce.order", Collections.singletonList("MANAGE_COMMERCE_ORDER_PAYMENT_METHODS"));
        this._companyLocalService.forEachCompanyId(companyId -> {
            this._updateCommerceAccountRoles((long)companyId, "Account Administrator");
            this._updateCommerceAccountRoles((long)companyId, "Buyer");
            this._updateCommerceAccountRoles((long)companyId, "Order Manager");
        });
    }

    private void _addResourcePermission(long companyId, Role role, String actionId) throws PortalException {
        this._resourcePermissionLocalService.addResourcePermission(companyId, "com.liferay.commerce.order", 3, String.valueOf(0L), role.getRoleId(), actionId);
    }

    private void _updateCommerceAccountRoles(long companyId, String name) throws PortalException {
        Role role = this._roleLocalService.fetchRole(companyId, name);
        if (role == null) {
            return;
        }
        this._addResourcePermission(companyId, role, "MANAGE_COMMERCE_ORDER_PAYMENT_METHODS");
        this._addResourcePermission(companyId, role, "MANAGE_COMMERCE_ORDER_SHIPPING_OPTIONS");
    }
}

