/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v2_1_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;

public class CPDAvailabilityEstimateUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CPDAvailabilityEstimateUpgradeProcess.class);
    private final CPDefinitionLocalService _cpDefinitionLocalService;

    public CPDAvailabilityEstimateUpgradeProcess(CPDefinitionLocalService cpDefinitionLocalService) {
        this._cpDefinitionLocalService = cpDefinitionLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._addIndexes("CPDAvailabilityEstimate");
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update CPDAvailabilityEstimate set CProductId = ? where CPDefinitionId = ?");
             Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select distinct CPDefinitionId from CPDAvailabilityEstimate");){
            while (resultSet.next()) {
                long cpDefinitionId = resultSet.getLong("CPDefinitionId");
                CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
                preparedStatement.setLong(1, cpDefinition.getCProductId());
                preparedStatement.setLong(2, cpDefinitionId);
                preparedStatement.execute();
            }
        }
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"CPDAvailabilityEstimate", (String[])new String[]{"CProductId LONG"})};
    }

    private void _addIndexes(String tableName) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        List indexesSQL = this.getIndexesSQL(clazz.getClassLoader(), tableName);
        for (ObjectValuePair indexSQL : indexesSQL) {
            IndexMetadata indexMetadata = (IndexMetadata)indexSQL.getValue();
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("Adding index %s to table %s", indexMetadata.getIndexName(), tableName));
            }
            if (!this._tableHasIndex(tableName, indexMetadata.getIndexName())) {
                this.runSQL(indexMetadata.getCreateSQL(null));
                continue;
            }
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)String.format("Index %s already exists on table %s", indexMetadata.getIndexName(), tableName));
        }
    }

    private boolean _tableHasIndex(String tableName, String indexName) throws Exception {
        DatabaseMetaData metadata = this.connection.getMetaData();
        try (ResultSet resultSet = metadata.getIndexInfo(null, null, tableName, false, false);){
            while (resultSet.next()) {
                String curIndexName = resultSet.getString("index_name");
                if (!Objects.equals(indexName, curIndexName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

