/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.order.status.CommerceOrderStatusRegistry;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"commerce.order.status.key=21", "commerce.order.status.priority:Integer=20"}, service={CommerceOrderStatus.class})
public class QuoteRequestedCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 21;
    public static final int PRIORITY = 20;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderStatusRegistry _commerceOrderStatusRegistry;
    @Reference
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @Reference
    private Language _language;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId, boolean secure) throws PortalException {
        commerceOrder.setOrderStatus(21);
        commerceOrder = this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
        return this._commerceOrderLocalService.updateCommerceOrder(commerceOrder);
    }

    public int getKey() {
        return 21;
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, CommerceOrderConstants.getOrderStatusLabel((int)21));
    }

    public int getPriority() {
        return 20;
    }

    public boolean isEnabled(CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder.isOpen()) {
            return true;
        }
        return commerceOrder.isQuote();
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        CommerceOrderStatus currentCommerceOrderStatus = this._commerceOrderStatusRegistry.getCommerceOrderStatus(commerceOrder.getOrderStatus());
        if (currentCommerceOrderStatus.getKey() == 6 || currentCommerceOrderStatus.getKey() == 2) {
            return this._commerceOrderValidatorRegistry.isValid(LocaleUtil.getSiteDefault(), commerceOrder);
        }
        return false;
    }
}

