/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.system;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderTable;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.headless.commerce.admin.order.dto.v1_0.Order;
import com.liferay.headless.commerce.admin.order.resource.v1_0.OrderResource;
import com.liferay.object.field.builder.IntegerObjectFieldBuilder;
import com.liferay.object.field.builder.LongIntegerObjectFieldBuilder;
import com.liferay.object.field.builder.PrecisionDecimalObjectFieldBuilder;
import com.liferay.object.field.builder.TextObjectFieldBuilder;
import com.liferay.object.model.ObjectField;
import com.liferay.object.system.BaseSystemObjectDefinitionManager;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SystemObjectDefinitionManager.class})
public class CommerceOrderSystemObjectDefinitionManager
extends BaseSystemObjectDefinitionManager {
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private OrderResource.Factory _orderResourceFactory;

    public long addBaseModel(User user, Map<String, Object> values) throws Exception {
        OrderResource orderResource = this._buildOrderResource(user);
        Order order = orderResource.postOrder(this._toOrder(values));
        this.setExtendedProperties(Order.class.getName(), order, user, values);
        return order.getId();
    }

    public BaseModel<?> deleteBaseModel(BaseModel<?> baseModel) throws PortalException {
        return this._commerceOrderLocalService.deleteCommerceOrder((CommerceOrder)baseModel);
    }

    public BaseModel<?> fetchBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this._commerceOrderLocalService.fetchCommerceOrderByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public BaseModel<?> getBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this._commerceOrderLocalService.getCommerceOrderByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public String getExternalReferenceCode(long primaryKey) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(primaryKey);
        return commerceOrder.getExternalReferenceCode();
    }

    public JaxRsApplicationDescriptor getJaxRsApplicationDescriptor() {
        return new JaxRsApplicationDescriptor("Liferay.Headless.Commerce.Admin.Order", "headless-commerce-admin-order", "orders", "v1.0");
    }

    public Map<Locale, String> getLabelMap() {
        return this.createLabelMap("commerce-order");
    }

    public Class<?> getModelClass() {
        return CommerceOrder.class;
    }

    public List<ObjectField> getObjectFields() {
        return Arrays.asList(new LongIntegerObjectFieldBuilder().labelMap(this.createLabelMap("account-id")).name("accountId").required(true).system(true).build(), new LongIntegerObjectFieldBuilder().labelMap(this.createLabelMap("channel-id")).name("channelId").required(true).system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("currency-code")).name("currencyCode").required(true).system(true).build(), new IntegerObjectFieldBuilder().labelMap(this.createLabelMap("order-status")).name("orderStatus").required(true).system(true).build(), new TextObjectFieldBuilder().dbColumnName("orderTypeExternalReferenceCode").labelMap(this.createLabelMap("orderTypeExternalReferenceCode")).name("orderTypeExternalReferenceCode").system(true).build(), new LongIntegerObjectFieldBuilder().dbColumnName("orderTypeId").labelMap(this.createLabelMap("order-type-id")).name("orderTypeId").system(true).build(), new PrecisionDecimalObjectFieldBuilder().labelMap(this.createLabelMap("shipping-amount")).name("shippingAmount").required(true).system(true).build());
    }

    public Map<Locale, String> getPluralLabelMap() {
        return this.createLabelMap("commerce-orders");
    }

    public Column<?, Long> getPrimaryKeyColumn() {
        return CommerceOrderTable.INSTANCE.commerceOrderId;
    }

    public String getScope() {
        return "company";
    }

    public Table getTable() {
        return CommerceOrderTable.INSTANCE;
    }

    public int getVersion() {
        return 3;
    }

    public void updateBaseModel(long primaryKey, User user, Map<String, Object> values) throws Exception {
        OrderResource orderResource = this._buildOrderResource(user);
        orderResource.patchOrder(Long.valueOf(primaryKey), this._toOrder(values));
        this.setExtendedProperties(Order.class.getName(), JSONUtil.put((String)"id", (Object)primaryKey), user, values);
    }

    private OrderResource _buildOrderResource(User user) {
        OrderResource.Builder builder = this._orderResourceFactory.create();
        return builder.checkPermissions(false).preferredLocale(user.getLocale()).user(user).build();
    }

    private Order _toOrder(final Map<String, Object> values) {
        return new Order(){
            {
                this.accountId = GetterUtil.getLong(values.get("accountId"));
                this.channelId = GetterUtil.getLong(values.get("channelId"));
                this.currencyCode = GetterUtil.getString(values.get("currencyCode"));
                this.externalReferenceCode = GetterUtil.getString(values.get("externalReferenceCode"));
                this.orderStatus = GetterUtil.getInteger(values.get("orderStatus"));
                this.orderTypeExternalReferenceCode = GetterUtil.getString(values.get("orderTypeExternalReferenceCode"));
                this.orderTypeId = GetterUtil.getLong(values.get("orderTypeId"));
                this.setShippingAmount(() -> {
                    String shippingAmountString = GetterUtil.getString(values.get("shippingAmount"));
                    if (Validator.isNull((String)shippingAmountString)) {
                        return null;
                    }
                    return new BigDecimal(shippingAmountString);
                });
            }
        };
    }
}

