/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.action.executor;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.uuid.PortalUUID;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectActionExecutor.class})
public class SplitCommerceOrderByCatalogObjectActionExecutorImpl
implements ObjectActionExecutor {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private PortalUUID _portalUUID;

    public void execute(long companyId, UnicodeProperties parametersUnicodeProperties, JSONObject payloadJSONObject, long userId) throws Exception {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(payloadJSONObject.getLong("objectDefinitionId"));
        if (objectDefinition.isSystem() && !FeatureFlagManagerUtil.isEnabled((String)"COMMERCE-11026")) {
            throw new UnsupportedOperationException();
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            long commerceOrderId = payloadJSONObject.getLong("classPK");
            CommerceOrder customerCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
            if (this._isSplitted(customerCommerceOrder)) {
                return null;
            }
            Map<CommerceCatalog, List<CommerceOrderItem>> commerceOrderItemMap = this._getCommerceOrderItemMap(customerCommerceOrder.getCommerceOrderItems());
            int numberCommerceOrder = commerceOrderItemMap.size();
            if (numberCommerceOrder > 1) {
                this._createSupplierOrders(customerCommerceOrder, commerceOrderItemMap);
                this._handleBookedQuantity(commerceOrderId);
            }
            return null;
        });
    }

    public String getKey() {
        return "split-commerce-order-by-catalog";
    }

    public boolean isAllowedObjectDefinition(String objectDefinitionName) {
        if (!FeatureFlagManagerUtil.isEnabled((String)"COMMERCE-11026")) {
            return false;
        }
        return StringUtil.equals((String)"CommerceOrder", (String)objectDefinitionName);
    }

    private void _addSupplierBookedQuantity(List<Long> supplierCommerceOrderIds) throws Exception {
        for (Long supplierCommerceOrderId : supplierCommerceOrderIds) {
            CommerceOrder supplierCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(supplierCommerceOrderId.longValue());
            List supplierCommerceOrderItems = supplierCommerceOrder.getCommerceOrderItems();
            AccountEntry accountEntry = supplierCommerceOrder.getAccountEntry();
            for (CommerceOrderItem commerceOrderItem : supplierCommerceOrderItems) {
                CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.addCommerceBookedQuantity(commerceOrderItem.getUserId(), commerceOrderItem.getSku(), commerceOrderItem.getQuantity(), null, (Map)HashMapBuilder.put((Object)"accountName", (Object)accountEntry.getName()).put((Object)"orderId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderId())).put((Object)"orderItemId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderItemId())).build());
                this._commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), commerceInventoryBookedQuantity.getCommerceInventoryBookedQuantityId());
            }
        }
    }

    private BigDecimal _calculateSubtotalDiscountAmount(CommerceOrder customerCommerceOrder, RoundingMode roundingMode, BigDecimal subtotal) {
        BigDecimal newSubtotalDiscountAmount = BigDecimal.ZERO;
        BigDecimal customerSubtotalDiscountAmount = customerCommerceOrder.getSubtotalDiscountAmount();
        if (customerSubtotalDiscountAmount.signum() > 0) {
            BigDecimal customerCommerceOrderSubtotal = customerCommerceOrder.getSubtotal();
            newSubtotalDiscountAmount = customerSubtotalDiscountAmount.multiply(subtotal);
            newSubtotalDiscountAmount = newSubtotalDiscountAmount.divide(customerCommerceOrderSubtotal, roundingMode);
        }
        return newSubtotalDiscountAmount;
    }

    private BigDecimal _calculateTotalDiscountAmount(CommerceOrder customerCommerceOrder, RoundingMode roundingMode, BigDecimal supplierTotal) {
        BigDecimal newTotalDiscountAmount = BigDecimal.ZERO;
        BigDecimal customerTotalDiscountAmount = customerCommerceOrder.getTotalDiscountAmount();
        if (customerTotalDiscountAmount.signum() > 0) {
            BigDecimal customerCommerceOrderTotal = customerCommerceOrder.getTotal();
            newTotalDiscountAmount = customerTotalDiscountAmount.multiply(supplierTotal);
            BigDecimal add = customerCommerceOrderTotal.add(customerTotalDiscountAmount);
            newTotalDiscountAmount = newTotalDiscountAmount.divide(add, roundingMode);
        }
        return newTotalDiscountAmount;
    }

    private void _createSupplierOrders(CommerceOrder customerCommerceOrder, Map<CommerceCatalog, List<CommerceOrderItem>> commerceOrderItemMap) throws Exception {
        CommerceCurrency commerceCurrency = customerCommerceOrder.getCommerceCurrency();
        RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        commerceOrderItemMap.forEach((commerceCatalog, commerceOrderItems) -> {
            List commerceChannels;
            CommerceOrder supplierCommerceOrder = customerCommerceOrder.cloneWithOriginalValues();
            supplierCommerceOrder.setUuid(this._portalUUID.generate());
            supplierCommerceOrder.setExternalReferenceCode(this._portalUUID.generate());
            long newCommerceOrderId = this._counterLocalService.increment();
            supplierCommerceOrder.setCommerceOrderId(newCommerceOrderId);
            long accountEntryId = commerceCatalog.getAccountEntryId();
            CommerceChannel commerceChannel = null;
            if (accountEntryId > 0L && ListUtil.isNotEmpty((List)(commerceChannels = this._commerceChannelLocalService.getCommerceChannelsByAccountEntryId(accountEntryId)))) {
                commerceChannel = (CommerceChannel)commerceChannels.get(0);
            }
            if (commerceChannel != null) {
                supplierCommerceOrder.setGroupId(commerceChannel.getGroupId());
            }
            supplierCommerceOrder.setManuallyAdjusted(true);
            supplierCommerceOrder.setShippingAmount(BigDecimal.ZERO);
            supplierCommerceOrder.setShippingDiscountAmount(BigDecimal.ZERO);
            BigDecimal subtotal = BigDecimal.ZERO;
            BigDecimal taxAmount = BigDecimal.ZERO;
            for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
                CommerceOrderItem newCommerceOrderItem = commerceOrderItem.cloneWithOriginalValues();
                newCommerceOrderItem.setUuid(this._portalUUID.generate());
                newCommerceOrderItem.setExternalReferenceCode(this._portalUUID.generate());
                newCommerceOrderItem.setCommerceOrderItemId(this._counterLocalService.increment());
                if (commerceChannel != null) {
                    newCommerceOrderItem.setGroupId(commerceChannel.getGroupId());
                }
                newCommerceOrderItem.setBookedQuantityId(0L);
                newCommerceOrderItem.setCommerceOrderId(newCommerceOrderId);
                newCommerceOrderItem.setCustomerCommerceOrderItemId(commerceOrderItem.getCommerceOrderItemId());
                newCommerceOrderItem.setParentCommerceOrderItemId(0L);
                newCommerceOrderItem.setDiscountManuallyAdjusted(true);
                newCommerceOrderItem.setManuallyAdjusted(true);
                newCommerceOrderItem.setPriceManuallyAdjusted(true);
                this._commerceOrderItemLocalService.addCommerceOrderItem(newCommerceOrderItem);
                BigDecimal finalPrice = newCommerceOrderItem.getFinalPrice();
                subtotal = subtotal.add(finalPrice);
                BigDecimal finalPriceWithTaxAmount = newCommerceOrderItem.getFinalPriceWithTaxAmount();
                BigDecimal tax = finalPriceWithTaxAmount.subtract(finalPrice);
                taxAmount = taxAmount.add(tax);
            }
            supplierCommerceOrder.setSubtotal(subtotal);
            BigDecimal newSubtotalDiscountAmount = this._calculateSubtotalDiscountAmount(customerCommerceOrder, roundingMode, subtotal);
            supplierCommerceOrder.setSubtotalDiscountAmount(newSubtotalDiscountAmount);
            supplierCommerceOrder.setTaxAmount(taxAmount);
            BigDecimal supplierTotal = subtotal.add(taxAmount);
            BigDecimal newTotalDiscountAmount = this._calculateTotalDiscountAmount(customerCommerceOrder, roundingMode, supplierTotal);
            supplierCommerceOrder.setTotalDiscountAmount(newTotalDiscountAmount);
            supplierTotal = supplierTotal.subtract(newSubtotalDiscountAmount);
            supplierTotal = supplierTotal.subtract(newTotalDiscountAmount);
            supplierCommerceOrder.setTotal(supplierTotal);
            this._commerceOrderLocalService.addCommerceOrder(supplierCommerceOrder);
        });
    }

    private Map<CommerceCatalog, List<CommerceOrderItem>> _getCommerceOrderItemMap(List<CommerceOrderItem> commerceOrderItems) {
        HashMap<CommerceCatalog, List<CommerceOrderItem>> commerceOrderItemMap = new HashMap<CommerceCatalog, List<CommerceOrderItem>>();
        ListUtil.isNotEmptyForEach(commerceOrderItems, commerceOrderItem -> {
            try {
                CPDefinition cpDefinition = commerceOrderItem.getCPDefinition();
                CommerceCatalog commerceCatalog = cpDefinition.getCommerceCatalog();
                if (commerceOrderItemMap.containsKey(commerceCatalog)) {
                    List splitCommerceOrderItems = (List)commerceOrderItemMap.get(commerceCatalog);
                    splitCommerceOrderItems.add(commerceOrderItem);
                    commerceOrderItemMap.put(commerceCatalog, splitCommerceOrderItems);
                } else {
                    commerceOrderItemMap.put(commerceCatalog, ListUtil.toList((Object)commerceOrderItem));
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        });
        return commerceOrderItemMap;
    }

    private void _handleBookedQuantity(long commerceOrderId) throws Exception {
        CommerceOrder customerCommerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        this._releaseCustomerBookedQuantity(customerCommerceOrder.getCommerceOrderItems());
        this._addSupplierBookedQuantity(customerCommerceOrder.getSupplierCommerceOrderIds());
    }

    private boolean _isSplitted(CommerceOrder customerCommerceOrder) {
        int supplierCommerceOrderIdsCount = customerCommerceOrder.getSupplierCommerceOrderIdsCount();
        int customerCommerceOrderIdsCount = customerCommerceOrder.getCustomerCommerceOrderIdsCount();
        return supplierCommerceOrderIdsCount > 0 || customerCommerceOrderIdsCount > 0;
    }

    private void _releaseCustomerBookedQuantity(List<CommerceOrderItem> commerceOrderItems) throws Exception {
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this._commerceInventoryBookedQuantityLocalService.deleteCommerceInventoryBookedQuantity(commerceOrderItem.getBookedQuantityId());
            commerceOrderItem.setBookedQuantityId(0L);
            this._commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem);
        }
    }
}

