/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v8_8_0;

import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.ResultSet;
import java.sql.Statement;

public class CommercePermissionUpgradeProcess
extends UpgradeProcess {
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public CommercePermissionUpgradeProcess(ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (Statement statement = this.connection.createStatement();){
            ResultSet resultSet = statement.executeQuery("select ResourcePermissionId from ResourcePermission where name = 'com.liferay.commerce.account' and scope = 1");
            while (resultSet.next()) {
                ResourceAction organizationResourceAction;
                ResourcePermission resourcePermission = this._resourcePermissionLocalService.getResourcePermission(resultSet.getLong(1));
                ResourceAction resourceAction = this._resourceActionLocalService.fetchResourceAction("com.liferay.commerce.account", "MANAGE_AVAILABLE_ACCOUNTS");
                if (resourceAction == null || !this._resourcePermissionLocalService.hasActionId(resourcePermission, resourceAction) || (organizationResourceAction = this._resourceActionLocalService.fetchResourceAction(Organization.class.getName(), "MANAGE_AVAILABLE_ACCOUNTS")) == null || !this._resourcePermissionLocalService.hasActionId(resourcePermission, resourceAction)) continue;
                Role role = this._roleLocalService.getRole(resourcePermission.getRoleId());
                this._resourcePermissionLocalService.addResourcePermissions(Organization.class.getName(), role.getName(), resourcePermission.getScope(), organizationResourceAction.getBitwiseValue());
                this._resourcePermissionLocalService.removeResourcePermissions(resourcePermission.getCompanyId(), resourcePermission.getName(), resourcePermission.getScope(), resourcePermission.getRoleId(), "MANAGE_AVAILABLE_ACCOUNTS");
            }
        }
    }
}

