/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"commerce.order.status.key=2", "commerce.order.status.priority:Integer=10"}, service={CommerceOrderStatus.class})
public class OpenCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 2;
    public static final int PRIORITY = 10;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CommerceOrderService _commerceOrderService;
    @Reference
    private Language _language;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId) throws PortalException {
        commerceOrder.setOrderStatus(2);
        return this._commerceOrderService.updateCommerceOrder(commerceOrder);
    }

    public int getKey() {
        return 2;
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, CommerceOrderConstants.getOrderStatusLabel((int)2));
    }

    public int getPriority() {
        return 10;
    }

    public boolean isWorkflowEnabled(CommerceOrder commerceOrder) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), 0L, 0L, true);
        return workflowDefinitionLink != null;
    }
}

