/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.status;

import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.order.status.key=6", "commerce.order.status.priority:Integer=20"}, service={CommerceOrderStatus.class})
public class InProgressCommerceOrderStatusImpl
implements CommerceOrderStatus {
    public static final int KEY = 6;
    public static final int PRIORITY = 20;
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)")
    private ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public CommerceOrder doTransition(CommerceOrder commerceOrder, long userId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(commerceOrder.getGroupId());
        serviceContext.setUserId(userId);
        long commerceOrderId = commerceOrder.getCommerceOrderId();
        if (commerceOrder.isDraft()) {
            serviceContext.setWorkflowAction(1);
            commerceOrder = (CommerceOrder)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceOrder.getCompanyId(), (long)commerceOrder.getScopeGroupId(), (long)commerceOrder.getUserId(), (String)CommerceOrder.class.getName(), (long)commerceOrderId, (Object)commerceOrder, (ServiceContext)serviceContext, new HashMap());
            commerceOrder.setStatusByUserId(userId);
            commerceOrder.setStatusByUserName(this._portal.getUserName(userId, ""));
            commerceOrder.setStatusDate(new Date());
            return commerceOrder;
        }
        commerceOrder.setOrderStatus(6);
        return this._commerceOrderService.updateCommerceOrder(commerceOrder);
    }

    public int getKey() {
        return 6;
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, CommerceOrderConstants.getOrderStatusLabel((int)6));
    }

    public int getPriority() {
        return 20;
    }

    public boolean isComplete(CommerceOrder commerceOrder) {
        return !commerceOrder.isOpen();
    }

    public boolean isTransitionCriteriaMet(CommerceOrder commerceOrder) throws PortalException {
        return !commerceOrder.isPending() && this._commerceOrderValidatorRegistry.isValid(LocaleUtil.getSiteDefault(), commerceOrder) && this._commerceOrderModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)commerceOrder, "CHECKOUT_COMMERCE_ORDER");
    }

    public boolean isWorkflowEnabled(CommerceOrder commerceOrder) throws PortalException {
        return false;
    }
}

