/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderNote;
import com.liferay.commerce.service.base.CommerceOrderNoteServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceOrderNote"}, service={AopService.class})
public class CommerceOrderNoteServiceImpl
extends CommerceOrderNoteServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)")
    private ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.commerce.order)")
    private PortletResourcePermission _portletResourcePermission;

    public CommerceOrderNote addCommerceOrderNote(long commerceOrderId, String content, boolean restricted, ServiceContext serviceContext) throws PortalException {
        String actionId = "MANAGE_COMMERCE_ORDER_NOTES";
        if (restricted) {
            actionId = "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES";
        }
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrderId, actionId);
        return this.commerceOrderNoteLocalService.addCommerceOrderNote(commerceOrderId, content, restricted, serviceContext);
    }

    public CommerceOrderNote addOrUpdateCommerceOrderNote(String externalReferenceCode, long commerceOrderNoteId, long commerceOrderId, String content, boolean restricted, ServiceContext serviceContext) throws PortalException {
        String actionId = "MANAGE_COMMERCE_ORDER_NOTES";
        if (restricted) {
            actionId = "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES";
        }
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrderId, actionId);
        return this.commerceOrderNoteLocalService.addOrUpdateCommerceOrderNote(externalReferenceCode, commerceOrderNoteId, commerceOrderId, content, restricted, serviceContext);
    }

    public void deleteCommerceOrderNote(long commerceOrderNoteId) throws PortalException {
        CommerceOrderNote commerceOrderNote = this.commerceOrderNoteLocalService.getCommerceOrderNote(commerceOrderNoteId);
        String actionId = "MANAGE_COMMERCE_ORDER_NOTES";
        if (commerceOrderNote.isRestricted()) {
            actionId = "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES";
        }
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrderNote.getCommerceOrderId(), actionId);
        this.commerceOrderNoteLocalService.deleteCommerceOrderNote(commerceOrderNote);
    }

    public CommerceOrderNote fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceOrderNote commerceOrderNote = this.commerceOrderNoteLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (commerceOrderNote != null) {
            this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrderNote.getCommerceOrderId(), "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES");
        }
        return commerceOrderNote;
    }

    public CommerceOrderNote fetchCommerceOrderNote(long commerceOrderNoteId) throws PortalException {
        CommerceOrderNote commerceOrderNote = this.commerceOrderNoteLocalService.fetchCommerceOrderNote(commerceOrderNoteId);
        this._checkCommerceOrderNotePermissions(commerceOrderNote);
        return commerceOrderNote;
    }

    public CommerceOrderNote getCommerceOrderNote(long commerceOrderNoteId) throws PortalException {
        CommerceOrderNote commerceOrderNote = this.commerceOrderNoteLocalService.getCommerceOrderNote(commerceOrderNoteId);
        this._checkCommerceOrderNotePermissions(commerceOrderNote);
        return commerceOrderNote;
    }

    public List<CommerceOrderNote> getCommerceOrderNotes(long commerceOrderId, boolean restricted) throws PortalException {
        String actionId = "VIEW";
        if (restricted) {
            actionId = "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES";
            this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrderId, actionId);
        } else {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, actionId);
        }
        return this.commerceOrderNoteLocalService.getCommerceOrderNotes(commerceOrderId, restricted);
    }

    public List<CommerceOrderNote> getCommerceOrderNotes(long commerceOrderId, boolean restricted, int start, int end) throws PortalException {
        String actionId = "VIEW";
        if (restricted) {
            actionId = "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES";
            this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrderId, actionId);
        } else {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, actionId);
        }
        return this.commerceOrderNoteLocalService.getCommerceOrderNotes(commerceOrderId, restricted, start, end);
    }

    public List<CommerceOrderNote> getCommerceOrderNotes(long commerceOrderId, int start, int end) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES");
        return this.commerceOrderNoteLocalService.getCommerceOrderNotes(commerceOrderId, start, end);
    }

    public int getCommerceOrderNotesCount(long commerceOrderId) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrderId, "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES");
        return this.commerceOrderNoteLocalService.getCommerceOrderNotesCount(commerceOrderId);
    }

    public int getCommerceOrderNotesCount(long commerceOrderId, boolean restricted) throws PortalException {
        String actionId = "VIEW";
        if (restricted) {
            actionId = "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES";
            this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrderId, actionId);
        } else {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderId, actionId);
        }
        return this.commerceOrderNoteLocalService.getCommerceOrderNotesCount(commerceOrderId, restricted);
    }

    public CommerceOrderNote updateCommerceOrderNote(long commerceOrderNoteId, String content, boolean restricted) throws PortalException {
        CommerceOrderNote commerceOrderNote = this.commerceOrderNoteLocalService.getCommerceOrderNote(commerceOrderNoteId);
        String actionId = "MANAGE_COMMERCE_ORDER_NOTES";
        if (restricted) {
            actionId = "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES";
        }
        this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrderNote.getCommerceOrderId(), actionId);
        return this.commerceOrderNoteLocalService.updateCommerceOrderNote(commerceOrderNote.getCommerceOrderNoteId(), content, restricted);
    }

    private void _checkCommerceOrderNotePermissions(CommerceOrderNote commerceOrderNote) throws PortalException {
        if (commerceOrderNote == null) {
            return;
        }
        String actionId = "VIEW";
        if (commerceOrderNote.isRestricted()) {
            actionId = "MANAGE_COMMERCE_ORDER_RESTRICTED_NOTES";
            this._portletResourcePermission.check(this.getPermissionChecker(), commerceOrderNote.getCommerceOrderId(), actionId);
        } else {
            this._commerceOrderModelResourcePermission.check(this.getPermissionChecker(), commerceOrderNote.getCommerceOrderId(), actionId);
        }
    }
}

