/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.util;

import com.liferay.commerce.configuration.CommerceOrderItemDecimalQuantityConfiguration;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.product.model.CPMeasurementUnit;
import com.liferay.commerce.util.CommerceOrderItemQuantityFormatter;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.commerce.configuration.CommerceOrderItemDecimalQuantityConfiguration"}, service={CommerceOrderItemQuantityFormatter.class})
public class CommerceOrderItemQuantityFormatterImpl
implements CommerceOrderItemQuantityFormatter {
    private volatile CommerceOrderItemDecimalQuantityConfiguration _commerceOrderItemDecimalQuantityConfiguration;

    public String format(CommerceOrderItem commerceOrderItem, Locale locale) {
        CPMeasurementUnit cpMeasurementUnit = commerceOrderItem.fetchCPMeasurementUnit();
        BigDecimal decimalQuantity = commerceOrderItem.getDecimalQuantity();
        if (decimalQuantity == null || decimalQuantity.equals(BigDecimal.ZERO)) {
            if (cpMeasurementUnit == null) {
                return String.valueOf(commerceOrderItem.getQuantity());
            }
            return StringBundler.concat((Object[])new Object[]{commerceOrderItem.getQuantity(), " ", cpMeasurementUnit.getName(locale)});
        }
        DecimalFormat decimalFormat = this._getDecimalFormat(locale);
        if (cpMeasurementUnit == null) {
            return decimalFormat.format(decimalQuantity);
        }
        return StringBundler.concat((String[])new String[]{decimalFormat.format(decimalQuantity), " ", cpMeasurementUnit.getName(locale)});
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._commerceOrderItemDecimalQuantityConfiguration = (CommerceOrderItemDecimalQuantityConfiguration)ConfigurableUtil.createConfigurable(CommerceOrderItemDecimalQuantityConfiguration.class, properties);
    }

    @Deactivate
    protected void deactivate() {
        this._commerceOrderItemDecimalQuantityConfiguration = null;
    }

    private DecimalFormat _getDecimalFormat(Locale locale) {
        DecimalFormat decimalFormat = new DecimalFormat("###,##0.00", DecimalFormatSymbols.getInstance(locale));
        decimalFormat.setMaximumFractionDigits(this._commerceOrderItemDecimalQuantityConfiguration.maximumFractionDigits());
        decimalFormat.setMinimumFractionDigits(this._commerceOrderItemDecimalQuantityConfiguration.minimumFractionDigits());
        decimalFormat.setRoundingMode(this._commerceOrderItemDecimalQuantityConfiguration.roundingMode());
        return decimalFormat;
    }
}

