/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.term.contributor;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.model.CommerceAccountUserRel;
import com.liferay.commerce.account.service.CommerceAccountUserRelLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.order.CommerceDefinitionTermContributor;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.definition.term.contributor.key=RecipientTerms", "commerce.notification.type.key=order-awaiting-shipment", "commerce.notification.type.key=order-completed", "commerce.notification.type.key=order-partially-shipped", "commerce.notification.type.key=order-placed", "commerce.notification.type.key=order-processing", "commerce.notification.type.key=order-shipped", "commerce.notification.type.key=subscription-activated", "commerce.notification.type.key=subscription-cancelled", "commerce.notification.type.key=subscription-renewed", "commerce.notification.type.key=subscription-suspended"}, service={CommerceDefinitionTermContributor.class})
public class CommerceRecipientCommerceDefinitionTermContributor
implements CommerceDefinitionTermContributor {
    public static final String KEY = "RecipientTerms";
    private static final String _ACCOUNT_ROLE_ADMINISTRATOR = "[%ACCOUNT_ROLE_ADMINISTRATOR%]";
    private static final String _ACCOUNT_ROLE_ORDER_MANAGER = "[%ACCOUNT_ROLE_ORDER_MANAGER%]";
    private static final String _ORDER_CREATOR = "[%ORDER_CREATOR%]";
    private static final String _USER_GROUP_NAME = "[%USER_GROUP_NAME%]";
    private static final Map<String, String> _languageKeys = HashMapBuilder.put((Object)"[%ACCOUNT_ROLE_ADMINISTRATOR%]", (Object)"account-role-administrator").put((Object)"[%ACCOUNT_ROLE_ORDER_MANAGER%]", (Object)"account-role-order-manager").put((Object)"[%ORDER_CREATOR%]", (Object)"order-creator-definition-term").put((Object)"[%USER_GROUP_NAME%]", (Object)"user-group-name").build();
    @Reference
    private CommerceAccountUserRelLocalService _commerceAccountUserRelLocalService;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private Language _language;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getFilledTerm(String term, Object object, Locale locale) throws PortalException {
        CommerceAccount commerceAccount;
        CommerceOrder commerceOrder = null;
        if (object instanceof CommerceOrder) {
            commerceOrder = (CommerceOrder)object;
        } else if (object instanceof CommerceSubscriptionEntry) {
            CommerceSubscriptionEntry commerceSubscriptionEntry = (CommerceSubscriptionEntry)object;
            CommerceOrderItem commerceOrderItem = this._commerceOrderItemLocalService.getCommerceOrderItem(commerceSubscriptionEntry.getCommerceOrderItemId());
            commerceOrder = commerceOrderItem.getCommerceOrder();
        }
        if (commerceOrder == null) {
            return term;
        }
        if (term.equals(_ACCOUNT_ROLE_ADMINISTRATOR)) {
            commerceAccount = commerceOrder.getCommerceAccount();
            Role accountAdminRole = this._roleLocalService.getRole(commerceOrder.getCompanyId(), "Account Administrator");
            return this._getUserIds(commerceAccount, accountAdminRole);
        }
        if (term.equals(_ACCOUNT_ROLE_ORDER_MANAGER)) {
            commerceAccount = commerceOrder.getCommerceAccount();
            Role orderManagerRole = this._roleLocalService.getRole(commerceOrder.getCompanyId(), "Order Manager");
            return this._getUserIds(commerceAccount, orderManagerRole);
        }
        if (term.equals(_ORDER_CREATOR)) {
            commerceAccount = commerceOrder.getCommerceAccount();
            if (commerceAccount.getType() == 1) {
                User user = this._userLocalService.getUser(commerceAccount.getUserId());
                return String.valueOf(user.getUserId());
            }
            return String.valueOf(commerceOrder.getUserId());
        }
        if (term.startsWith("[%USER_GROUP_")) {
            String[] s = term.split("_");
            String userGroupName = StringUtil.removeChars((String)s[2], (char[])new char[]{'%', ']'});
            return this._getUserIds(this._userGroupLocalService.getUserGroup(commerceOrder.getCompanyId(), userGroupName));
        }
        return term;
    }

    public String getLabel(String term, Locale locale) {
        return this._language.get(locale, _languageKeys.get(term));
    }

    public List<String> getTerms() {
        return new ArrayList<String>(_languageKeys.keySet());
    }

    private String _getUserIds(CommerceAccount commerceAccount, Role role) throws PortalException {
        List commerceAccountUserRels = this._commerceAccountUserRelLocalService.getCommerceAccountUserRels(commerceAccount.getCommerceAccountId());
        StringBundler resultsSB = new StringBundler();
        for (CommerceAccountUserRel commerceAccountUserRel : commerceAccountUserRels) {
            List userRoles = this._roleLocalService.getUserGroupRoles(commerceAccountUserRel.getCommerceAccountUserId(), commerceAccount.getCommerceAccountGroupId());
            if (!userRoles.contains(role)) continue;
            resultsSB.append(commerceAccountUserRel.getCommerceAccountUserId());
            resultsSB.append(",");
        }
        return resultsSB.toString();
    }

    private String _getUserIds(UserGroup userGroup) throws PortalException {
        List groupUsers = this._userLocalService.getUserGroupUsers(userGroup.getUserGroupId());
        StringBundler resultsSB = new StringBundler();
        for (User user : groupUsers) {
            resultsSB.append(user.getUserId());
            resultsSB.append(",");
        }
        return resultsSB.toString();
    }
}

