/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.system;

import com.liferay.commerce.pricing.model.CommercePricingClass;
import com.liferay.commerce.pricing.model.CommercePricingClassTable;
import com.liferay.commerce.pricing.service.CommercePricingClassLocalService;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductGroup;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductGroupResource;
import com.liferay.object.model.ObjectField;
import com.liferay.object.system.BaseSystemObjectDefinitionMetadata;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=true, service={SystemObjectDefinitionMetadata.class})
public class CommercePricingClassSystemObjectDefinitionMetadata
extends BaseSystemObjectDefinitionMetadata {
    @Reference
    private CommercePricingClassLocalService _commercePricingClassLocalService;
    @Reference
    private ProductGroupResource.Factory _productGroupResourceFactory;

    public long addBaseModel(User user, Map<String, Object> values) throws Exception {
        ProductGroupResource productGroupResource = this._buildProductGroupResource(user);
        ProductGroup productGroup = productGroupResource.postProductGroup(this._toProductGroup(values));
        this.setExtendedProperties(ProductGroup.class.getName(), productGroup, user, values);
        return productGroup.getId();
    }

    public BaseModel<?> deleteBaseModel(BaseModel<?> baseModel) throws PortalException {
        return this._commercePricingClassLocalService.deleteCommercePricingClass((CommercePricingClass)baseModel);
    }

    public BaseModel<?> getBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this._commercePricingClassLocalService.getCommercePricingClassByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public String getExternalReferenceCode(long primaryKey) throws PortalException {
        CommercePricingClass commercePricingClass = this._commercePricingClassLocalService.getCommercePricingClass(primaryKey);
        return commercePricingClass.getExternalReferenceCode();
    }

    public JaxRsApplicationDescriptor getJaxRsApplicationDescriptor() {
        return new JaxRsApplicationDescriptor("Liferay.Headless.Commerce.Admin.Catalog", "headless-commerce-admin-catalog", "product-groups", "v1.0");
    }

    public Map<Locale, String> getLabelMap() {
        return this.createLabelMap("commerce-product-group");
    }

    public Class<?> getModelClass() {
        return CommercePricingClass.class;
    }

    public List<ObjectField> getObjectFields() {
        return Arrays.asList(this.createObjectField("Text", "String", "description", "description", false, true), this.createObjectField("Integer", "Integer", "number-of-products", "productsCount", false, true), this.createObjectField("Text", "String", "title", "title", true, true));
    }

    public Map<Locale, String> getPluralLabelMap() {
        return this.createLabelMap("commerce-product-groups");
    }

    public Column<?, Long> getPrimaryKeyColumn() {
        return CommercePricingClassTable.INSTANCE.commercePricingClassId;
    }

    public String getScope() {
        return "company";
    }

    public Table getTable() {
        return CommercePricingClassTable.INSTANCE;
    }

    public String getTitleObjectFieldName() {
        return "title";
    }

    public int getVersion() {
        return 2;
    }

    public void updateBaseModel(long primaryKey, User user, Map<String, Object> values) throws Exception {
        ProductGroupResource productGroupResource = this._buildProductGroupResource(user);
        productGroupResource.patchProductGroup(Long.valueOf(primaryKey), this._toProductGroup(values));
        this.setExtendedProperties(ProductGroup.class.getName(), JSONUtil.put((String)"id", (Object)primaryKey), user, values);
    }

    private ProductGroupResource _buildProductGroupResource(User user) {
        ProductGroupResource.Builder builder = this._productGroupResourceFactory.create();
        return builder.checkPermissions(false).preferredLocale(user.getLocale()).user(user).build();
    }

    private ProductGroup _toProductGroup(final Map<String, Object> values) {
        return new ProductGroup(){
            {
                this.description = CommercePricingClassSystemObjectDefinitionMetadata.this.getLanguageIdMap("description", values);
                this.externalReferenceCode = GetterUtil.getString(values.get("externalReferenceCode"));
                this.productsCount = GetterUtil.getInteger(values.get("productsCount"));
                this.title = CommercePricingClassSystemObjectDefinitionMetadata.this.getLanguageIdMap("title", values);
            }
        };
    }
}

