/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.model.listener;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.account.exception.CommerceAccountOrdersException;
import com.liferay.commerce.internal.search.CommerceOrderBatchReindexer;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceShippingOptionAccountEntryRelLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.util.StringUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class AccountEntryModelListener
extends BaseModelListener<AccountEntry> {
    @Reference
    protected CommerceOrderBatchReindexer commerceOrderBatchReindexer;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceShippingOptionAccountEntryRelLocalService _commerceShippingOptionAccountEntryRelLocalService;

    public void onAfterUpdate(AccountEntry originalAccountEntry, AccountEntry accountEntry) throws ModelListenerException {
        if (StringUtil.equals((String)originalAccountEntry.getName(), (String)accountEntry.getName())) {
            return;
        }
        this.commerceOrderBatchReindexer.reindex(accountEntry.getAccountEntryId(), accountEntry.getCompanyId());
    }

    public void onBeforeRemove(AccountEntry accountEntry) {
        int accountOrders = this._commerceOrderLocalService.getCommerceOrdersCountByCommerceAccountId(accountEntry.getAccountEntryId());
        if (accountOrders > 0) {
            throw new CommerceAccountOrdersException();
        }
        this._commerceShippingOptionAccountEntryRelLocalService.deleteCommerceShippingOptionAccountEntryRelsByAccountEntryId(accountEntry.getAccountEntryId());
    }
}

