/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderItemModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceOrderItem service. Represents a row in the &quot;CommerceOrderItem&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceOrderItemModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceOrderItemImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceOrderItemImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceOrderItemModelImpl
	extends BaseModelImpl<CommerceOrderItem> implements CommerceOrderItemModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce order item model instance should use the <code>CommerceOrderItem</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceOrderItem";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"externalReferenceCode", Types.VARCHAR},
		{"commerceOrderItemId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"bookedQuantityId", Types.BIGINT},
		{"commerceOrderId", Types.BIGINT},
		{"commercePriceListId", Types.BIGINT}, {"CPInstanceId", Types.BIGINT},
		{"CPMeasurementUnitId", Types.BIGINT}, {"CProductId", Types.BIGINT},
		{"parentCommerceOrderItemId", Types.BIGINT},
		{"shippingAddressId", Types.BIGINT}, {"decimalQuantity", Types.DECIMAL},
		{"deliveryGroup", Types.VARCHAR},
		{"deliveryMaxSubscriptionCycles", Types.BIGINT},
		{"deliverySubscriptionLength", Types.INTEGER},
		{"deliverySubscriptionType", Types.VARCHAR},
		{"deliverySubTypeSettings", Types.VARCHAR}, {"depth", Types.DOUBLE},
		{"discountAmount", Types.DECIMAL},
		{"discountManuallyAdjusted", Types.BOOLEAN},
		{"discountPercentageLevel1", Types.DECIMAL},
		{"discountPercentageLevel2", Types.DECIMAL},
		{"discountPercentageLevel3", Types.DECIMAL},
		{"discountPercentageLevel4", Types.DECIMAL},
		{"discountPctLevel1WithTaxAmount", Types.DECIMAL},
		{"discountPctLevel2WithTaxAmount", Types.DECIMAL},
		{"discountPctLevel3WithTaxAmount", Types.DECIMAL},
		{"discountPctLevel4WithTaxAmount", Types.DECIMAL},
		{"discountWithTaxAmount", Types.DECIMAL}, {"finalPrice", Types.DECIMAL},
		{"finalPriceWithTaxAmount", Types.DECIMAL},
		{"freeShipping", Types.BOOLEAN}, {"height", Types.DOUBLE},
		{"json", Types.CLOB}, {"manuallyAdjusted", Types.BOOLEAN},
		{"maxSubscriptionCycles", Types.BIGINT}, {"name", Types.VARCHAR},
		{"priceManuallyAdjusted", Types.BOOLEAN},
		{"printedNote", Types.VARCHAR}, {"promoPrice", Types.DECIMAL},
		{"promoPriceWithTaxAmount", Types.DECIMAL}, {"quantity", Types.INTEGER},
		{"requestedDeliveryDate", Types.TIMESTAMP},
		{"shipSeparately", Types.BOOLEAN}, {"shippable", Types.BOOLEAN},
		{"shippedQuantity", Types.INTEGER},
		{"shippingExtraPrice", Types.DOUBLE}, {"sku", Types.VARCHAR},
		{"subscription", Types.BOOLEAN}, {"subscriptionLength", Types.INTEGER},
		{"subscriptionType", Types.VARCHAR},
		{"subscriptionTypeSettings", Types.VARCHAR},
		{"unitPrice", Types.DECIMAL}, {"unitPriceWithTaxAmount", Types.DECIMAL},
		{"weight", Types.DOUBLE}, {"width", Types.DOUBLE}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceOrderItemId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("bookedQuantityId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceOrderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commercePriceListId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CPInstanceId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CPMeasurementUnitId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CProductId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentCommerceOrderItemId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("shippingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("decimalQuantity", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("deliveryGroup", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("deliveryMaxSubscriptionCycles", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("deliverySubscriptionLength", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("deliverySubscriptionType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("deliverySubTypeSettings", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("depth", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("discountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountManuallyAdjusted", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel1WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel2WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel3WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel4WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("finalPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("finalPriceWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("freeShipping", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("height", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("json", Types.CLOB);
		TABLE_COLUMNS_MAP.put("manuallyAdjusted", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("maxSubscriptionCycles", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("priceManuallyAdjusted", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("printedNote", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("promoPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("promoPriceWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("quantity", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("requestedDeliveryDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("shipSeparately", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("shippable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("shippedQuantity", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("shippingExtraPrice", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("sku", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("subscription", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("subscriptionLength", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("subscriptionType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("subscriptionTypeSettings", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("unitPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("unitPriceWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("weight", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("width", Types.DOUBLE);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceOrderItem (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,commerceOrderItemId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,bookedQuantityId LONG,commerceOrderId LONG,commercePriceListId LONG,CPInstanceId LONG,CPMeasurementUnitId LONG,CProductId LONG,parentCommerceOrderItemId LONG,shippingAddressId LONG,decimalQuantity DECIMAL(30, 16) null,deliveryGroup VARCHAR(75) null,deliveryMaxSubscriptionCycles LONG,deliverySubscriptionLength INTEGER,deliverySubscriptionType VARCHAR(75) null,deliverySubTypeSettings VARCHAR(75) null,depth DOUBLE,discountAmount DECIMAL(30, 16) null,discountManuallyAdjusted BOOLEAN,discountPercentageLevel1 DECIMAL(30, 16) null,discountPercentageLevel2 DECIMAL(30, 16) null,discountPercentageLevel3 DECIMAL(30, 16) null,discountPercentageLevel4 DECIMAL(30, 16) null,discountPctLevel1WithTaxAmount DECIMAL(30, 16) null,discountPctLevel2WithTaxAmount DECIMAL(30, 16) null,discountPctLevel3WithTaxAmount DECIMAL(30, 16) null,discountPctLevel4WithTaxAmount DECIMAL(30, 16) null,discountWithTaxAmount DECIMAL(30, 16) null,finalPrice DECIMAL(30, 16) null,finalPriceWithTaxAmount DECIMAL(30, 16) null,freeShipping BOOLEAN,height DOUBLE,json TEXT null,manuallyAdjusted BOOLEAN,maxSubscriptionCycles LONG,name STRING null,priceManuallyAdjusted BOOLEAN,printedNote STRING null,promoPrice DECIMAL(30, 16) null,promoPriceWithTaxAmount DECIMAL(30, 16) null,quantity INTEGER,requestedDeliveryDate DATE null,shipSeparately BOOLEAN,shippable BOOLEAN,shippedQuantity INTEGER,shippingExtraPrice DOUBLE,sku VARCHAR(75) null,subscription BOOLEAN,subscriptionLength INTEGER,subscriptionType VARCHAR(75) null,subscriptionTypeSettings VARCHAR(75) null,unitPrice DECIMAL(30, 16) null,unitPriceWithTaxAmount DECIMAL(30, 16) null,weight DOUBLE,width DOUBLE)";

	public static final String TABLE_SQL_DROP = "drop table CommerceOrderItem";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceOrderItem.createDate ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceOrderItem.createDate ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CPINSTANCEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CPRODUCTID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long BOOKEDQUANTITYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCEORDERID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PARENTCOMMERCEORDERITEMID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SUBSCRIPTION_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 1024L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CommerceOrderItemModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceOrderItemId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceOrderItemId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceOrderItemId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceOrderItem.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceOrderItem.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceOrderItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceOrderItem, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrderItem, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceOrderItem)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceOrderItem, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceOrderItem, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceOrderItem)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceOrderItem, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceOrderItem, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<CommerceOrderItem, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<CommerceOrderItem, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<CommerceOrderItem, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", CommerceOrderItem::getMvccVersion);
			attributeGetterFunctions.put("uuid", CommerceOrderItem::getUuid);
			attributeGetterFunctions.put(
				"externalReferenceCode",
				CommerceOrderItem::getExternalReferenceCode);
			attributeGetterFunctions.put(
				"commerceOrderItemId",
				CommerceOrderItem::getCommerceOrderItemId);
			attributeGetterFunctions.put(
				"groupId", CommerceOrderItem::getGroupId);
			attributeGetterFunctions.put(
				"companyId", CommerceOrderItem::getCompanyId);
			attributeGetterFunctions.put(
				"userId", CommerceOrderItem::getUserId);
			attributeGetterFunctions.put(
				"userName", CommerceOrderItem::getUserName);
			attributeGetterFunctions.put(
				"createDate", CommerceOrderItem::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", CommerceOrderItem::getModifiedDate);
			attributeGetterFunctions.put(
				"bookedQuantityId", CommerceOrderItem::getBookedQuantityId);
			attributeGetterFunctions.put(
				"commerceOrderId", CommerceOrderItem::getCommerceOrderId);
			attributeGetterFunctions.put(
				"commercePriceListId",
				CommerceOrderItem::getCommercePriceListId);
			attributeGetterFunctions.put(
				"CPInstanceId", CommerceOrderItem::getCPInstanceId);
			attributeGetterFunctions.put(
				"CPMeasurementUnitId",
				CommerceOrderItem::getCPMeasurementUnitId);
			attributeGetterFunctions.put(
				"CProductId", CommerceOrderItem::getCProductId);
			attributeGetterFunctions.put(
				"parentCommerceOrderItemId",
				CommerceOrderItem::getParentCommerceOrderItemId);
			attributeGetterFunctions.put(
				"shippingAddressId", CommerceOrderItem::getShippingAddressId);
			attributeGetterFunctions.put(
				"decimalQuantity", CommerceOrderItem::getDecimalQuantity);
			attributeGetterFunctions.put(
				"deliveryGroup", CommerceOrderItem::getDeliveryGroup);
			attributeGetterFunctions.put(
				"deliveryMaxSubscriptionCycles",
				CommerceOrderItem::getDeliveryMaxSubscriptionCycles);
			attributeGetterFunctions.put(
				"deliverySubscriptionLength",
				CommerceOrderItem::getDeliverySubscriptionLength);
			attributeGetterFunctions.put(
				"deliverySubscriptionType",
				CommerceOrderItem::getDeliverySubscriptionType);
			attributeGetterFunctions.put(
				"deliverySubscriptionTypeSettings",
				CommerceOrderItem::getDeliverySubscriptionTypeSettings);
			attributeGetterFunctions.put("depth", CommerceOrderItem::getDepth);
			attributeGetterFunctions.put(
				"discountAmount", CommerceOrderItem::getDiscountAmount);
			attributeGetterFunctions.put(
				"discountManuallyAdjusted",
				CommerceOrderItem::getDiscountManuallyAdjusted);
			attributeGetterFunctions.put(
				"discountPercentageLevel1",
				CommerceOrderItem::getDiscountPercentageLevel1);
			attributeGetterFunctions.put(
				"discountPercentageLevel2",
				CommerceOrderItem::getDiscountPercentageLevel2);
			attributeGetterFunctions.put(
				"discountPercentageLevel3",
				CommerceOrderItem::getDiscountPercentageLevel3);
			attributeGetterFunctions.put(
				"discountPercentageLevel4",
				CommerceOrderItem::getDiscountPercentageLevel4);
			attributeGetterFunctions.put(
				"discountPercentageLevel1WithTaxAmount",
				CommerceOrderItem::getDiscountPercentageLevel1WithTaxAmount);
			attributeGetterFunctions.put(
				"discountPercentageLevel2WithTaxAmount",
				CommerceOrderItem::getDiscountPercentageLevel2WithTaxAmount);
			attributeGetterFunctions.put(
				"discountPercentageLevel3WithTaxAmount",
				CommerceOrderItem::getDiscountPercentageLevel3WithTaxAmount);
			attributeGetterFunctions.put(
				"discountPercentageLevel4WithTaxAmount",
				CommerceOrderItem::getDiscountPercentageLevel4WithTaxAmount);
			attributeGetterFunctions.put(
				"discountWithTaxAmount",
				CommerceOrderItem::getDiscountWithTaxAmount);
			attributeGetterFunctions.put(
				"finalPrice", CommerceOrderItem::getFinalPrice);
			attributeGetterFunctions.put(
				"finalPriceWithTaxAmount",
				CommerceOrderItem::getFinalPriceWithTaxAmount);
			attributeGetterFunctions.put(
				"freeShipping", CommerceOrderItem::getFreeShipping);
			attributeGetterFunctions.put(
				"height", CommerceOrderItem::getHeight);
			attributeGetterFunctions.put("json", CommerceOrderItem::getJson);
			attributeGetterFunctions.put(
				"manuallyAdjusted", CommerceOrderItem::getManuallyAdjusted);
			attributeGetterFunctions.put(
				"maxSubscriptionCycles",
				CommerceOrderItem::getMaxSubscriptionCycles);
			attributeGetterFunctions.put("name", CommerceOrderItem::getName);
			attributeGetterFunctions.put(
				"priceManuallyAdjusted",
				CommerceOrderItem::getPriceManuallyAdjusted);
			attributeGetterFunctions.put(
				"printedNote", CommerceOrderItem::getPrintedNote);
			attributeGetterFunctions.put(
				"promoPrice", CommerceOrderItem::getPromoPrice);
			attributeGetterFunctions.put(
				"promoPriceWithTaxAmount",
				CommerceOrderItem::getPromoPriceWithTaxAmount);
			attributeGetterFunctions.put(
				"quantity", CommerceOrderItem::getQuantity);
			attributeGetterFunctions.put(
				"requestedDeliveryDate",
				CommerceOrderItem::getRequestedDeliveryDate);
			attributeGetterFunctions.put(
				"shipSeparately", CommerceOrderItem::getShipSeparately);
			attributeGetterFunctions.put(
				"shippable", CommerceOrderItem::getShippable);
			attributeGetterFunctions.put(
				"shippedQuantity", CommerceOrderItem::getShippedQuantity);
			attributeGetterFunctions.put(
				"shippingExtraPrice", CommerceOrderItem::getShippingExtraPrice);
			attributeGetterFunctions.put("sku", CommerceOrderItem::getSku);
			attributeGetterFunctions.put(
				"subscription", CommerceOrderItem::getSubscription);
			attributeGetterFunctions.put(
				"subscriptionLength", CommerceOrderItem::getSubscriptionLength);
			attributeGetterFunctions.put(
				"subscriptionType", CommerceOrderItem::getSubscriptionType);
			attributeGetterFunctions.put(
				"subscriptionTypeSettings",
				CommerceOrderItem::getSubscriptionTypeSettings);
			attributeGetterFunctions.put(
				"unitPrice", CommerceOrderItem::getUnitPrice);
			attributeGetterFunctions.put(
				"unitPriceWithTaxAmount",
				CommerceOrderItem::getUnitPriceWithTaxAmount);
			attributeGetterFunctions.put(
				"weight", CommerceOrderItem::getWeight);
			attributeGetterFunctions.put("width", CommerceOrderItem::getWidth);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<CommerceOrderItem, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<CommerceOrderItem, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<CommerceOrderItem, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setUuid);
			attributeSetterBiConsumers.put(
				"externalReferenceCode",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setExternalReferenceCode);
			attributeSetterBiConsumers.put(
				"commerceOrderItemId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setCommerceOrderItemId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<CommerceOrderItem, Date>)
					CommerceOrderItem::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<CommerceOrderItem, Date>)
					CommerceOrderItem::setModifiedDate);
			attributeSetterBiConsumers.put(
				"bookedQuantityId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setBookedQuantityId);
			attributeSetterBiConsumers.put(
				"commerceOrderId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setCommerceOrderId);
			attributeSetterBiConsumers.put(
				"commercePriceListId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setCommercePriceListId);
			attributeSetterBiConsumers.put(
				"CPInstanceId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setCPInstanceId);
			attributeSetterBiConsumers.put(
				"CPMeasurementUnitId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setCPMeasurementUnitId);
			attributeSetterBiConsumers.put(
				"CProductId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setCProductId);
			attributeSetterBiConsumers.put(
				"parentCommerceOrderItemId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setParentCommerceOrderItemId);
			attributeSetterBiConsumers.put(
				"shippingAddressId",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setShippingAddressId);
			attributeSetterBiConsumers.put(
				"decimalQuantity",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setDecimalQuantity);
			attributeSetterBiConsumers.put(
				"deliveryGroup",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setDeliveryGroup);
			attributeSetterBiConsumers.put(
				"deliveryMaxSubscriptionCycles",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setDeliveryMaxSubscriptionCycles);
			attributeSetterBiConsumers.put(
				"deliverySubscriptionLength",
				(BiConsumer<CommerceOrderItem, Integer>)
					CommerceOrderItem::setDeliverySubscriptionLength);
			attributeSetterBiConsumers.put(
				"deliverySubscriptionType",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setDeliverySubscriptionType);
			attributeSetterBiConsumers.put(
				"deliverySubscriptionTypeSettings",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setDeliverySubscriptionTypeSettings);
			attributeSetterBiConsumers.put(
				"depth",
				(BiConsumer<CommerceOrderItem, Double>)
					CommerceOrderItem::setDepth);
			attributeSetterBiConsumers.put(
				"discountAmount",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setDiscountAmount);
			attributeSetterBiConsumers.put(
				"discountManuallyAdjusted",
				(BiConsumer<CommerceOrderItem, Boolean>)
					CommerceOrderItem::setDiscountManuallyAdjusted);
			attributeSetterBiConsumers.put(
				"discountPercentageLevel1",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setDiscountPercentageLevel1);
			attributeSetterBiConsumers.put(
				"discountPercentageLevel2",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setDiscountPercentageLevel2);
			attributeSetterBiConsumers.put(
				"discountPercentageLevel3",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setDiscountPercentageLevel3);
			attributeSetterBiConsumers.put(
				"discountPercentageLevel4",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setDiscountPercentageLevel4);
			attributeSetterBiConsumers.put(
				"discountPercentageLevel1WithTaxAmount",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::
						setDiscountPercentageLevel1WithTaxAmount);
			attributeSetterBiConsumers.put(
				"discountPercentageLevel2WithTaxAmount",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::
						setDiscountPercentageLevel2WithTaxAmount);
			attributeSetterBiConsumers.put(
				"discountPercentageLevel3WithTaxAmount",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::
						setDiscountPercentageLevel3WithTaxAmount);
			attributeSetterBiConsumers.put(
				"discountPercentageLevel4WithTaxAmount",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::
						setDiscountPercentageLevel4WithTaxAmount);
			attributeSetterBiConsumers.put(
				"discountWithTaxAmount",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setDiscountWithTaxAmount);
			attributeSetterBiConsumers.put(
				"finalPrice",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setFinalPrice);
			attributeSetterBiConsumers.put(
				"finalPriceWithTaxAmount",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setFinalPriceWithTaxAmount);
			attributeSetterBiConsumers.put(
				"freeShipping",
				(BiConsumer<CommerceOrderItem, Boolean>)
					CommerceOrderItem::setFreeShipping);
			attributeSetterBiConsumers.put(
				"height",
				(BiConsumer<CommerceOrderItem, Double>)
					CommerceOrderItem::setHeight);
			attributeSetterBiConsumers.put(
				"json",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setJson);
			attributeSetterBiConsumers.put(
				"manuallyAdjusted",
				(BiConsumer<CommerceOrderItem, Boolean>)
					CommerceOrderItem::setManuallyAdjusted);
			attributeSetterBiConsumers.put(
				"maxSubscriptionCycles",
				(BiConsumer<CommerceOrderItem, Long>)
					CommerceOrderItem::setMaxSubscriptionCycles);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setName);
			attributeSetterBiConsumers.put(
				"priceManuallyAdjusted",
				(BiConsumer<CommerceOrderItem, Boolean>)
					CommerceOrderItem::setPriceManuallyAdjusted);
			attributeSetterBiConsumers.put(
				"printedNote",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setPrintedNote);
			attributeSetterBiConsumers.put(
				"promoPrice",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setPromoPrice);
			attributeSetterBiConsumers.put(
				"promoPriceWithTaxAmount",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setPromoPriceWithTaxAmount);
			attributeSetterBiConsumers.put(
				"quantity",
				(BiConsumer<CommerceOrderItem, Integer>)
					CommerceOrderItem::setQuantity);
			attributeSetterBiConsumers.put(
				"requestedDeliveryDate",
				(BiConsumer<CommerceOrderItem, Date>)
					CommerceOrderItem::setRequestedDeliveryDate);
			attributeSetterBiConsumers.put(
				"shipSeparately",
				(BiConsumer<CommerceOrderItem, Boolean>)
					CommerceOrderItem::setShipSeparately);
			attributeSetterBiConsumers.put(
				"shippable",
				(BiConsumer<CommerceOrderItem, Boolean>)
					CommerceOrderItem::setShippable);
			attributeSetterBiConsumers.put(
				"shippedQuantity",
				(BiConsumer<CommerceOrderItem, Integer>)
					CommerceOrderItem::setShippedQuantity);
			attributeSetterBiConsumers.put(
				"shippingExtraPrice",
				(BiConsumer<CommerceOrderItem, Double>)
					CommerceOrderItem::setShippingExtraPrice);
			attributeSetterBiConsumers.put(
				"sku",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setSku);
			attributeSetterBiConsumers.put(
				"subscription",
				(BiConsumer<CommerceOrderItem, Boolean>)
					CommerceOrderItem::setSubscription);
			attributeSetterBiConsumers.put(
				"subscriptionLength",
				(BiConsumer<CommerceOrderItem, Integer>)
					CommerceOrderItem::setSubscriptionLength);
			attributeSetterBiConsumers.put(
				"subscriptionType",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setSubscriptionType);
			attributeSetterBiConsumers.put(
				"subscriptionTypeSettings",
				(BiConsumer<CommerceOrderItem, String>)
					CommerceOrderItem::setSubscriptionTypeSettings);
			attributeSetterBiConsumers.put(
				"unitPrice",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setUnitPrice);
			attributeSetterBiConsumers.put(
				"unitPriceWithTaxAmount",
				(BiConsumer<CommerceOrderItem, BigDecimal>)
					CommerceOrderItem::setUnitPriceWithTaxAmount);
			attributeSetterBiConsumers.put(
				"weight",
				(BiConsumer<CommerceOrderItem, Double>)
					CommerceOrderItem::setWeight);
			attributeSetterBiConsumers.put(
				"width",
				(BiConsumer<CommerceOrderItem, Double>)
					CommerceOrderItem::setWidth);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommerceOrderItemId() {
		return _commerceOrderItemId;
	}

	@Override
	public void setCommerceOrderItemId(long commerceOrderItemId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceOrderItemId = commerceOrderItemId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getBookedQuantityId() {
		return _bookedQuantityId;
	}

	@Override
	public void setBookedQuantityId(long bookedQuantityId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_bookedQuantityId = bookedQuantityId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalBookedQuantityId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("bookedQuantityId"));
	}

	@JSON
	@Override
	public long getCommerceOrderId() {
		return _commerceOrderId;
	}

	@Override
	public void setCommerceOrderId(long commerceOrderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceOrderId = commerceOrderId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceOrderId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceOrderId"));
	}

	@JSON
	@Override
	public long getCommercePriceListId() {
		return _commercePriceListId;
	}

	@Override
	public void setCommercePriceListId(long commercePriceListId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePriceListId = commercePriceListId;
	}

	@JSON
	@Override
	public long getCPInstanceId() {
		return _CPInstanceId;
	}

	@Override
	public void setCPInstanceId(long CPInstanceId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CPInstanceId = CPInstanceId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCPInstanceId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("CPInstanceId"));
	}

	@JSON
	@Override
	public long getCPMeasurementUnitId() {
		return _CPMeasurementUnitId;
	}

	@Override
	public void setCPMeasurementUnitId(long CPMeasurementUnitId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CPMeasurementUnitId = CPMeasurementUnitId;
	}

	@JSON
	@Override
	public long getCProductId() {
		return _CProductId;
	}

	@Override
	public void setCProductId(long CProductId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CProductId = CProductId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCProductId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("CProductId"));
	}

	@JSON
	@Override
	public long getParentCommerceOrderItemId() {
		return _parentCommerceOrderItemId;
	}

	@Override
	public void setParentCommerceOrderItemId(long parentCommerceOrderItemId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentCommerceOrderItemId = parentCommerceOrderItemId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalParentCommerceOrderItemId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("parentCommerceOrderItemId"));
	}

	@JSON
	@Override
	public long getShippingAddressId() {
		return _shippingAddressId;
	}

	@Override
	public void setShippingAddressId(long shippingAddressId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingAddressId = shippingAddressId;
	}

	@JSON
	@Override
	public BigDecimal getDecimalQuantity() {
		return _decimalQuantity;
	}

	@Override
	public void setDecimalQuantity(BigDecimal decimalQuantity) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_decimalQuantity = decimalQuantity;
	}

	@JSON
	@Override
	public String getDeliveryGroup() {
		if (_deliveryGroup == null) {
			return "";
		}
		else {
			return _deliveryGroup;
		}
	}

	@Override
	public void setDeliveryGroup(String deliveryGroup) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliveryGroup = deliveryGroup;
	}

	@JSON
	@Override
	public long getDeliveryMaxSubscriptionCycles() {
		return _deliveryMaxSubscriptionCycles;
	}

	@Override
	public void setDeliveryMaxSubscriptionCycles(
		long deliveryMaxSubscriptionCycles) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliveryMaxSubscriptionCycles = deliveryMaxSubscriptionCycles;
	}

	@JSON
	@Override
	public int getDeliverySubscriptionLength() {
		return _deliverySubscriptionLength;
	}

	@Override
	public void setDeliverySubscriptionLength(int deliverySubscriptionLength) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliverySubscriptionLength = deliverySubscriptionLength;
	}

	@JSON
	@Override
	public String getDeliverySubscriptionType() {
		if (_deliverySubscriptionType == null) {
			return "";
		}
		else {
			return _deliverySubscriptionType;
		}
	}

	@Override
	public void setDeliverySubscriptionType(String deliverySubscriptionType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliverySubscriptionType = deliverySubscriptionType;
	}

	@JSON
	@Override
	public String getDeliverySubscriptionTypeSettings() {
		if (_deliverySubscriptionTypeSettings == null) {
			return "";
		}
		else {
			return _deliverySubscriptionTypeSettings;
		}
	}

	@Override
	public void setDeliverySubscriptionTypeSettings(
		String deliverySubscriptionTypeSettings) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliverySubscriptionTypeSettings = deliverySubscriptionTypeSettings;
	}

	@JSON
	@Override
	public double getDepth() {
		return _depth;
	}

	@Override
	public void setDepth(double depth) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_depth = depth;
	}

	@JSON
	@Override
	public BigDecimal getDiscountAmount() {
		return _discountAmount;
	}

	@Override
	public void setDiscountAmount(BigDecimal discountAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountAmount = discountAmount;
	}

	@JSON
	@Override
	public boolean getDiscountManuallyAdjusted() {
		return _discountManuallyAdjusted;
	}

	@JSON
	@Override
	public boolean isDiscountManuallyAdjusted() {
		return _discountManuallyAdjusted;
	}

	@Override
	public void setDiscountManuallyAdjusted(boolean discountManuallyAdjusted) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountManuallyAdjusted = discountManuallyAdjusted;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel1() {
		return _discountPercentageLevel1;
	}

	@Override
	public void setDiscountPercentageLevel1(
		BigDecimal discountPercentageLevel1) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel1 = discountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel2() {
		return _discountPercentageLevel2;
	}

	@Override
	public void setDiscountPercentageLevel2(
		BigDecimal discountPercentageLevel2) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel2 = discountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel3() {
		return _discountPercentageLevel3;
	}

	@Override
	public void setDiscountPercentageLevel3(
		BigDecimal discountPercentageLevel3) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel3 = discountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel4() {
		return _discountPercentageLevel4;
	}

	@Override
	public void setDiscountPercentageLevel4(
		BigDecimal discountPercentageLevel4) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel4 = discountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel1WithTaxAmount() {
		return _discountPercentageLevel1WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel1WithTaxAmount(
		BigDecimal discountPercentageLevel1WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel1WithTaxAmount =
			discountPercentageLevel1WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel2WithTaxAmount() {
		return _discountPercentageLevel2WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel2WithTaxAmount(
		BigDecimal discountPercentageLevel2WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel2WithTaxAmount =
			discountPercentageLevel2WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel3WithTaxAmount() {
		return _discountPercentageLevel3WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel3WithTaxAmount(
		BigDecimal discountPercentageLevel3WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel3WithTaxAmount =
			discountPercentageLevel3WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel4WithTaxAmount() {
		return _discountPercentageLevel4WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel4WithTaxAmount(
		BigDecimal discountPercentageLevel4WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel4WithTaxAmount =
			discountPercentageLevel4WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountWithTaxAmount() {
		return _discountWithTaxAmount;
	}

	@Override
	public void setDiscountWithTaxAmount(BigDecimal discountWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountWithTaxAmount = discountWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getFinalPrice() {
		return _finalPrice;
	}

	@Override
	public void setFinalPrice(BigDecimal finalPrice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_finalPrice = finalPrice;
	}

	@JSON
	@Override
	public BigDecimal getFinalPriceWithTaxAmount() {
		return _finalPriceWithTaxAmount;
	}

	@Override
	public void setFinalPriceWithTaxAmount(BigDecimal finalPriceWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_finalPriceWithTaxAmount = finalPriceWithTaxAmount;
	}

	@JSON
	@Override
	public boolean getFreeShipping() {
		return _freeShipping;
	}

	@JSON
	@Override
	public boolean isFreeShipping() {
		return _freeShipping;
	}

	@Override
	public void setFreeShipping(boolean freeShipping) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_freeShipping = freeShipping;
	}

	@JSON
	@Override
	public double getHeight() {
		return _height;
	}

	@Override
	public void setHeight(double height) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_height = height;
	}

	@JSON
	@Override
	public String getJson() {
		if (_json == null) {
			return "";
		}
		else {
			return _json;
		}
	}

	@Override
	public void setJson(String json) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_json = json;
	}

	@JSON
	@Override
	public boolean getManuallyAdjusted() {
		return _manuallyAdjusted;
	}

	@JSON
	@Override
	public boolean isManuallyAdjusted() {
		return _manuallyAdjusted;
	}

	@Override
	public void setManuallyAdjusted(boolean manuallyAdjusted) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_manuallyAdjusted = manuallyAdjusted;
	}

	@JSON
	@Override
	public long getMaxSubscriptionCycles() {
		return _maxSubscriptionCycles;
	}

	@Override
	public void setMaxSubscriptionCycles(long maxSubscriptionCycles) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_maxSubscriptionCycles = maxSubscriptionCycles;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public boolean getPriceManuallyAdjusted() {
		return _priceManuallyAdjusted;
	}

	@JSON
	@Override
	public boolean isPriceManuallyAdjusted() {
		return _priceManuallyAdjusted;
	}

	@Override
	public void setPriceManuallyAdjusted(boolean priceManuallyAdjusted) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priceManuallyAdjusted = priceManuallyAdjusted;
	}

	@JSON
	@Override
	public String getPrintedNote() {
		if (_printedNote == null) {
			return "";
		}
		else {
			return _printedNote;
		}
	}

	@Override
	public void setPrintedNote(String printedNote) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_printedNote = printedNote;
	}

	@JSON
	@Override
	public BigDecimal getPromoPrice() {
		return _promoPrice;
	}

	@Override
	public void setPromoPrice(BigDecimal promoPrice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_promoPrice = promoPrice;
	}

	@JSON
	@Override
	public BigDecimal getPromoPriceWithTaxAmount() {
		return _promoPriceWithTaxAmount;
	}

	@Override
	public void setPromoPriceWithTaxAmount(BigDecimal promoPriceWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_promoPriceWithTaxAmount = promoPriceWithTaxAmount;
	}

	@JSON
	@Override
	public int getQuantity() {
		return _quantity;
	}

	@Override
	public void setQuantity(int quantity) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_quantity = quantity;
	}

	@JSON
	@Override
	public Date getRequestedDeliveryDate() {
		return _requestedDeliveryDate;
	}

	@Override
	public void setRequestedDeliveryDate(Date requestedDeliveryDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_requestedDeliveryDate = requestedDeliveryDate;
	}

	@JSON
	@Override
	public boolean getShipSeparately() {
		return _shipSeparately;
	}

	@JSON
	@Override
	public boolean isShipSeparately() {
		return _shipSeparately;
	}

	@Override
	public void setShipSeparately(boolean shipSeparately) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shipSeparately = shipSeparately;
	}

	@JSON
	@Override
	public boolean getShippable() {
		return _shippable;
	}

	@JSON
	@Override
	public boolean isShippable() {
		return _shippable;
	}

	@Override
	public void setShippable(boolean shippable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippable = shippable;
	}

	@JSON
	@Override
	public int getShippedQuantity() {
		return _shippedQuantity;
	}

	@Override
	public void setShippedQuantity(int shippedQuantity) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippedQuantity = shippedQuantity;
	}

	@JSON
	@Override
	public double getShippingExtraPrice() {
		return _shippingExtraPrice;
	}

	@Override
	public void setShippingExtraPrice(double shippingExtraPrice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingExtraPrice = shippingExtraPrice;
	}

	@JSON
	@Override
	public String getSku() {
		if (_sku == null) {
			return "";
		}
		else {
			return _sku;
		}
	}

	@Override
	public void setSku(String sku) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sku = sku;
	}

	@JSON
	@Override
	public boolean getSubscription() {
		return _subscription;
	}

	@JSON
	@Override
	public boolean isSubscription() {
		return _subscription;
	}

	@Override
	public void setSubscription(boolean subscription) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subscription = subscription;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalSubscription() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("subscription"));
	}

	@JSON
	@Override
	public int getSubscriptionLength() {
		return _subscriptionLength;
	}

	@Override
	public void setSubscriptionLength(int subscriptionLength) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subscriptionLength = subscriptionLength;
	}

	@JSON
	@Override
	public String getSubscriptionType() {
		if (_subscriptionType == null) {
			return "";
		}
		else {
			return _subscriptionType;
		}
	}

	@Override
	public void setSubscriptionType(String subscriptionType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subscriptionType = subscriptionType;
	}

	@JSON
	@Override
	public String getSubscriptionTypeSettings() {
		if (_subscriptionTypeSettings == null) {
			return "";
		}
		else {
			return _subscriptionTypeSettings;
		}
	}

	@Override
	public void setSubscriptionTypeSettings(String subscriptionTypeSettings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subscriptionTypeSettings = subscriptionTypeSettings;
	}

	@JSON
	@Override
	public BigDecimal getUnitPrice() {
		return _unitPrice;
	}

	@Override
	public void setUnitPrice(BigDecimal unitPrice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_unitPrice = unitPrice;
	}

	@JSON
	@Override
	public BigDecimal getUnitPriceWithTaxAmount() {
		return _unitPriceWithTaxAmount;
	}

	@Override
	public void setUnitPriceWithTaxAmount(BigDecimal unitPriceWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_unitPriceWithTaxAmount = unitPriceWithTaxAmount;
	}

	@JSON
	@Override
	public double getWeight() {
		return _weight;
	}

	@Override
	public void setWeight(double weight) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_weight = weight;
	}

	@JSON
	@Override
	public double getWidth() {
		return _width;
	}

	@Override
	public void setWidth(double width) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_width = width;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(CommerceOrderItem.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceOrderItem.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			CommerceOrderItem.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public CommerceOrderItem toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceOrderItem>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceOrderItemImpl commerceOrderItemImpl =
			new CommerceOrderItemImpl();

		commerceOrderItemImpl.setMvccVersion(getMvccVersion());
		commerceOrderItemImpl.setUuid(getUuid());
		commerceOrderItemImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commerceOrderItemImpl.setCommerceOrderItemId(getCommerceOrderItemId());
		commerceOrderItemImpl.setGroupId(getGroupId());
		commerceOrderItemImpl.setCompanyId(getCompanyId());
		commerceOrderItemImpl.setUserId(getUserId());
		commerceOrderItemImpl.setUserName(getUserName());
		commerceOrderItemImpl.setCreateDate(getCreateDate());
		commerceOrderItemImpl.setModifiedDate(getModifiedDate());
		commerceOrderItemImpl.setBookedQuantityId(getBookedQuantityId());
		commerceOrderItemImpl.setCommerceOrderId(getCommerceOrderId());
		commerceOrderItemImpl.setCommercePriceListId(getCommercePriceListId());
		commerceOrderItemImpl.setCPInstanceId(getCPInstanceId());
		commerceOrderItemImpl.setCPMeasurementUnitId(getCPMeasurementUnitId());
		commerceOrderItemImpl.setCProductId(getCProductId());
		commerceOrderItemImpl.setParentCommerceOrderItemId(
			getParentCommerceOrderItemId());
		commerceOrderItemImpl.setShippingAddressId(getShippingAddressId());
		commerceOrderItemImpl.setDecimalQuantity(getDecimalQuantity());
		commerceOrderItemImpl.setDeliveryGroup(getDeliveryGroup());
		commerceOrderItemImpl.setDeliveryMaxSubscriptionCycles(
			getDeliveryMaxSubscriptionCycles());
		commerceOrderItemImpl.setDeliverySubscriptionLength(
			getDeliverySubscriptionLength());
		commerceOrderItemImpl.setDeliverySubscriptionType(
			getDeliverySubscriptionType());
		commerceOrderItemImpl.setDeliverySubscriptionTypeSettings(
			getDeliverySubscriptionTypeSettings());
		commerceOrderItemImpl.setDepth(getDepth());
		commerceOrderItemImpl.setDiscountAmount(getDiscountAmount());
		commerceOrderItemImpl.setDiscountManuallyAdjusted(
			isDiscountManuallyAdjusted());
		commerceOrderItemImpl.setDiscountPercentageLevel1(
			getDiscountPercentageLevel1());
		commerceOrderItemImpl.setDiscountPercentageLevel2(
			getDiscountPercentageLevel2());
		commerceOrderItemImpl.setDiscountPercentageLevel3(
			getDiscountPercentageLevel3());
		commerceOrderItemImpl.setDiscountPercentageLevel4(
			getDiscountPercentageLevel4());
		commerceOrderItemImpl.setDiscountPercentageLevel1WithTaxAmount(
			getDiscountPercentageLevel1WithTaxAmount());
		commerceOrderItemImpl.setDiscountPercentageLevel2WithTaxAmount(
			getDiscountPercentageLevel2WithTaxAmount());
		commerceOrderItemImpl.setDiscountPercentageLevel3WithTaxAmount(
			getDiscountPercentageLevel3WithTaxAmount());
		commerceOrderItemImpl.setDiscountPercentageLevel4WithTaxAmount(
			getDiscountPercentageLevel4WithTaxAmount());
		commerceOrderItemImpl.setDiscountWithTaxAmount(
			getDiscountWithTaxAmount());
		commerceOrderItemImpl.setFinalPrice(getFinalPrice());
		commerceOrderItemImpl.setFinalPriceWithTaxAmount(
			getFinalPriceWithTaxAmount());
		commerceOrderItemImpl.setFreeShipping(isFreeShipping());
		commerceOrderItemImpl.setHeight(getHeight());
		commerceOrderItemImpl.setJson(getJson());
		commerceOrderItemImpl.setManuallyAdjusted(isManuallyAdjusted());
		commerceOrderItemImpl.setMaxSubscriptionCycles(
			getMaxSubscriptionCycles());
		commerceOrderItemImpl.setName(getName());
		commerceOrderItemImpl.setPriceManuallyAdjusted(
			isPriceManuallyAdjusted());
		commerceOrderItemImpl.setPrintedNote(getPrintedNote());
		commerceOrderItemImpl.setPromoPrice(getPromoPrice());
		commerceOrderItemImpl.setPromoPriceWithTaxAmount(
			getPromoPriceWithTaxAmount());
		commerceOrderItemImpl.setQuantity(getQuantity());
		commerceOrderItemImpl.setRequestedDeliveryDate(
			getRequestedDeliveryDate());
		commerceOrderItemImpl.setShipSeparately(isShipSeparately());
		commerceOrderItemImpl.setShippable(isShippable());
		commerceOrderItemImpl.setShippedQuantity(getShippedQuantity());
		commerceOrderItemImpl.setShippingExtraPrice(getShippingExtraPrice());
		commerceOrderItemImpl.setSku(getSku());
		commerceOrderItemImpl.setSubscription(isSubscription());
		commerceOrderItemImpl.setSubscriptionLength(getSubscriptionLength());
		commerceOrderItemImpl.setSubscriptionType(getSubscriptionType());
		commerceOrderItemImpl.setSubscriptionTypeSettings(
			getSubscriptionTypeSettings());
		commerceOrderItemImpl.setUnitPrice(getUnitPrice());
		commerceOrderItemImpl.setUnitPriceWithTaxAmount(
			getUnitPriceWithTaxAmount());
		commerceOrderItemImpl.setWeight(getWeight());
		commerceOrderItemImpl.setWidth(getWidth());

		commerceOrderItemImpl.resetOriginalValues();

		return commerceOrderItemImpl;
	}

	@Override
	public CommerceOrderItem cloneWithOriginalValues() {
		CommerceOrderItemImpl commerceOrderItemImpl =
			new CommerceOrderItemImpl();

		commerceOrderItemImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceOrderItemImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		commerceOrderItemImpl.setExternalReferenceCode(
			this.<String>getColumnOriginalValue("externalReferenceCode"));
		commerceOrderItemImpl.setCommerceOrderItemId(
			this.<Long>getColumnOriginalValue("commerceOrderItemId"));
		commerceOrderItemImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		commerceOrderItemImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceOrderItemImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceOrderItemImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceOrderItemImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceOrderItemImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceOrderItemImpl.setBookedQuantityId(
			this.<Long>getColumnOriginalValue("bookedQuantityId"));
		commerceOrderItemImpl.setCommerceOrderId(
			this.<Long>getColumnOriginalValue("commerceOrderId"));
		commerceOrderItemImpl.setCommercePriceListId(
			this.<Long>getColumnOriginalValue("commercePriceListId"));
		commerceOrderItemImpl.setCPInstanceId(
			this.<Long>getColumnOriginalValue("CPInstanceId"));
		commerceOrderItemImpl.setCPMeasurementUnitId(
			this.<Long>getColumnOriginalValue("CPMeasurementUnitId"));
		commerceOrderItemImpl.setCProductId(
			this.<Long>getColumnOriginalValue("CProductId"));
		commerceOrderItemImpl.setParentCommerceOrderItemId(
			this.<Long>getColumnOriginalValue("parentCommerceOrderItemId"));
		commerceOrderItemImpl.setShippingAddressId(
			this.<Long>getColumnOriginalValue("shippingAddressId"));
		commerceOrderItemImpl.setDecimalQuantity(
			this.<BigDecimal>getColumnOriginalValue("decimalQuantity"));
		commerceOrderItemImpl.setDeliveryGroup(
			this.<String>getColumnOriginalValue("deliveryGroup"));
		commerceOrderItemImpl.setDeliveryMaxSubscriptionCycles(
			this.<Long>getColumnOriginalValue("deliveryMaxSubscriptionCycles"));
		commerceOrderItemImpl.setDeliverySubscriptionLength(
			this.<Integer>getColumnOriginalValue("deliverySubscriptionLength"));
		commerceOrderItemImpl.setDeliverySubscriptionType(
			this.<String>getColumnOriginalValue("deliverySubscriptionType"));
		commerceOrderItemImpl.setDeliverySubscriptionTypeSettings(
			this.<String>getColumnOriginalValue("deliverySubTypeSettings"));
		commerceOrderItemImpl.setDepth(
			this.<Double>getColumnOriginalValue("depth"));
		commerceOrderItemImpl.setDiscountAmount(
			this.<BigDecimal>getColumnOriginalValue("discountAmount"));
		commerceOrderItemImpl.setDiscountManuallyAdjusted(
			this.<Boolean>getColumnOriginalValue("discountManuallyAdjusted"));
		commerceOrderItemImpl.setDiscountPercentageLevel1(
			this.<BigDecimal>getColumnOriginalValue(
				"discountPercentageLevel1"));
		commerceOrderItemImpl.setDiscountPercentageLevel2(
			this.<BigDecimal>getColumnOriginalValue(
				"discountPercentageLevel2"));
		commerceOrderItemImpl.setDiscountPercentageLevel3(
			this.<BigDecimal>getColumnOriginalValue(
				"discountPercentageLevel3"));
		commerceOrderItemImpl.setDiscountPercentageLevel4(
			this.<BigDecimal>getColumnOriginalValue(
				"discountPercentageLevel4"));
		commerceOrderItemImpl.setDiscountPercentageLevel1WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"discountPctLevel1WithTaxAmount"));
		commerceOrderItemImpl.setDiscountPercentageLevel2WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"discountPctLevel2WithTaxAmount"));
		commerceOrderItemImpl.setDiscountPercentageLevel3WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"discountPctLevel3WithTaxAmount"));
		commerceOrderItemImpl.setDiscountPercentageLevel4WithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue(
				"discountPctLevel4WithTaxAmount"));
		commerceOrderItemImpl.setDiscountWithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue("discountWithTaxAmount"));
		commerceOrderItemImpl.setFinalPrice(
			this.<BigDecimal>getColumnOriginalValue("finalPrice"));
		commerceOrderItemImpl.setFinalPriceWithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue("finalPriceWithTaxAmount"));
		commerceOrderItemImpl.setFreeShipping(
			this.<Boolean>getColumnOriginalValue("freeShipping"));
		commerceOrderItemImpl.setHeight(
			this.<Double>getColumnOriginalValue("height"));
		commerceOrderItemImpl.setJson(
			this.<String>getColumnOriginalValue("json"));
		commerceOrderItemImpl.setManuallyAdjusted(
			this.<Boolean>getColumnOriginalValue("manuallyAdjusted"));
		commerceOrderItemImpl.setMaxSubscriptionCycles(
			this.<Long>getColumnOriginalValue("maxSubscriptionCycles"));
		commerceOrderItemImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		commerceOrderItemImpl.setPriceManuallyAdjusted(
			this.<Boolean>getColumnOriginalValue("priceManuallyAdjusted"));
		commerceOrderItemImpl.setPrintedNote(
			this.<String>getColumnOriginalValue("printedNote"));
		commerceOrderItemImpl.setPromoPrice(
			this.<BigDecimal>getColumnOriginalValue("promoPrice"));
		commerceOrderItemImpl.setPromoPriceWithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue("promoPriceWithTaxAmount"));
		commerceOrderItemImpl.setQuantity(
			this.<Integer>getColumnOriginalValue("quantity"));
		commerceOrderItemImpl.setRequestedDeliveryDate(
			this.<Date>getColumnOriginalValue("requestedDeliveryDate"));
		commerceOrderItemImpl.setShipSeparately(
			this.<Boolean>getColumnOriginalValue("shipSeparately"));
		commerceOrderItemImpl.setShippable(
			this.<Boolean>getColumnOriginalValue("shippable"));
		commerceOrderItemImpl.setShippedQuantity(
			this.<Integer>getColumnOriginalValue("shippedQuantity"));
		commerceOrderItemImpl.setShippingExtraPrice(
			this.<Double>getColumnOriginalValue("shippingExtraPrice"));
		commerceOrderItemImpl.setSku(
			this.<String>getColumnOriginalValue("sku"));
		commerceOrderItemImpl.setSubscription(
			this.<Boolean>getColumnOriginalValue("subscription"));
		commerceOrderItemImpl.setSubscriptionLength(
			this.<Integer>getColumnOriginalValue("subscriptionLength"));
		commerceOrderItemImpl.setSubscriptionType(
			this.<String>getColumnOriginalValue("subscriptionType"));
		commerceOrderItemImpl.setSubscriptionTypeSettings(
			this.<String>getColumnOriginalValue("subscriptionTypeSettings"));
		commerceOrderItemImpl.setUnitPrice(
			this.<BigDecimal>getColumnOriginalValue("unitPrice"));
		commerceOrderItemImpl.setUnitPriceWithTaxAmount(
			this.<BigDecimal>getColumnOriginalValue("unitPriceWithTaxAmount"));
		commerceOrderItemImpl.setWeight(
			this.<Double>getColumnOriginalValue("weight"));
		commerceOrderItemImpl.setWidth(
			this.<Double>getColumnOriginalValue("width"));

		return commerceOrderItemImpl;
	}

	@Override
	public int compareTo(CommerceOrderItem commerceOrderItem) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceOrderItem.getCreateDate());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceOrderItem)) {
			return false;
		}

		CommerceOrderItem commerceOrderItem = (CommerceOrderItem)object;

		long primaryKey = commerceOrderItem.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceOrderItem> toCacheModel() {
		CommerceOrderItemCacheModel commerceOrderItemCacheModel =
			new CommerceOrderItemCacheModel();

		commerceOrderItemCacheModel.mvccVersion = getMvccVersion();

		commerceOrderItemCacheModel.uuid = getUuid();

		String uuid = commerceOrderItemCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceOrderItemCacheModel.uuid = null;
		}

		commerceOrderItemCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceOrderItemCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceOrderItemCacheModel.externalReferenceCode = null;
		}

		commerceOrderItemCacheModel.commerceOrderItemId =
			getCommerceOrderItemId();

		commerceOrderItemCacheModel.groupId = getGroupId();

		commerceOrderItemCacheModel.companyId = getCompanyId();

		commerceOrderItemCacheModel.userId = getUserId();

		commerceOrderItemCacheModel.userName = getUserName();

		String userName = commerceOrderItemCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceOrderItemCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceOrderItemCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceOrderItemCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceOrderItemCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceOrderItemCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceOrderItemCacheModel.bookedQuantityId = getBookedQuantityId();

		commerceOrderItemCacheModel.commerceOrderId = getCommerceOrderId();

		commerceOrderItemCacheModel.commercePriceListId =
			getCommercePriceListId();

		commerceOrderItemCacheModel.CPInstanceId = getCPInstanceId();

		commerceOrderItemCacheModel.CPMeasurementUnitId =
			getCPMeasurementUnitId();

		commerceOrderItemCacheModel.CProductId = getCProductId();

		commerceOrderItemCacheModel.parentCommerceOrderItemId =
			getParentCommerceOrderItemId();

		commerceOrderItemCacheModel.shippingAddressId = getShippingAddressId();

		commerceOrderItemCacheModel.decimalQuantity = getDecimalQuantity();

		commerceOrderItemCacheModel.deliveryGroup = getDeliveryGroup();

		String deliveryGroup = commerceOrderItemCacheModel.deliveryGroup;

		if ((deliveryGroup != null) && (deliveryGroup.length() == 0)) {
			commerceOrderItemCacheModel.deliveryGroup = null;
		}

		commerceOrderItemCacheModel.deliveryMaxSubscriptionCycles =
			getDeliveryMaxSubscriptionCycles();

		commerceOrderItemCacheModel.deliverySubscriptionLength =
			getDeliverySubscriptionLength();

		commerceOrderItemCacheModel.deliverySubscriptionType =
			getDeliverySubscriptionType();

		String deliverySubscriptionType =
			commerceOrderItemCacheModel.deliverySubscriptionType;

		if ((deliverySubscriptionType != null) &&
			(deliverySubscriptionType.length() == 0)) {

			commerceOrderItemCacheModel.deliverySubscriptionType = null;
		}

		commerceOrderItemCacheModel.deliverySubscriptionTypeSettings =
			getDeliverySubscriptionTypeSettings();

		String deliverySubscriptionTypeSettings =
			commerceOrderItemCacheModel.deliverySubscriptionTypeSettings;

		if ((deliverySubscriptionTypeSettings != null) &&
			(deliverySubscriptionTypeSettings.length() == 0)) {

			commerceOrderItemCacheModel.deliverySubscriptionTypeSettings = null;
		}

		commerceOrderItemCacheModel.depth = getDepth();

		commerceOrderItemCacheModel.discountAmount = getDiscountAmount();

		commerceOrderItemCacheModel.discountManuallyAdjusted =
			isDiscountManuallyAdjusted();

		commerceOrderItemCacheModel.discountPercentageLevel1 =
			getDiscountPercentageLevel1();

		commerceOrderItemCacheModel.discountPercentageLevel2 =
			getDiscountPercentageLevel2();

		commerceOrderItemCacheModel.discountPercentageLevel3 =
			getDiscountPercentageLevel3();

		commerceOrderItemCacheModel.discountPercentageLevel4 =
			getDiscountPercentageLevel4();

		commerceOrderItemCacheModel.discountPercentageLevel1WithTaxAmount =
			getDiscountPercentageLevel1WithTaxAmount();

		commerceOrderItemCacheModel.discountPercentageLevel2WithTaxAmount =
			getDiscountPercentageLevel2WithTaxAmount();

		commerceOrderItemCacheModel.discountPercentageLevel3WithTaxAmount =
			getDiscountPercentageLevel3WithTaxAmount();

		commerceOrderItemCacheModel.discountPercentageLevel4WithTaxAmount =
			getDiscountPercentageLevel4WithTaxAmount();

		commerceOrderItemCacheModel.discountWithTaxAmount =
			getDiscountWithTaxAmount();

		commerceOrderItemCacheModel.finalPrice = getFinalPrice();

		commerceOrderItemCacheModel.finalPriceWithTaxAmount =
			getFinalPriceWithTaxAmount();

		commerceOrderItemCacheModel.freeShipping = isFreeShipping();

		commerceOrderItemCacheModel.height = getHeight();

		commerceOrderItemCacheModel.json = getJson();

		String json = commerceOrderItemCacheModel.json;

		if ((json != null) && (json.length() == 0)) {
			commerceOrderItemCacheModel.json = null;
		}

		commerceOrderItemCacheModel.manuallyAdjusted = isManuallyAdjusted();

		commerceOrderItemCacheModel.maxSubscriptionCycles =
			getMaxSubscriptionCycles();

		commerceOrderItemCacheModel.name = getName();

		String name = commerceOrderItemCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceOrderItemCacheModel.name = null;
		}

		commerceOrderItemCacheModel.priceManuallyAdjusted =
			isPriceManuallyAdjusted();

		commerceOrderItemCacheModel.printedNote = getPrintedNote();

		String printedNote = commerceOrderItemCacheModel.printedNote;

		if ((printedNote != null) && (printedNote.length() == 0)) {
			commerceOrderItemCacheModel.printedNote = null;
		}

		commerceOrderItemCacheModel.promoPrice = getPromoPrice();

		commerceOrderItemCacheModel.promoPriceWithTaxAmount =
			getPromoPriceWithTaxAmount();

		commerceOrderItemCacheModel.quantity = getQuantity();

		Date requestedDeliveryDate = getRequestedDeliveryDate();

		if (requestedDeliveryDate != null) {
			commerceOrderItemCacheModel.requestedDeliveryDate =
				requestedDeliveryDate.getTime();
		}
		else {
			commerceOrderItemCacheModel.requestedDeliveryDate = Long.MIN_VALUE;
		}

		commerceOrderItemCacheModel.shipSeparately = isShipSeparately();

		commerceOrderItemCacheModel.shippable = isShippable();

		commerceOrderItemCacheModel.shippedQuantity = getShippedQuantity();

		commerceOrderItemCacheModel.shippingExtraPrice =
			getShippingExtraPrice();

		commerceOrderItemCacheModel.sku = getSku();

		String sku = commerceOrderItemCacheModel.sku;

		if ((sku != null) && (sku.length() == 0)) {
			commerceOrderItemCacheModel.sku = null;
		}

		commerceOrderItemCacheModel.subscription = isSubscription();

		commerceOrderItemCacheModel.subscriptionLength =
			getSubscriptionLength();

		commerceOrderItemCacheModel.subscriptionType = getSubscriptionType();

		String subscriptionType = commerceOrderItemCacheModel.subscriptionType;

		if ((subscriptionType != null) && (subscriptionType.length() == 0)) {
			commerceOrderItemCacheModel.subscriptionType = null;
		}

		commerceOrderItemCacheModel.subscriptionTypeSettings =
			getSubscriptionTypeSettings();

		String subscriptionTypeSettings =
			commerceOrderItemCacheModel.subscriptionTypeSettings;

		if ((subscriptionTypeSettings != null) &&
			(subscriptionTypeSettings.length() == 0)) {

			commerceOrderItemCacheModel.subscriptionTypeSettings = null;
		}

		commerceOrderItemCacheModel.unitPrice = getUnitPrice();

		commerceOrderItemCacheModel.unitPriceWithTaxAmount =
			getUnitPriceWithTaxAmount();

		commerceOrderItemCacheModel.weight = getWeight();

		commerceOrderItemCacheModel.width = getWidth();

		return commerceOrderItemCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceOrderItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceOrderItem, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrderItem, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceOrderItem)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceOrderItem>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CommerceOrderItem.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private String _externalReferenceCode;
	private long _commerceOrderItemId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _bookedQuantityId;
	private long _commerceOrderId;
	private long _commercePriceListId;
	private long _CPInstanceId;
	private long _CPMeasurementUnitId;
	private long _CProductId;
	private long _parentCommerceOrderItemId;
	private long _shippingAddressId;
	private BigDecimal _decimalQuantity;
	private String _deliveryGroup;
	private long _deliveryMaxSubscriptionCycles;
	private int _deliverySubscriptionLength;
	private String _deliverySubscriptionType;
	private String _deliverySubscriptionTypeSettings;
	private double _depth;
	private BigDecimal _discountAmount;
	private boolean _discountManuallyAdjusted;
	private BigDecimal _discountPercentageLevel1;
	private BigDecimal _discountPercentageLevel2;
	private BigDecimal _discountPercentageLevel3;
	private BigDecimal _discountPercentageLevel4;
	private BigDecimal _discountPercentageLevel1WithTaxAmount;
	private BigDecimal _discountPercentageLevel2WithTaxAmount;
	private BigDecimal _discountPercentageLevel3WithTaxAmount;
	private BigDecimal _discountPercentageLevel4WithTaxAmount;
	private BigDecimal _discountWithTaxAmount;
	private BigDecimal _finalPrice;
	private BigDecimal _finalPriceWithTaxAmount;
	private boolean _freeShipping;
	private double _height;
	private String _json;
	private boolean _manuallyAdjusted;
	private long _maxSubscriptionCycles;
	private String _name;
	private String _nameCurrentLanguageId;
	private boolean _priceManuallyAdjusted;
	private String _printedNote;
	private BigDecimal _promoPrice;
	private BigDecimal _promoPriceWithTaxAmount;
	private int _quantity;
	private Date _requestedDeliveryDate;
	private boolean _shipSeparately;
	private boolean _shippable;
	private int _shippedQuantity;
	private double _shippingExtraPrice;
	private String _sku;
	private boolean _subscription;
	private int _subscriptionLength;
	private String _subscriptionType;
	private String _subscriptionTypeSettings;
	private BigDecimal _unitPrice;
	private BigDecimal _unitPriceWithTaxAmount;
	private double _weight;
	private double _width;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceOrderItem, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceOrderItem)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("commerceOrderItemId", _commerceOrderItemId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("bookedQuantityId", _bookedQuantityId);
		_columnOriginalValues.put("commerceOrderId", _commerceOrderId);
		_columnOriginalValues.put("commercePriceListId", _commercePriceListId);
		_columnOriginalValues.put("CPInstanceId", _CPInstanceId);
		_columnOriginalValues.put("CPMeasurementUnitId", _CPMeasurementUnitId);
		_columnOriginalValues.put("CProductId", _CProductId);
		_columnOriginalValues.put(
			"parentCommerceOrderItemId", _parentCommerceOrderItemId);
		_columnOriginalValues.put("shippingAddressId", _shippingAddressId);
		_columnOriginalValues.put("decimalQuantity", _decimalQuantity);
		_columnOriginalValues.put("deliveryGroup", _deliveryGroup);
		_columnOriginalValues.put(
			"deliveryMaxSubscriptionCycles", _deliveryMaxSubscriptionCycles);
		_columnOriginalValues.put(
			"deliverySubscriptionLength", _deliverySubscriptionLength);
		_columnOriginalValues.put(
			"deliverySubscriptionType", _deliverySubscriptionType);
		_columnOriginalValues.put(
			"deliverySubTypeSettings", _deliverySubscriptionTypeSettings);
		_columnOriginalValues.put("depth", _depth);
		_columnOriginalValues.put("discountAmount", _discountAmount);
		_columnOriginalValues.put(
			"discountManuallyAdjusted", _discountManuallyAdjusted);
		_columnOriginalValues.put(
			"discountPercentageLevel1", _discountPercentageLevel1);
		_columnOriginalValues.put(
			"discountPercentageLevel2", _discountPercentageLevel2);
		_columnOriginalValues.put(
			"discountPercentageLevel3", _discountPercentageLevel3);
		_columnOriginalValues.put(
			"discountPercentageLevel4", _discountPercentageLevel4);
		_columnOriginalValues.put(
			"discountPctLevel1WithTaxAmount",
			_discountPercentageLevel1WithTaxAmount);
		_columnOriginalValues.put(
			"discountPctLevel2WithTaxAmount",
			_discountPercentageLevel2WithTaxAmount);
		_columnOriginalValues.put(
			"discountPctLevel3WithTaxAmount",
			_discountPercentageLevel3WithTaxAmount);
		_columnOriginalValues.put(
			"discountPctLevel4WithTaxAmount",
			_discountPercentageLevel4WithTaxAmount);
		_columnOriginalValues.put(
			"discountWithTaxAmount", _discountWithTaxAmount);
		_columnOriginalValues.put("finalPrice", _finalPrice);
		_columnOriginalValues.put(
			"finalPriceWithTaxAmount", _finalPriceWithTaxAmount);
		_columnOriginalValues.put("freeShipping", _freeShipping);
		_columnOriginalValues.put("height", _height);
		_columnOriginalValues.put("json", _json);
		_columnOriginalValues.put("manuallyAdjusted", _manuallyAdjusted);
		_columnOriginalValues.put(
			"maxSubscriptionCycles", _maxSubscriptionCycles);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put(
			"priceManuallyAdjusted", _priceManuallyAdjusted);
		_columnOriginalValues.put("printedNote", _printedNote);
		_columnOriginalValues.put("promoPrice", _promoPrice);
		_columnOriginalValues.put(
			"promoPriceWithTaxAmount", _promoPriceWithTaxAmount);
		_columnOriginalValues.put("quantity", _quantity);
		_columnOriginalValues.put(
			"requestedDeliveryDate", _requestedDeliveryDate);
		_columnOriginalValues.put("shipSeparately", _shipSeparately);
		_columnOriginalValues.put("shippable", _shippable);
		_columnOriginalValues.put("shippedQuantity", _shippedQuantity);
		_columnOriginalValues.put("shippingExtraPrice", _shippingExtraPrice);
		_columnOriginalValues.put("sku", _sku);
		_columnOriginalValues.put("subscription", _subscription);
		_columnOriginalValues.put("subscriptionLength", _subscriptionLength);
		_columnOriginalValues.put("subscriptionType", _subscriptionType);
		_columnOriginalValues.put(
			"subscriptionTypeSettings", _subscriptionTypeSettings);
		_columnOriginalValues.put("unitPrice", _unitPrice);
		_columnOriginalValues.put(
			"unitPriceWithTaxAmount", _unitPriceWithTaxAmount);
		_columnOriginalValues.put("weight", _weight);
		_columnOriginalValues.put("width", _width);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put(
			"deliverySubTypeSettings", "deliverySubscriptionTypeSettings");
		attributeNames.put(
			"discountPctLevel1WithTaxAmount",
			"discountPercentageLevel1WithTaxAmount");
		attributeNames.put(
			"discountPctLevel2WithTaxAmount",
			"discountPercentageLevel2WithTaxAmount");
		attributeNames.put(
			"discountPctLevel3WithTaxAmount",
			"discountPercentageLevel3WithTaxAmount");
		attributeNames.put(
			"discountPctLevel4WithTaxAmount",
			"discountPercentageLevel4WithTaxAmount");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("externalReferenceCode", 4L);

		columnBitmasks.put("commerceOrderItemId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("bookedQuantityId", 1024L);

		columnBitmasks.put("commerceOrderId", 2048L);

		columnBitmasks.put("commercePriceListId", 4096L);

		columnBitmasks.put("CPInstanceId", 8192L);

		columnBitmasks.put("CPMeasurementUnitId", 16384L);

		columnBitmasks.put("CProductId", 32768L);

		columnBitmasks.put("parentCommerceOrderItemId", 65536L);

		columnBitmasks.put("shippingAddressId", 131072L);

		columnBitmasks.put("decimalQuantity", 262144L);

		columnBitmasks.put("deliveryGroup", 524288L);

		columnBitmasks.put("deliveryMaxSubscriptionCycles", 1048576L);

		columnBitmasks.put("deliverySubscriptionLength", 2097152L);

		columnBitmasks.put("deliverySubscriptionType", 4194304L);

		columnBitmasks.put("deliverySubTypeSettings", 8388608L);

		columnBitmasks.put("depth", 16777216L);

		columnBitmasks.put("discountAmount", 33554432L);

		columnBitmasks.put("discountManuallyAdjusted", 67108864L);

		columnBitmasks.put("discountPercentageLevel1", 134217728L);

		columnBitmasks.put("discountPercentageLevel2", 268435456L);

		columnBitmasks.put("discountPercentageLevel3", 536870912L);

		columnBitmasks.put("discountPercentageLevel4", 1073741824L);

		columnBitmasks.put("discountPctLevel1WithTaxAmount", 2147483648L);

		columnBitmasks.put("discountPctLevel2WithTaxAmount", 4294967296L);

		columnBitmasks.put("discountPctLevel3WithTaxAmount", 8589934592L);

		columnBitmasks.put("discountPctLevel4WithTaxAmount", 17179869184L);

		columnBitmasks.put("discountWithTaxAmount", 34359738368L);

		columnBitmasks.put("finalPrice", 68719476736L);

		columnBitmasks.put("finalPriceWithTaxAmount", 137438953472L);

		columnBitmasks.put("freeShipping", 274877906944L);

		columnBitmasks.put("height", 549755813888L);

		columnBitmasks.put("json", 1099511627776L);

		columnBitmasks.put("manuallyAdjusted", 2199023255552L);

		columnBitmasks.put("maxSubscriptionCycles", 4398046511104L);

		columnBitmasks.put("name", 8796093022208L);

		columnBitmasks.put("priceManuallyAdjusted", 17592186044416L);

		columnBitmasks.put("printedNote", 35184372088832L);

		columnBitmasks.put("promoPrice", 70368744177664L);

		columnBitmasks.put("promoPriceWithTaxAmount", 140737488355328L);

		columnBitmasks.put("quantity", 281474976710656L);

		columnBitmasks.put("requestedDeliveryDate", 562949953421312L);

		columnBitmasks.put("shipSeparately", 1125899906842624L);

		columnBitmasks.put("shippable", 2251799813685248L);

		columnBitmasks.put("shippedQuantity", 4503599627370496L);

		columnBitmasks.put("shippingExtraPrice", 9007199254740992L);

		columnBitmasks.put("sku", 18014398509481984L);

		columnBitmasks.put("subscription", 36028797018963968L);

		columnBitmasks.put("subscriptionLength", 72057594037927936L);

		columnBitmasks.put("subscriptionType", 144115188075855872L);

		columnBitmasks.put("subscriptionTypeSettings", 288230376151711744L);

		columnBitmasks.put("unitPrice", 576460752303423488L);

		columnBitmasks.put("unitPriceWithTaxAmount", 1152921504606846976L);

		columnBitmasks.put("weight", 2305843009213693952L);

		columnBitmasks.put("width", 4611686018427387904L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceOrderItem _escapedModel;

}