/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.upgrade.v8_9_3;

import com.liferay.commerce.product.service.CommerceChannelRelLocalService;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

import java.sql.ResultSet;
import java.sql.Statement;

/**
 * @author Brian I. Kim
 */
public class CommerceCountryUpgradeProcess extends UpgradeProcess {

	public CommerceCountryUpgradeProcess(
		CommerceChannelRelLocalService commerceChannelRelLocalService) {

		_commerceChannelRelLocalService = commerceChannelRelLocalService;
	}

	@Override
	protected void doUpgrade() throws Exception {
		try (Statement statement = connection.createStatement()) {
			ResultSet resultSet = statement.executeQuery(
				SQLTransformer.transform(
					"select countryId from Country where groupFilterEnabled " +
						"= [$FALSE$]"));

			while (resultSet.next()) {
				long countryId = resultSet.getLong("countryId");

				_commerceChannelRelLocalService.deleteCommerceChannelRels(
					Country.class.getName(), countryId);
			}
		}
	}

	private final CommerceChannelRelLocalService
		_commerceChannelRelLocalService;

}