/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.upgrade.v8_9_1;

import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.price.list.model.CommercePriceList;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

/**
 * @author Crescenzo Rega
 */
public class CommerceChannelAccountEntryRelUpgradeProcess
	extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		try (PreparedStatement preparedStatement1 = connection.prepareStatement(
				StringBundler.concat(
					"select CChannelAccountEntryRel.CChannelAccountEntryRelId ",
					"from CChannelAccountEntryRel inner join ",
					"CommercePriceList on CChannelAccountEntryRel.classPK = ",
					"CommercePriceList.commercePriceListId inner join ",
					"ClassName_ on CChannelAccountEntryRel.classNameId = ",
					"ClassName_.classNameId where ClassName_.classNameId = ",
					ClassNameLocalServiceUtil.getClassNameId(
						CommerceDiscount.class)));
			PreparedStatement preparedStatement2 =
				AutoBatchPreparedStatementUtil.concurrentAutoBatch(
					connection,
					"update CChannelAccountEntryRel set classNameId = ? " +
						"where CChannelAccountEntryRelId = ?")) {

			try (ResultSet resultSet = preparedStatement1.executeQuery()) {
				while (resultSet.next()) {
					preparedStatement2.setLong(
						1,
						ClassNameLocalServiceUtil.getClassNameId(
							CommercePriceList.class));
					preparedStatement2.setLong(
						2, resultSet.getLong("CChannelAccountEntryRelId"));

					preparedStatement2.addBatch();
				}

				preparedStatement2.executeBatch();
			}
		}
	}

}