/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.security.permission.resource;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel;
import com.liferay.commerce.service.CommerceShippingOptionAccountEntryRelService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

/**
 * @author Danny Situ
 */
@Component(
	property = "model.class.name=com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel",
	service = ModelResourcePermission.class
)
public class CommerceShippingOptionAccountEntryRelModelResourcePermission
	implements ModelResourcePermission<CommerceShippingOptionAccountEntryRel> {

	@Override
	public void check(
			PermissionChecker permissionChecker,
			CommerceShippingOptionAccountEntryRel
				commerceShippingOptionAccountEntryRel,
			String actionId)
		throws PortalException {

		if (!contains(
				permissionChecker, commerceShippingOptionAccountEntryRel,
				actionId)) {

			throw new PrincipalException.MustHavePermission(
				permissionChecker,
				CommerceShippingOptionAccountEntryRel.class.getName(),
				commerceShippingOptionAccountEntryRel.
					getCommerceShippingOptionAccountEntryRelId(),
				actionId);
		}
	}

	@Override
	public void check(
			PermissionChecker permissionChecker,
			long commerceShippingOptionAccountEntryRelId, String actionId)
		throws PortalException {

		if (!contains(
				permissionChecker, commerceShippingOptionAccountEntryRelId,
				actionId)) {

			throw new PrincipalException.MustHavePermission(
				permissionChecker,
				CommerceShippingOptionAccountEntryRel.class.getName(),
				commerceShippingOptionAccountEntryRelId, actionId);
		}
	}

	@Override
	public boolean contains(
			PermissionChecker permissionChecker,
			CommerceShippingOptionAccountEntryRel
				commerceShippingOptionAccountEntryRel,
			String actionId)
		throws PortalException {

		return contains(
			permissionChecker,
			commerceShippingOptionAccountEntryRel.
				getCommerceShippingOptionAccountEntryRelId(),
			actionId);
	}

	@Override
	public boolean contains(
			PermissionChecker permissionChecker,
			long commerceShippingOptionAccountEntryRelId, String actionId)
		throws PortalException {

		CommerceShippingOptionAccountEntryRel
			commerceShippingOptionAccountEntryRel =
				_commerceShippingOptionAccountEntryRelService.
					getCommerceShippingOptionAccountEntryRel(
						commerceShippingOptionAccountEntryRelId);

		if (permissionChecker.isCompanyAdmin(
				commerceShippingOptionAccountEntryRel.getCompanyId()) ||
			permissionChecker.isOmniadmin()) {

			return true;
		}

		if (permissionChecker.hasOwnerPermission(
				permissionChecker.getCompanyId(),
				CommerceShippingOptionAccountEntryRel.class.getName(),
				commerceShippingOptionAccountEntryRelId,
				permissionChecker.getUserId(), actionId) &&
			(commerceShippingOptionAccountEntryRel.getUserId() ==
				permissionChecker.getUserId())) {

			return true;
		}

		return _accountEntryModelResourcePermission.contains(
			permissionChecker,
			commerceShippingOptionAccountEntryRel.getAccountEntryId(),
			actionId);
	}

	@Override
	public String getModelName() {
		return CommerceShippingOptionAccountEntryRel.class.getName();
	}

	@Override
	public PortletResourcePermission getPortletResourcePermission() {
		return null;
	}

	@Reference(
		policy = ReferencePolicy.DYNAMIC,
		policyOption = ReferencePolicyOption.GREEDY,
		target = "(model.class.name=com.liferay.account.model.AccountEntry)"
	)
	private volatile ModelResourcePermission<AccountEntry>
		_accountEntryModelResourcePermission;

	@Reference
	private CommerceShippingOptionAccountEntryRelService
		_commerceShippingOptionAccountEntryRelService;

}