/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v2_2_0;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CommerceOrderUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderUpgradeProcess.class);
    private final CommerceAccountLocalService _commerceAccountLocalService;
    private final UserLocalService _userLocalService;

    public CommerceOrderUpgradeProcess(CommerceAccountLocalService commerceAccountLocalService, UserLocalService userLocalService) {
        this._commerceAccountLocalService = commerceAccountLocalService;
        this._userLocalService = userLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (this.hasColumn("CommerceOrder", "siteGroupId")) {
            this.runSQL("update CommerceOrder set groupId = siteGroupId");
            this.alterTableDropColumn("CommerceOrder", "siteGroupId");
        }
        if (!this.hasColumn("CommerceOrder", "orderOrganizationId") || !this.hasColumn("CommerceOrder", "orderUserId")) {
            return;
        }
        String updateCommerceOrderSQL1 = "update CommerceOrder set commerceAccountId = ? where orderOrganizationId = ?";
        String updateCommerceOrderSQL2 = "update CommerceOrder set commerceAccountId = ? where orderUserId = ?";
        try (PreparedStatement preparedStatement1 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)updateCommerceOrderSQL1);
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)updateCommerceOrderSQL2);
             Statement s = this.connection.createStatement(1003, 1007);
             ResultSet resultSet = s.executeQuery("select distinct orderOrganizationId, orderUserId from CommerceOrder");){
            while (resultSet.next()) {
                long orderOrganizationId = resultSet.getLong("orderOrganizationId");
                long orderUserId = resultSet.getLong("orderUserId");
                if (orderOrganizationId > 0L) {
                    long commerceAccountId = this._getCommerceAccountId(orderOrganizationId);
                    if (commerceAccountId == 0L) {
                        _log.error((Object)("No CommerceAccount for orderOrganizationId " + orderOrganizationId));
                        continue;
                    }
                    preparedStatement1.setLong(1, commerceAccountId);
                    preparedStatement1.setLong(2, orderOrganizationId);
                    preparedStatement1.execute();
                    continue;
                }
                if (orderUserId <= 0L) continue;
                User user = this._userLocalService.getUser(orderUserId);
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCompanyId(user.getCompanyId());
                serviceContext.setUserId(user.getUserId());
                CommerceAccount commerceAccount = this._commerceAccountLocalService.addPersonalCommerceAccount(user.getUserId(), "", "", serviceContext);
                preparedStatement2.setLong(1, commerceAccount.getCommerceAccountId());
                preparedStatement2.setLong(2, orderUserId);
                preparedStatement2.execute();
            }
            preparedStatement1.executeBatch();
            preparedStatement2.executeBatch();
        }
    }

    protected UpgradeStep[] getPostUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.dropColumns((String)"CommerceOrder", (String[])new String[]{"orderOrganizationId", "orderUserId"})};
    }

    protected UpgradeStep[] getPreUpgradeSteps() {
        return new UpgradeStep[]{UpgradeProcessFactory.addColumns((String)"CommerceOrder", (String[])new String[]{"commerceAccountId LONG"})};
    }

    private long _getCommerceAccountId(long organizationId) throws SQLException {
        String sql = "select commerceAccountId from CommerceAccountOrganizationRel where organizationId = " + organizationId;
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery(sql);){
            if (resultSet.next()) {
                long l = resultSet.getLong("commerceAccountId");
                return l;
            }
        }
        return 0L;
    }
}

