/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.product.content.contributor;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceRequest;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.option.CommerceOptionValue;
import com.liferay.commerce.product.option.CommerceOptionValueHelper;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPContentContributor;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.commerce.util.CommerceBigDecimalUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.product.content.contributor.name=price"}, service={CPContentContributor.class})
public class PriceCPContentContributor
implements CPContentContributor {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOptionValueHelper _commerceOptionValueHelper;
    @Reference
    private CommerceProductPriceCalculation _commerceProductPriceCalculation;
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Portal _portal;

    public String getName() {
        return "price";
    }

    public JSONObject getValue(CPInstance cpInstance, HttpServletRequest httpServletRequest) throws PortalException {
        CommerceContext commerceContext;
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        if (cpInstance == null) {
            return jsonObject;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(httpServletRequest));
        if (commerceChannel == null) {
            return jsonObject;
        }
        String ddmFormValues = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"ddmFormValues");
        List commerceOptionValues = this._commerceOptionValueHelper.getCPDefinitionCommerceOptionValues(cpInstance.getCPDefinitionId(), ddmFormValues);
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        CommerceProductPrice commerceProductPrice = this._commerceProductPriceCalculation.getCommerceProductPrice(this._getCommerceProductPriceRequest(cpInstance, cpDefinitionInventoryEngine, commerceContext = (CommerceContext)httpServletRequest.getAttribute("COMMERCE_CONTEXT"), commerceOptionValues));
        CommerceMoney unitPriceCommerceMoney = commerceProductPrice.getUnitPrice();
        if (unitPriceCommerceMoney.isEmpty()) {
            return jsonObject;
        }
        Locale locale = this._portal.getLocale(httpServletRequest);
        jsonObject.put("price", unitPriceCommerceMoney.format(locale));
        CommerceMoney unitPromoPriceCommerceMoney = commerceProductPrice.getUnitPromoPrice();
        if (unitPromoPriceCommerceMoney.isEmpty()) {
            return jsonObject;
        }
        if (CommerceBigDecimalUtil.gt((BigDecimal)unitPromoPriceCommerceMoney.getPrice(), (BigDecimal)BigDecimal.ZERO) && CommerceBigDecimalUtil.lte((BigDecimal)unitPromoPriceCommerceMoney.getPrice(), (BigDecimal)unitPriceCommerceMoney.getPrice())) {
            jsonObject.put("promoPrice", unitPromoPriceCommerceMoney.format(locale));
        }
        return jsonObject;
    }

    private CommerceProductPriceRequest _getCommerceProductPriceRequest(CPInstance cpInstance, CPDefinitionInventoryEngine cpDefinitionInventoryEngine, CommerceContext commerceContext, List<CommerceOptionValue> commerceOptionValues) throws PortalException {
        CommerceProductPriceRequest commerceProductPriceRequest = new CommerceProductPriceRequest();
        commerceProductPriceRequest.setCpInstanceId(cpInstance.getCPInstanceId());
        commerceProductPriceRequest.setQuantity(cpDefinitionInventoryEngine.getMinOrderQuantity(cpInstance));
        commerceProductPriceRequest.setSecure(false);
        commerceProductPriceRequest.setCommerceContext(commerceContext);
        commerceProductPriceRequest.setCommerceOptionValues(commerceOptionValues);
        return commerceProductPriceRequest;
    }
}

