/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.internal.price.BaseCommerceOrderPriceCalculation;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.price.CommerceOrderPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.price.CommerceOrderPriceImpl;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommerceOrderPriceCalculation.class})
public class CommerceOrderPriceCalculationV2Impl
extends BaseCommerceOrderPriceCalculation {
    @Reference
    private CommerceDiscountCalculation _commerceDiscountCalculation;
    @Reference
    private CommerceTaxCalculation _commerceTaxCalculation;

    public CommerceOrderPrice getCommerceOrderPrice(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        CommerceDiscountValue orderTotalCommerceDiscountValue;
        CommerceMoney discountAmountCommerceMoney;
        CommerceDiscountValue orderSubtotalCommerceDiscountValue;
        CommerceDiscountValue orderShippingCommerceDiscountValue;
        BigDecimal subtotalAmount;
        if (commerceOrder == null) {
            return this.getEmptyCommerceOrderPrice(commerceContext.getCommerceCurrency());
        }
        if (!commerceOrder.isOpen()) {
            return this.getCommerceOrderPriceFromOrder(commerceOrder);
        }
        BigDecimal shippingAmount = commerceOrder.getShippingAmount();
        CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        CommerceMoney shippingTaxAmountCommerceMoney = this._commerceTaxCalculation.getShippingTaxValue(commerceOrder, commerceCurrency);
        BigDecimal shippingWithTaxAmount = shippingAmount.add(shippingTaxAmountCommerceMoney.getPrice());
        CommerceMoney subtotalCommerceMoney = this.getSubtotal(commerceOrder, secure, commerceContext);
        BigDecimal totalAmount = subtotalAmount = subtotalCommerceMoney.getPrice();
        CommerceMoney taxValueCommerceMoney = this.getTaxValue(commerceOrder, secure, commerceContext);
        BigDecimal subtotalWithTaxAmount = subtotalAmount.add(taxValueCommerceMoney.getPrice());
        BigDecimal totalTaxValue = taxValueCommerceMoney.getPrice();
        totalTaxValue = totalTaxValue.add(shippingTaxAmountCommerceMoney.getPrice());
        BigDecimal totalWithTaxAmount = totalAmount.add(totalTaxValue);
        BigDecimal shippingDiscounted = shippingAmount;
        BigDecimal shippingDiscountedWithTaxAmount = shippingWithTaxAmount;
        BigDecimal subtotalDiscounted = subtotalAmount;
        BigDecimal subtotalDiscountedWithTaxAmount = subtotalWithTaxAmount;
        BigDecimal totalDiscounted = totalAmount;
        BigDecimal totalDiscountedWithTaxAmount = totalWithTaxAmount;
        boolean discountsTargetNetPrice = true;
        CommerceChannel commerceChannel = this.commerceChannelLocalService.fetchCommerceChannel(commerceContext.getCommerceChannelId());
        if (commerceChannel != null) {
            discountsTargetNetPrice = commerceChannel.isDiscountsTargetNetPrice();
        }
        if (discountsTargetNetPrice) {
            orderShippingCommerceDiscountValue = this._commerceDiscountCalculation.getOrderShippingCommerceDiscountValue(commerceOrder, shippingAmount, commerceContext);
            orderSubtotalCommerceDiscountValue = this._commerceDiscountCalculation.getOrderSubtotalCommerceDiscountValue(commerceOrder, subtotalAmount, commerceContext);
            if (orderSubtotalCommerceDiscountValue != null) {
                discountAmountCommerceMoney = orderSubtotalCommerceDiscountValue.getDiscountAmount();
                totalAmount = totalAmount.subtract(discountAmountCommerceMoney.getPrice());
                subtotalDiscounted = subtotalDiscounted.subtract(discountAmountCommerceMoney.getPrice());
            }
            totalAmount = totalAmount.add(shippingAmount);
            if (orderShippingCommerceDiscountValue != null) {
                discountAmountCommerceMoney = orderShippingCommerceDiscountValue.getDiscountAmount();
                totalAmount = totalAmount.subtract(discountAmountCommerceMoney.getPrice());
                shippingDiscounted = shippingDiscounted.subtract(discountAmountCommerceMoney.getPrice());
            }
            totalDiscounted = totalAmount;
            orderTotalCommerceDiscountValue = this._commerceDiscountCalculation.getOrderTotalCommerceDiscountValue(commerceOrder, totalAmount, commerceContext);
            if (orderTotalCommerceDiscountValue != null) {
                discountAmountCommerceMoney = orderTotalCommerceDiscountValue.getDiscountAmount();
                totalDiscounted = totalDiscounted.subtract(discountAmountCommerceMoney.getPrice());
            }
            subtotalDiscountedWithTaxAmount = subtotalDiscounted.add(taxValueCommerceMoney.getPrice());
            shippingDiscountedWithTaxAmount = shippingDiscounted.add(shippingTaxAmountCommerceMoney.getPrice());
            totalDiscountedWithTaxAmount = totalDiscounted.add(totalTaxValue);
            totalWithTaxAmount = totalAmount.add(totalTaxValue);
        } else {
            orderShippingCommerceDiscountValue = this._commerceDiscountCalculation.getOrderShippingCommerceDiscountValue(commerceOrder, shippingWithTaxAmount, commerceContext);
            orderSubtotalCommerceDiscountValue = this._commerceDiscountCalculation.getOrderSubtotalCommerceDiscountValue(commerceOrder, subtotalWithTaxAmount, commerceContext);
            if (orderSubtotalCommerceDiscountValue != null) {
                discountAmountCommerceMoney = orderSubtotalCommerceDiscountValue.getDiscountAmount();
                totalWithTaxAmount = totalWithTaxAmount.subtract(discountAmountCommerceMoney.getPrice());
                subtotalDiscountedWithTaxAmount = subtotalDiscountedWithTaxAmount.subtract(discountAmountCommerceMoney.getPrice());
            }
            totalWithTaxAmount = totalWithTaxAmount.add(shippingAmount);
            if (orderShippingCommerceDiscountValue != null) {
                discountAmountCommerceMoney = orderShippingCommerceDiscountValue.getDiscountAmount();
                totalWithTaxAmount = totalWithTaxAmount.subtract(discountAmountCommerceMoney.getPrice());
                shippingDiscountedWithTaxAmount = shippingDiscountedWithTaxAmount.subtract(discountAmountCommerceMoney.getPrice());
                CommerceDiscountValue orderShippingWithoutTaxCommerceDiscountValue = this._commerceDiscountCalculation.getOrderShippingCommerceDiscountValue(commerceOrder, shippingAmount, commerceContext);
                if (orderShippingWithoutTaxCommerceDiscountValue != null) {
                    CommerceMoney discountWithoutTaxAmountCommerceMoney = orderShippingWithoutTaxCommerceDiscountValue.getDiscountAmount();
                    BigDecimal discountWithoutTax = discountWithoutTaxAmountCommerceMoney.getPrice();
                    BigDecimal discountWithTax = discountAmountCommerceMoney.getPrice();
                    BigDecimal shippingTaxValueDifference = discountWithTax.subtract(discountWithoutTax);
                    totalTaxValue = totalTaxValue.subtract(shippingTaxValueDifference);
                }
            }
            totalDiscountedWithTaxAmount = totalWithTaxAmount;
            orderTotalCommerceDiscountValue = this._commerceDiscountCalculation.getOrderTotalCommerceDiscountValue(commerceOrder, totalWithTaxAmount, commerceContext);
            if (orderTotalCommerceDiscountValue != null) {
                discountAmountCommerceMoney = orderTotalCommerceDiscountValue.getDiscountAmount();
                totalDiscountedWithTaxAmount = totalDiscountedWithTaxAmount.subtract(discountAmountCommerceMoney.getPrice());
            }
            shippingDiscounted = shippingDiscountedWithTaxAmount.subtract(shippingTaxAmountCommerceMoney.getPrice());
            subtotalDiscounted = subtotalDiscountedWithTaxAmount.subtract(taxValueCommerceMoney.getPrice());
            totalDiscounted = totalDiscountedWithTaxAmount.subtract(totalTaxValue);
            totalAmount = totalWithTaxAmount.subtract(totalTaxValue);
        }
        CommerceOrderPriceImpl commerceOrderPriceImpl = new CommerceOrderPriceImpl();
        this.setDiscountValues(discountsTargetNetPrice, shippingAmount, shippingDiscounted, orderShippingCommerceDiscountValue, subtotalAmount, subtotalDiscounted, orderSubtotalCommerceDiscountValue, totalAmount, totalDiscounted, orderTotalCommerceDiscountValue, commerceOrderPriceImpl, commerceOrder);
        commerceOrderPriceImpl.setShippingValue(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), shippingAmount));
        commerceOrderPriceImpl.setShippingValueWithTaxAmount(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), shippingWithTaxAmount));
        commerceOrderPriceImpl.setSubtotal(subtotalCommerceMoney);
        commerceOrderPriceImpl.setSubtotalWithTaxAmount(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), subtotalWithTaxAmount));
        commerceOrderPriceImpl.setTaxValue(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), totalTaxValue));
        commerceOrderPriceImpl.setTotal(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), totalDiscounted.add(totalTaxValue)));
        commerceOrderPriceImpl.setTotalWithTaxAmount(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), totalDiscountedWithTaxAmount));
        this.setDiscountValuesWithTaxAmount(discountsTargetNetPrice, shippingWithTaxAmount, shippingDiscountedWithTaxAmount, orderShippingCommerceDiscountValue, subtotalWithTaxAmount, subtotalDiscountedWithTaxAmount, orderSubtotalCommerceDiscountValue, totalWithTaxAmount, totalDiscountedWithTaxAmount, orderTotalCommerceDiscountValue, commerceOrderPriceImpl, commerceOrder);
        return commerceOrderPriceImpl;
    }

    public CommerceOrderPrice getCommerceOrderPrice(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getCommerceOrderPrice(commerceOrder, true, commerceContext);
    }

    public CommerceMoney getSubtotal(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        BigDecimal subtotal = BigDecimal.ZERO;
        if (commerceOrder == null) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), subtotal);
        }
        if (!commerceOrder.isOpen()) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), commerceOrder.getSubtotal());
        }
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            subtotal = subtotal.add(commerceOrderItem.getFinalPrice());
        }
        return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), subtotal);
    }

    public CommerceMoney getSubtotal(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getSubtotal(commerceOrder, true, commerceContext);
    }

    public CommerceMoney getTaxValue(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        if (commerceOrder == null) {
            return this.commerceMoneyFactory.emptyCommerceMoney();
        }
        if (!commerceOrder.isOpen()) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), commerceOrder.getTaxAmount());
        }
        return this._commerceTaxCalculation.getTaxAmount(commerceOrder, commerceContext.getCommerceCurrency());
    }

    public CommerceMoney getTaxValue(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getTaxValue(commerceOrder, true, commerceContext);
    }

    public CommerceMoney getTotal(CommerceOrder commerceOrder, boolean secure, CommerceContext commerceContext) throws PortalException {
        if (!commerceOrder.isOpen()) {
            return this.commerceMoneyFactory.create(commerceContext.getCommerceCurrency(), commerceOrder.getTotal());
        }
        CommerceOrderPrice commerceOrderPrice = this.getCommerceOrderPrice(commerceOrder, commerceContext);
        return commerceOrderPrice.getTotal();
    }

    public CommerceMoney getTotal(CommerceOrder commerceOrder, CommerceContext commerceContext) throws PortalException {
        return this.getTotal(commerceOrder, true, commerceContext);
    }
}

