/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.health.status;

import com.liferay.commerce.health.status.CommerceHealthHttpStatus;
import com.liferay.commerce.health.status.CommerceHealthHttpStatusRegistry;
import com.liferay.commerce.internal.health.status.comparator.CommerceHealthStatusServiceWrapperDisplayOrderComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={CommerceHealthHttpStatusRegistry.class})
public class CommerceHealthHttpStatusRegistryImpl
implements CommerceHealthHttpStatusRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CommerceHealthHttpStatusRegistryImpl.class);
    private static final Comparator<ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceHealthHttpStatus>> _commerceHealthStatusServiceWrapperDisplayOrderComparator = new CommerceHealthStatusServiceWrapperDisplayOrderComparator();
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceHealthHttpStatus>> _serviceTrackerMap;

    public CommerceHealthHttpStatus getCommerceHealthStatus(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        ServiceTrackerCustomizerFactory.ServiceWrapper commerceHealthStatusServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)key);
        if (commerceHealthStatusServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No commerce health status registered with key " + key));
            }
            return null;
        }
        return (CommerceHealthHttpStatus)commerceHealthStatusServiceWrapper.getService();
    }

    public List<CommerceHealthHttpStatus> getCommerceHealthStatuses(int type) {
        ArrayList<CommerceHealthHttpStatus> commerceHealthHttpStatuses = new ArrayList<CommerceHealthHttpStatus>();
        List commerceHealthStatusServiceWrappers = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        Collections.sort(commerceHealthStatusServiceWrappers, _commerceHealthStatusServiceWrapperDisplayOrderComparator);
        for (ServiceTrackerCustomizerFactory.ServiceWrapper commerceHealthStatusServiceWrapper : commerceHealthStatusServiceWrappers) {
            CommerceHealthHttpStatus commerceHealthHttpStatus = (CommerceHealthHttpStatus)commerceHealthStatusServiceWrapper.getService();
            if (type != commerceHealthHttpStatus.getType()) continue;
            commerceHealthHttpStatuses.add(commerceHealthHttpStatus);
        }
        return Collections.unmodifiableList(commerceHealthHttpStatuses);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommerceHealthHttpStatus.class, (String)"commerce.health.status.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

