/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.util;

import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.price.CommercePriceCalculationRegistry;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Riccardo Alberti
 */
@Component(service = CommercePriceCalculationRegistry.class)
public class CommercePriceCalculationRegistryImpl
	implements CommercePriceCalculationRegistry {

	@Override
	public CommerceOrderPriceCalculation getCommerceOrderPriceCalculation(
		String key) {

		return _orderPriceServiceTrackerMap.getService(key);
	}

	@Override
	public Map<String, CommerceOrderPriceCalculation>
		getCommerceOrderPriceCalculations() {

		Map<String, CommerceOrderPriceCalculation>
			commerceOrderPriceCalculations = new HashMap<>();

		for (String key : _orderPriceServiceTrackerMap.keySet()) {
			commerceOrderPriceCalculations.put(
				key, _orderPriceServiceTrackerMap.getService(key));
		}

		return Collections.unmodifiableMap(commerceOrderPriceCalculations);
	}

	@Override
	public CommerceProductPriceCalculation getCommerceProductPriceCalculation(
		String key) {

		return _productPriceServiceTrackerMap.getService(key);
	}

	@Override
	public Map<String, CommerceProductPriceCalculation>
		getCommerceProductPriceCalculations() {

		Map<String, CommerceProductPriceCalculation>
			commerceProductPriceCalculations = new HashMap<>();

		for (String key : _productPriceServiceTrackerMap.keySet()) {
			commerceProductPriceCalculations.put(
				key, _productPriceServiceTrackerMap.getService(key));
		}

		return Collections.unmodifiableMap(commerceProductPriceCalculations);
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_productPriceServiceTrackerMap =
			ServiceTrackerMapFactory.openSingleValueMap(
				bundleContext, CommerceProductPriceCalculation.class,
				"commerce.price.calculation.key");

		_orderPriceServiceTrackerMap =
			ServiceTrackerMapFactory.openSingleValueMap(
				bundleContext, CommerceOrderPriceCalculation.class,
				"commerce.price.calculation.key");
	}

	@Deactivate
	protected void deactivate() {
		_productPriceServiceTrackerMap.close();
	}

	private ServiceTrackerMap<String, CommerceOrderPriceCalculation>
		_orderPriceServiceTrackerMap;
	private ServiceTrackerMap<String, CommerceProductPriceCalculation>
		_productPriceServiceTrackerMap;

}