/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.subscription;

import com.liferay.commerce.configuration.CommerceSubscriptionConfiguration;
import com.liferay.commerce.constants.CommerceSubscriptionEntryConstants;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.payment.engine.CommerceSubscriptionEngine;
import com.liferay.commerce.service.CommerceSubscriptionEntryLocalService;
import com.liferay.commerce.subscription.CommerceSubscriptionEntryActionHelper;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(service = CommerceSubscriptionEntryActionHelper.class)
public class CommerceSubscriptionEntryActionHelperImpl
	implements CommerceSubscriptionEntryActionHelper {

	@Override
	public void activateCommerceSubscriptionEntry(
			long commerceSubscriptionEntryId)
		throws Exception {

		CommerceSubscriptionEntry commerceSubscriptionEntry =
			_commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(
				commerceSubscriptionEntryId);

		if (CommerceSubscriptionEntryConstants.SUBSCRIPTION_STATUS_SUSPENDED !=
				commerceSubscriptionEntry.getSubscriptionStatus()) {

			return;
		}

		_commerceSubscriptionEngine.activateRecurringPayment(
			commerceSubscriptionEntryId);
	}

	@Override
	public void cancelCommerceSubscriptionEntry(
			long commerceSubscriptionEntryId)
		throws Exception {

		CommerceSubscriptionConfiguration commerceSubscriptionConfiguration =
			_configurationProvider.getSystemConfiguration(
				CommerceSubscriptionConfiguration.class);

		if (commerceSubscriptionConfiguration.
				subscriptionCancellationAllowed()) {

			_commerceSubscriptionEngine.cancelRecurringPayment(
				commerceSubscriptionEntryId);
		}
	}

	@Override
	public void suspendCommerceSubscriptionEntry(
			long commerceSubscriptionEntryId)
		throws Exception {

		CommerceSubscriptionConfiguration commerceSubscriptionConfiguration =
			_configurationProvider.getSystemConfiguration(
				CommerceSubscriptionConfiguration.class);

		if (commerceSubscriptionConfiguration.subscriptionSuspensionAllowed()) {
			_commerceSubscriptionEngine.suspendRecurringPayment(
				commerceSubscriptionEntryId);
		}
	}

	@Reference
	private CommerceSubscriptionEngine _commerceSubscriptionEngine;

	@Reference
	private CommerceSubscriptionEntryLocalService
		_commerceSubscriptionEntryLocalService;

	@Reference
	private ConfigurationProvider _configurationProvider;

}