/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.security.permission.resource;

import com.liferay.commerce.model.CommerceOrderTypeRel;
import com.liferay.commerce.permission.CommerceOrderTypePermission;
import com.liferay.commerce.service.CommerceOrderTypeRelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Riccardo Alberti
 */
@Component(
	property = "model.class.name=com.liferay.commerce.model.CommerceOrderTypeRel",
	service = ModelResourcePermission.class
)
public class CommerceOrderTypeRelModelResourcePermission
	implements ModelResourcePermission<CommerceOrderTypeRel> {

	@Override
	public void check(
			PermissionChecker permissionChecker,
			CommerceOrderTypeRel commerceOrderTypeRel, String actionId)
		throws PortalException {

		_commerceOrderTypePermission.check(
			permissionChecker, commerceOrderTypeRel.getCommerceOrderTypeId(),
			actionId);
	}

	@Override
	public void check(
			PermissionChecker permissionChecker, long commerceOrderTypeRelId,
			String actionId)
		throws PortalException {

		CommerceOrderTypeRel commerceOrderTypeRel =
			_commerceOrderTypeRelLocalService.getCommerceOrderTypeRel(
				commerceOrderTypeRelId);

		_commerceOrderTypePermission.check(
			permissionChecker, commerceOrderTypeRel.getCommerceOrderTypeId(),
			actionId);
	}

	@Override
	public boolean contains(
			PermissionChecker permissionChecker,
			CommerceOrderTypeRel commerceOrderTypeRel, String actionId)
		throws PortalException {

		return _commerceOrderTypePermission.contains(
			permissionChecker, commerceOrderTypeRel.getCommerceOrderTypeId(),
			actionId);
	}

	@Override
	public boolean contains(
			PermissionChecker permissionChecker, long commerceOrderTypeRelId,
			String actionId)
		throws PortalException {

		CommerceOrderTypeRel commerceOrderTypeRel =
			_commerceOrderTypeRelLocalService.getCommerceOrderTypeRel(
				commerceOrderTypeRelId);

		return _commerceOrderTypePermission.contains(
			permissionChecker, commerceOrderTypeRel.getCommerceOrderTypeId(),
			actionId);
	}

	@Override
	public String getModelName() {
		return CommerceOrderTypeRel.class.getName();
	}

	@Override
	public PortletResourcePermission getPortletResourcePermission() {
		return null;
	}

	@Reference
	private CommerceOrderTypePermission _commerceOrderTypePermission;

	@Reference
	private CommerceOrderTypeRelLocalService _commerceOrderTypeRelLocalService;

}