/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.commerce.model.CommerceOrder"}, service={KeywordQueryContributor.class})
public class CommerceOrderKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    private QueryHelper _queryHelper;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "entryClassPK", false);
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "accountName", false);
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "externalReferenceCode", false);
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "orderCreatorEmailAddress", false);
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "name", false);
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "purchaseOrderNumber", false);
        this._queryHelper.addSearchTerm(booleanQuery, searchContext, "sku", false);
        if (Validator.isNotNull((String)keywords)) {
            try {
                keywords = StringUtil.toLowerCase((String)keywords);
                booleanQuery.add((Query)this._getTrailingWildcardQuery("entryClassPK", keywords), BooleanClauseOccur.SHOULD);
                booleanQuery.add((Query)this._getTrailingWildcardQuery("accountName", keywords), BooleanClauseOccur.SHOULD);
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
        }
    }

    private WildcardQuery _getTrailingWildcardQuery(String field, String value) {
        return new WildcardQueryImpl(field, value + "*");
    }
}

