/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.object.system;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderTable;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.object.model.ObjectField;
import com.liferay.object.system.BaseSystemObjectDefinitionMetadata;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SystemObjectDefinitionMetadata.class})
public class CommerceOrderSystemObjectDefinitionMetadata
extends BaseSystemObjectDefinitionMetadata {
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;

    public BaseModel<?> deleteBaseModel(BaseModel<?> baseModel) throws PortalException {
        return this._commerceOrderLocalService.deleteCommerceOrder((CommerceOrder)baseModel);
    }

    public BaseModel<?> getBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this._commerceOrderLocalService.getCommerceOrderByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public String getExternalReferenceCode(long primaryKey) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(primaryKey);
        return commerceOrder.getExternalReferenceCode();
    }

    public JaxRsApplicationDescriptor getJaxRsApplicationDescriptor() {
        return new JaxRsApplicationDescriptor("Liferay.Headless.Commerce.Admin.Order", "headless-commerce-admin-order", "orders", "v1.0");
    }

    public Map<Locale, String> getLabelMap() {
        return this.createLabelMap("commerce-order");
    }

    public Class<?> getModelClass() {
        return CommerceOrder.class;
    }

    public List<ObjectField> getObjectFields() {
        return Arrays.asList(this.createObjectField("Integer", "Integer", "order-status", "orderStatus", true, true), this.createObjectField("PrecisionDecimal", "BigDecimal", "shipping-amount", "shippingAmount", true, true));
    }

    public Map<Locale, String> getPluralLabelMap() {
        return this.createLabelMap("commerce-orders");
    }

    public Column<?, Long> getPrimaryKeyColumn() {
        return CommerceOrderTable.INSTANCE.commerceOrderId;
    }

    public String getScope() {
        return "company";
    }

    public Table getTable() {
        return CommerceOrderTable.INSTANCE;
    }

    public int getVersion() {
        return 1;
    }
}

