/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.messaging;

import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/commerce_order_status"}, service={MessageListener.class})
public class CommerceOrderStatusMessageListener
extends BaseMessageListener {
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private UserService _userService;

    protected void doReceive(Message message) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(String.valueOf(message.getPayload()));
        long commerceOrderId = jsonObject.getLong("commerceOrderId");
        CommerceOrder commerceOrder = this._commerceOrderLocalService.fetchCommerceOrder(commerceOrderId);
        if (commerceOrder == null) {
            return;
        }
        int orderStatus = jsonObject.getInt("orderStatus");
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            if (8 != orderStatus) continue;
            User currentUser = this._userService.getCurrentUser();
            this._commerceInventoryBookedQuantityLocalService.restockCommerceInventoryBookedQuantity(currentUser.getUserId(), commerceOrderItem.getBookedQuantityId(), (Map)HashMapBuilder.put((Object)"orderId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderId())).put((Object)"orderItemId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderItemId())).build());
        }
    }
}

