/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.country;

import com.liferay.commerce.country.CommerceCountryManager;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseTable;
import com.liferay.commerce.product.model.CommerceChannelRelTable;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByInfo;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.CountryTable;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@JSONWebService
@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceCountryManager"}, service={CommerceCountryManager.class})
public class CommerceCountryManagerImpl
implements CommerceCountryManager {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CountryLocalService _countryLocalService;

    public List<Country> getBillingCountries(long companyId, boolean active, boolean billingAllowed) {
        return (List)this._countryLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Table)CountryTable.INSTANCE).from((Table)CountryTable.INSTANCE).where(() -> {
            Predicate predicate = CountryTable.INSTANCE.companyId.eq((Object)companyId);
            predicate = predicate.and((Expression)CountryTable.INSTANCE.active.eq((Object)active));
            return predicate.and((Expression)CountryTable.INSTANCE.billingAllowed.eq((Object)billingAllowed));
        }));
    }

    public List<Country> getBillingCountriesByChannelId(long channelId, int start, int end) {
        return (List)this._countryLocalService.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CountryTable.INSTANCE), channelId, true, false).orderBy((Table)CountryTable.INSTANCE, (OrderByInfo)OrderByComparatorFactoryUtil.create((String)"Country", (Object[])new Object[]{"position", true})).limit(start, end));
    }

    public List<Country> getShippingCountries(long companyId, boolean active, boolean shippingAllowed) {
        return (List)this._countryLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Table)CountryTable.INSTANCE).from((Table)CountryTable.INSTANCE).where(() -> {
            Predicate predicate = CountryTable.INSTANCE.companyId.eq((Object)companyId);
            predicate = predicate.and((Expression)CountryTable.INSTANCE.active.eq((Object)active));
            return predicate.and((Expression)CountryTable.INSTANCE.shippingAllowed.eq((Object)shippingAllowed));
        }));
    }

    public List<Country> getShippingCountriesByChannelId(long channelId, int start, int end) {
        return (List)this._countryLocalService.dslQuery(this._getGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)CountryTable.INSTANCE), channelId, false, true).orderBy((Table)CountryTable.INSTANCE, (OrderByInfo)OrderByComparatorFactoryUtil.create((String)"Country", (Object[])new Object[]{"position", true})).limit(start, end));
    }

    public List<Country> getWarehouseCountries(long companyId, boolean all) {
        return (List)this._countryLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Table)CountryTable.INSTANCE).from((Table)CountryTable.INSTANCE).innerJoinON((Table)CommerceInventoryWarehouseTable.INSTANCE, CountryTable.INSTANCE.a2.eq((Expression)CommerceInventoryWarehouseTable.INSTANCE.countryTwoLettersISOCode)).where(() -> CommerceInventoryWarehouseTable.INSTANCE.companyId.eq((Object)companyId).and(() -> {
            if (!all) {
                return CommerceInventoryWarehouseTable.INSTANCE.active.eq((Object)true);
            }
            return null;
        })).orderBy((Table)CountryTable.INSTANCE, (OrderByInfo)OrderByComparatorFactoryUtil.create((String)"Country", (Object[])new Object[]{"position", true})));
    }

    private GroupByStep _getGroupByStep(FromStep fromStep, long commerceChannelId, boolean billingAllowed, boolean shippingAllowed) {
        JoinStep joinStep = fromStep.from((Table)CountryTable.INSTANCE).leftJoinOn((Table)CommerceChannelRelTable.INSTANCE, CountryTable.INSTANCE.countryId.eq((Expression)CommerceChannelRelTable.INSTANCE.classPK));
        return joinStep.where(() -> {
            Predicate predicate = CountryTable.INSTANCE.active.eq((Object)true);
            Predicate groupFilterPredicate = CountryTable.INSTANCE.groupFilterEnabled.eq((Object)false);
            Predicate channelFilterPredicate = CountryTable.INSTANCE.groupFilterEnabled.eq((Object)true);
            channelFilterPredicate = channelFilterPredicate.and((Expression)CommerceChannelRelTable.INSTANCE.classNameId.eq((Object)this._classNameLocalService.getClassNameId(Country.class)));
            channelFilterPredicate = channelFilterPredicate.and((Expression)CommerceChannelRelTable.INSTANCE.commerceChannelId.eq((Object)commerceChannelId));
            groupFilterPredicate = groupFilterPredicate.or((Expression)channelFilterPredicate);
            predicate = predicate.and((Expression)groupFilterPredicate);
            predicate = predicate.and((Expression)CountryTable.INSTANCE.billingAllowed.eq((Object)billingAllowed));
            predicate = predicate.and((Expression)CountryTable.INSTANCE.shippingAllowed.eq((Object)shippingAllowed));
            return predicate;
        });
    }
}

