/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.starter;

import com.liferay.commerce.starter.CommerceRegionsStarter;
import com.liferay.portal.kernel.language.Language;

import java.util.Locale;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Riccardo Alberti
 */
@Component(
	property = "commerce.region.starter.key=" + ArgentinaCommerceRegionsStarter.ARGENTINA_NUMERIC_ISO_CODE,
	service = CommerceRegionsStarter.class
)
public class ArgentinaCommerceRegionsStarter
	extends BaseCommerceRegionsStarter {

	public static final int ARGENTINA_NUMERIC_ISO_CODE = 32;

	@Override
	public String getLabel(Locale locale) {
		return _language.get(locale, "country.argentina");
	}

	@Override
	protected int getCountryIsoCode() {
		return ARGENTINA_NUMERIC_ISO_CODE;
	}

	@Override
	protected String getFilePath() {
		return _FILEPATH;
	}

	private static final String _FILEPATH =
		"com/liferay/commerce/internal/argentina.json";

	@Reference
	private Language _language;

}