/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v7_0_0;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalServiceUtil;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.model.impl.CommerceAddressImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.ListTypeConstants;
import com.liferay.portal.kernel.service.AddressLocalServiceUtil;
import com.liferay.portal.kernel.service.ListTypeLocalServiceUtil;
import com.liferay.portal.kernel.service.PhoneLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Objects;

public class CommerceAddressUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CommerceAddressUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        try (Statement selectStatement = this.connection.createStatement();){
            ResultSet resultSet = selectStatement.executeQuery("select * from CommerceAddress order by commerceAddressId");
            while (resultSet.next()) {
                Address address = AddressLocalServiceUtil.createAddress((long)resultSet.getLong("commerceAddressId"));
                address.setExternalReferenceCode(resultSet.getString("externalReferenceCode"));
                address.setCompanyId(resultSet.getLong("companyId"));
                address.setUserId(resultSet.getLong("userId"));
                address.setUserName(resultSet.getString("userName"));
                address.setCreateDate((Date)resultSet.getTime("createDate"));
                address.setModifiedDate((Date)resultSet.getTime("modifiedDate"));
                address.setClassNameId(resultSet.getLong("classNameId"));
                address.setClassPK(resultSet.getLong("classPK"));
                address.setCountryId(resultSet.getLong("countryId"));
                address.setRegionId(resultSet.getLong("regionId"));
                address.setTypeId(CommerceAddressImpl.toAddressTypeId(resultSet.getInt("type_")));
                address.setCity(resultSet.getString("city"));
                address.setDescription(resultSet.getString("description"));
                address.setLatitude(resultSet.getDouble("latitude"));
                address.setLongitude(resultSet.getDouble("longitude"));
                address.setName(resultSet.getString("name"));
                address.setStreet1(resultSet.getString("street1"));
                address.setStreet2(resultSet.getString("street2"));
                address.setStreet3(resultSet.getString("street3"));
                address.setZip(resultSet.getString("zip"));
                address = AddressLocalServiceUtil.addAddress((Address)address);
                this._setPhoneNumber(address, resultSet.getString("phoneNumber"));
                this._setDefaultBilling(address, resultSet.getBoolean("defaultBilling"));
                this._setDefaultShipping(address, resultSet.getBoolean("defaultShipping"));
            }
            this.runSQL("drop table CommerceAddress");
        }
    }

    private void _setDefaultBilling(Address address, boolean defaultBilling) {
        String className = address.getClassName();
        if (defaultBilling && (Objects.equals(AccountEntry.class.getName(), className) || Objects.equals(CommerceAccount.class.getName(), className))) {
            try {
                AccountEntryLocalServiceUtil.updateDefaultBillingAddressId((long)address.getClassPK(), (long)address.getAddressId());
            }
            catch (PortalException portalException) {
                _log.error((Object)portalException, (Throwable)portalException);
            }
        }
    }

    private void _setDefaultShipping(Address address, boolean defaultShipping) {
        String className = address.getClassName();
        if (defaultShipping && (Objects.equals(AccountEntry.class.getName(), className) || Objects.equals(CommerceAccount.class.getName(), className))) {
            try {
                AccountEntryLocalServiceUtil.updateDefaultShippingAddressId((long)address.getClassPK(), (long)address.getAddressId());
            }
            catch (PortalException portalException) {
                _log.error((Object)portalException, (Throwable)portalException);
            }
        }
    }

    private void _setPhoneNumber(Address address, String phoneNumber) {
        if (phoneNumber == null) {
            return;
        }
        ListType listType = ListTypeLocalServiceUtil.getListType((String)"phone-number", (String)ListTypeConstants.ADDRESS_PHONE);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        try {
            PhoneLocalServiceUtil.addPhone((long)serviceContext.getUserId(), (String)Address.class.getName(), (long)address.getAddressId(), (String)phoneNumber, null, (long)listType.getListTypeId(), (boolean)false, (ServiceContext)serviceContext);
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }
}

