/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel;
import com.liferay.commerce.service.base.CommerceShippingOptionAccountEntryRelServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.ActionKeys;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Alessio Antonio Rendina
 */
@Component(
	property = {
		"json.web.service.context.name=commerce",
		"json.web.service.context.path=CommerceShippingOptionAccountEntryRel"
	},
	service = AopService.class
)
public class CommerceShippingOptionAccountEntryRelServiceImpl
	extends CommerceShippingOptionAccountEntryRelServiceBaseImpl {

	@Override
	public CommerceShippingOptionAccountEntryRel
			addCommerceShippingOptionAccountEntryRel(
				long accountEntryId, long commerceChannelId,
				String commerceShippingMethodKey,
				String commerceShippingOptionKey)
		throws PortalException {

		_checkAccountEntry(accountEntryId, ActionKeys.UPDATE);

		return commerceShippingOptionAccountEntryRelLocalService.
			addCommerceShippingOptionAccountEntryRel(
				getUserId(), accountEntryId, commerceChannelId,
				commerceShippingMethodKey, commerceShippingOptionKey);
	}

	@Override
	public void deleteCommerceShippingOptionAccountEntryRel(
			long commerceShippingOptionAccountEntryRelId)
		throws PortalException {

		CommerceShippingOptionAccountEntryRel
			commerceShippingOptionAccountEntryRel =
				commerceShippingOptionAccountEntryRelLocalService.
					getCommerceShippingOptionAccountEntryRel(
						commerceShippingOptionAccountEntryRelId);

		_checkAccountEntry(
			commerceShippingOptionAccountEntryRel.getAccountEntryId(),
			ActionKeys.UPDATE);

		commerceShippingOptionAccountEntryRelLocalService.
			deleteCommerceShippingOptionAccountEntryRel(
				commerceShippingOptionAccountEntryRel);
	}

	@Override
	public CommerceShippingOptionAccountEntryRel
			fetchCommerceShippingOptionAccountEntryRel(
				long accountEntryId, long commerceChannelId)
		throws PortalException {

		_checkAccountEntry(accountEntryId, ActionKeys.VIEW);

		return commerceShippingOptionAccountEntryRelLocalService.
			fetchCommerceShippingOptionAccountEntryRel(
				accountEntryId, commerceChannelId);
	}

	@Override
	public CommerceShippingOptionAccountEntryRel
			updateCommerceShippingOptionAccountEntryRel(
				long commerceShippingOptionAccountEntryRelId,
				String commerceShippingMethodKey,
				String commerceShippingOptionKey)
		throws PortalException {

		CommerceShippingOptionAccountEntryRel
			commerceShippingOptionAccountEntryRel =
				commerceShippingOptionAccountEntryRelLocalService.
					getCommerceShippingOptionAccountEntryRel(
						commerceShippingOptionAccountEntryRelId);

		_checkAccountEntry(
			commerceShippingOptionAccountEntryRel.getAccountEntryId(),
			ActionKeys.UPDATE);

		return commerceShippingOptionAccountEntryRelLocalService.
			updateCommerceShippingOptionAccountEntryRel(
				commerceShippingOptionAccountEntryRelId,
				commerceShippingMethodKey, commerceShippingOptionKey);
	}

	private void _checkAccountEntry(long accountEntryId, String actionId)
		throws PortalException {

		_accountEntryModelResourcePermission.check(
			getPermissionChecker(), accountEntryId, actionId);
	}

	@Reference(
		target = "(model.class.name=com.liferay.account.model.AccountEntry)"
	)
	private ModelResourcePermission<AccountEntry>
		_accountEntryModelResourcePermission;

}