/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.percentage;

import com.liferay.commerce.percentage.PercentageFormatter;

import java.math.BigDecimal;

import java.text.DecimalFormat;
import java.text.NumberFormat;

import java.util.Locale;

import org.osgi.service.component.annotations.Component;

/**
 * @author Alec Sloan
 */
@Component(immediate = true, service = PercentageFormatter.class)
public class PercentageFormatterImpl implements PercentageFormatter {

	@Override
	public String getLocalizedPercentage(
		Locale locale, int maxFractionDigits, int minFractionDigits,
		BigDecimal percentage) {

		if (percentage.compareTo(BigDecimal.ONE) > 0) {
			percentage = percentage.multiply(new BigDecimal(.01));
		}

		NumberFormat decimalFormat = DecimalFormat.getPercentInstance(locale);

		decimalFormat.setMaximumFractionDigits(maxFractionDigits);
		decimalFormat.setMinimumFractionDigits(minFractionDigits);

		return decimalFormat.format(percentage);
	}

}