/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.order.importer.type;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.importer.type.CommerceOrderImporterType;
import com.liferay.commerce.order.importer.type.CommerceOrderImporterTypeRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory.ServiceWrapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Alessio Antonio Rendina
 */
@Component(immediate = true, service = CommerceOrderImporterTypeRegistry.class)
public class CommerceOrderImporterTypeRegistryImpl
	implements CommerceOrderImporterTypeRegistry {

	@Override
	public CommerceOrderImporterType getCommerceOrderImporterType(String key) {
		ServiceWrapper<CommerceOrderImporterType>
			commerceOrderImporterTypeServiceWrapper =
				_serviceTrackerMap.getService(key);

		if (commerceOrderImporterTypeServiceWrapper == null) {
			if (_log.isDebugEnabled()) {
				_log.debug(
					"No commerce order importer type registered with key " +
						key);
			}

			return null;
		}

		return commerceOrderImporterTypeServiceWrapper.getService();
	}

	@Override
	public List<CommerceOrderImporterType> getCommerceOrderImporterTypes(
			CommerceOrder commerceOrder)
		throws PortalException {

		List<CommerceOrderImporterType> commerceOrderImporterTypes =
			new ArrayList<>();

		List<ServiceWrapper<CommerceOrderImporterType>>
			commerceOrderImporterTypeServiceWrappers = ListUtil.fromCollection(
				_serviceTrackerMap.values());

		for (ServiceWrapper<CommerceOrderImporterType>
				commerceOrderImporterTypeServiceWrapper :
					commerceOrderImporterTypeServiceWrappers) {

			CommerceOrderImporterType commerceOrderImporterType =
				commerceOrderImporterTypeServiceWrapper.getService();

			if (commerceOrderImporterType.isActive(commerceOrder)) {
				commerceOrderImporterTypes.add(commerceOrderImporterType);
			}
		}

		return Collections.unmodifiableList(commerceOrderImporterTypes);
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(
			bundleContext, CommerceOrderImporterType.class,
			"commerce.order.importer.type.key",
			ServiceTrackerCustomizerFactory.
				<CommerceOrderImporterType>serviceWrapper(bundleContext));
	}

	@Deactivate
	protected void deactivate() {
		_serviceTrackerMap.close();
	}

	private static final Log _log = LogFactoryUtil.getLog(
		CommerceOrderImporterTypeRegistryImpl.class);

	private ServiceTrackerMap<String, ServiceWrapper<CommerceOrderImporterType>>
		_serviceTrackerMap;

}