/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel;
import com.liferay.commerce.model.CommerceShippingOptionAccountEntryRelModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceShippingOptionAccountEntryRel service. Represents a row in the &quot;CSOptionAccountEntryRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceShippingOptionAccountEntryRelModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceShippingOptionAccountEntryRelImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceShippingOptionAccountEntryRelImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceShippingOptionAccountEntryRelModelImpl
	extends BaseModelImpl<CommerceShippingOptionAccountEntryRel>
	implements CommerceShippingOptionAccountEntryRelModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce shipping option account entry rel model instance should use the <code>CommerceShippingOptionAccountEntryRel</code> interface instead.
	 */
	public static final String TABLE_NAME = "CSOptionAccountEntryRel";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT},
		{"CSOptionAccountEntryRelId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"accountEntryId", Types.BIGINT},
		{"commerceChannelId", Types.BIGINT},
		{"commerceShippingMethodKey", Types.VARCHAR},
		{"commerceShippingOptionKey", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CSOptionAccountEntryRelId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("accountEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceChannelId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceShippingMethodKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceShippingOptionKey", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CSOptionAccountEntryRel (mvccVersion LONG default 0 not null,CSOptionAccountEntryRelId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,accountEntryId LONG,commerceChannelId LONG,commerceShippingMethodKey VARCHAR(75) null,commerceShippingOptionKey VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP =
		"drop table CSOptionAccountEntryRel";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceShippingOptionAccountEntryRel.CommerceShippingOptionAccountEntryRelId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CSOptionAccountEntryRel.CSOptionAccountEntryRelId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACCOUNTENTRYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCECHANNELID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCESHIPPINGOPTIONKEY_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long
		COMMERCESHIPPINGOPTIONACCOUNTENTRYRELID_COLUMN_BITMASK = 8L;

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.model.CommerceShippingOptionAccountEntryRel"));

	public CommerceShippingOptionAccountEntryRelModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _CommerceShippingOptionAccountEntryRelId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceShippingOptionAccountEntryRelId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _CommerceShippingOptionAccountEntryRelId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceShippingOptionAccountEntryRel.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceShippingOptionAccountEntryRel.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceShippingOptionAccountEntryRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry
				<String,
				 Function<CommerceShippingOptionAccountEntryRel, Object>>
					entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceShippingOptionAccountEntryRel, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(CommerceShippingOptionAccountEntryRel)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceShippingOptionAccountEntryRel, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceShippingOptionAccountEntryRel, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceShippingOptionAccountEntryRel)this,
					entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceShippingOptionAccountEntryRel, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map
		<String, BiConsumer<CommerceShippingOptionAccountEntryRel, Object>>
			getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map
		<String, Function<CommerceShippingOptionAccountEntryRel, Object>>
			_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<CommerceShippingOptionAccountEntryRel, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceShippingOptionAccountEntryRel, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String,
					 Function<CommerceShippingOptionAccountEntryRel, Object>>();
		Map<String, BiConsumer<CommerceShippingOptionAccountEntryRel, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String,
					 BiConsumer<CommerceShippingOptionAccountEntryRel, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion",
			CommerceShippingOptionAccountEntryRel::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<CommerceShippingOptionAccountEntryRel, Long>)
				CommerceShippingOptionAccountEntryRel::setMvccVersion);
		attributeGetterFunctions.put(
			"CommerceShippingOptionAccountEntryRelId",
			CommerceShippingOptionAccountEntryRel::
				getCommerceShippingOptionAccountEntryRelId);
		attributeSetterBiConsumers.put(
			"CommerceShippingOptionAccountEntryRelId",
			(BiConsumer<CommerceShippingOptionAccountEntryRel, Long>)
				CommerceShippingOptionAccountEntryRel::
					setCommerceShippingOptionAccountEntryRelId);
		attributeGetterFunctions.put(
			"companyId", CommerceShippingOptionAccountEntryRel::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceShippingOptionAccountEntryRel, Long>)
				CommerceShippingOptionAccountEntryRel::setCompanyId);
		attributeGetterFunctions.put(
			"userId", CommerceShippingOptionAccountEntryRel::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceShippingOptionAccountEntryRel, Long>)
				CommerceShippingOptionAccountEntryRel::setUserId);
		attributeGetterFunctions.put(
			"userName", CommerceShippingOptionAccountEntryRel::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceShippingOptionAccountEntryRel, String>)
				CommerceShippingOptionAccountEntryRel::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceShippingOptionAccountEntryRel::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceShippingOptionAccountEntryRel, Date>)
				CommerceShippingOptionAccountEntryRel::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate",
			CommerceShippingOptionAccountEntryRel::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceShippingOptionAccountEntryRel, Date>)
				CommerceShippingOptionAccountEntryRel::setModifiedDate);
		attributeGetterFunctions.put(
			"accountEntryId",
			CommerceShippingOptionAccountEntryRel::getAccountEntryId);
		attributeSetterBiConsumers.put(
			"accountEntryId",
			(BiConsumer<CommerceShippingOptionAccountEntryRel, Long>)
				CommerceShippingOptionAccountEntryRel::setAccountEntryId);
		attributeGetterFunctions.put(
			"commerceChannelId",
			CommerceShippingOptionAccountEntryRel::getCommerceChannelId);
		attributeSetterBiConsumers.put(
			"commerceChannelId",
			(BiConsumer<CommerceShippingOptionAccountEntryRel, Long>)
				CommerceShippingOptionAccountEntryRel::setCommerceChannelId);
		attributeGetterFunctions.put(
			"commerceShippingMethodKey",
			CommerceShippingOptionAccountEntryRel::
				getCommerceShippingMethodKey);
		attributeSetterBiConsumers.put(
			"commerceShippingMethodKey",
			(BiConsumer<CommerceShippingOptionAccountEntryRel, String>)
				CommerceShippingOptionAccountEntryRel::
					setCommerceShippingMethodKey);
		attributeGetterFunctions.put(
			"commerceShippingOptionKey",
			CommerceShippingOptionAccountEntryRel::
				getCommerceShippingOptionKey);
		attributeSetterBiConsumers.put(
			"commerceShippingOptionKey",
			(BiConsumer<CommerceShippingOptionAccountEntryRel, String>)
				CommerceShippingOptionAccountEntryRel::
					setCommerceShippingOptionKey);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCommerceShippingOptionAccountEntryRelId() {
		return _CommerceShippingOptionAccountEntryRelId;
	}

	@Override
	public void setCommerceShippingOptionAccountEntryRelId(
		long CommerceShippingOptionAccountEntryRelId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CommerceShippingOptionAccountEntryRelId =
			CommerceShippingOptionAccountEntryRelId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getAccountEntryId() {
		return _accountEntryId;
	}

	@Override
	public void setAccountEntryId(long accountEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_accountEntryId = accountEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalAccountEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("accountEntryId"));
	}

	@JSON
	@Override
	public long getCommerceChannelId() {
		return _commerceChannelId;
	}

	@Override
	public void setCommerceChannelId(long commerceChannelId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceChannelId = commerceChannelId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceChannelId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceChannelId"));
	}

	@JSON
	@Override
	public String getCommerceShippingMethodKey() {
		if (_commerceShippingMethodKey == null) {
			return "";
		}
		else {
			return _commerceShippingMethodKey;
		}
	}

	@Override
	public void setCommerceShippingMethodKey(String commerceShippingMethodKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceShippingMethodKey = commerceShippingMethodKey;
	}

	@JSON
	@Override
	public String getCommerceShippingOptionKey() {
		if (_commerceShippingOptionKey == null) {
			return "";
		}
		else {
			return _commerceShippingOptionKey;
		}
	}

	@Override
	public void setCommerceShippingOptionKey(String commerceShippingOptionKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceShippingOptionKey = commerceShippingOptionKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalCommerceShippingOptionKey() {
		return getColumnOriginalValue("commerceShippingOptionKey");
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(),
			CommerceShippingOptionAccountEntryRel.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceShippingOptionAccountEntryRel toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceShippingOptionAccountEntryRel>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceShippingOptionAccountEntryRelImpl
			commerceShippingOptionAccountEntryRelImpl =
				new CommerceShippingOptionAccountEntryRelImpl();

		commerceShippingOptionAccountEntryRelImpl.setMvccVersion(
			getMvccVersion());
		commerceShippingOptionAccountEntryRelImpl.
			setCommerceShippingOptionAccountEntryRelId(
				getCommerceShippingOptionAccountEntryRelId());
		commerceShippingOptionAccountEntryRelImpl.setCompanyId(getCompanyId());
		commerceShippingOptionAccountEntryRelImpl.setUserId(getUserId());
		commerceShippingOptionAccountEntryRelImpl.setUserName(getUserName());
		commerceShippingOptionAccountEntryRelImpl.setCreateDate(
			getCreateDate());
		commerceShippingOptionAccountEntryRelImpl.setModifiedDate(
			getModifiedDate());
		commerceShippingOptionAccountEntryRelImpl.setAccountEntryId(
			getAccountEntryId());
		commerceShippingOptionAccountEntryRelImpl.setCommerceChannelId(
			getCommerceChannelId());
		commerceShippingOptionAccountEntryRelImpl.setCommerceShippingMethodKey(
			getCommerceShippingMethodKey());
		commerceShippingOptionAccountEntryRelImpl.setCommerceShippingOptionKey(
			getCommerceShippingOptionKey());

		commerceShippingOptionAccountEntryRelImpl.resetOriginalValues();

		return commerceShippingOptionAccountEntryRelImpl;
	}

	@Override
	public CommerceShippingOptionAccountEntryRel cloneWithOriginalValues() {
		CommerceShippingOptionAccountEntryRelImpl
			commerceShippingOptionAccountEntryRelImpl =
				new CommerceShippingOptionAccountEntryRelImpl();

		commerceShippingOptionAccountEntryRelImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commerceShippingOptionAccountEntryRelImpl.
			setCommerceShippingOptionAccountEntryRelId(
				this.<Long>getColumnOriginalValue("CSOptionAccountEntryRelId"));
		commerceShippingOptionAccountEntryRelImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commerceShippingOptionAccountEntryRelImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commerceShippingOptionAccountEntryRelImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commerceShippingOptionAccountEntryRelImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commerceShippingOptionAccountEntryRelImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commerceShippingOptionAccountEntryRelImpl.setAccountEntryId(
			this.<Long>getColumnOriginalValue("accountEntryId"));
		commerceShippingOptionAccountEntryRelImpl.setCommerceChannelId(
			this.<Long>getColumnOriginalValue("commerceChannelId"));
		commerceShippingOptionAccountEntryRelImpl.setCommerceShippingMethodKey(
			this.<String>getColumnOriginalValue("commerceShippingMethodKey"));
		commerceShippingOptionAccountEntryRelImpl.setCommerceShippingOptionKey(
			this.<String>getColumnOriginalValue("commerceShippingOptionKey"));

		return commerceShippingOptionAccountEntryRelImpl;
	}

	@Override
	public int compareTo(
		CommerceShippingOptionAccountEntryRel
			commerceShippingOptionAccountEntryRel) {

		long primaryKey = commerceShippingOptionAccountEntryRel.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceShippingOptionAccountEntryRel)) {
			return false;
		}

		CommerceShippingOptionAccountEntryRel
			commerceShippingOptionAccountEntryRel =
				(CommerceShippingOptionAccountEntryRel)object;

		long primaryKey = commerceShippingOptionAccountEntryRel.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceShippingOptionAccountEntryRel> toCacheModel() {
		CommerceShippingOptionAccountEntryRelCacheModel
			commerceShippingOptionAccountEntryRelCacheModel =
				new CommerceShippingOptionAccountEntryRelCacheModel();

		commerceShippingOptionAccountEntryRelCacheModel.mvccVersion =
			getMvccVersion();

		commerceShippingOptionAccountEntryRelCacheModel.
			CommerceShippingOptionAccountEntryRelId =
				getCommerceShippingOptionAccountEntryRelId();

		commerceShippingOptionAccountEntryRelCacheModel.companyId =
			getCompanyId();

		commerceShippingOptionAccountEntryRelCacheModel.userId = getUserId();

		commerceShippingOptionAccountEntryRelCacheModel.userName =
			getUserName();

		String userName =
			commerceShippingOptionAccountEntryRelCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceShippingOptionAccountEntryRelCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceShippingOptionAccountEntryRelCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceShippingOptionAccountEntryRelCacheModel.createDate =
				Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceShippingOptionAccountEntryRelCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceShippingOptionAccountEntryRelCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		commerceShippingOptionAccountEntryRelCacheModel.accountEntryId =
			getAccountEntryId();

		commerceShippingOptionAccountEntryRelCacheModel.commerceChannelId =
			getCommerceChannelId();

		commerceShippingOptionAccountEntryRelCacheModel.
			commerceShippingMethodKey = getCommerceShippingMethodKey();

		String commerceShippingMethodKey =
			commerceShippingOptionAccountEntryRelCacheModel.
				commerceShippingMethodKey;

		if ((commerceShippingMethodKey != null) &&
			(commerceShippingMethodKey.length() == 0)) {

			commerceShippingOptionAccountEntryRelCacheModel.
				commerceShippingMethodKey = null;
		}

		commerceShippingOptionAccountEntryRelCacheModel.
			commerceShippingOptionKey = getCommerceShippingOptionKey();

		String commerceShippingOptionKey =
			commerceShippingOptionAccountEntryRelCacheModel.
				commerceShippingOptionKey;

		if ((commerceShippingOptionKey != null) &&
			(commerceShippingOptionKey.length() == 0)) {

			commerceShippingOptionAccountEntryRelCacheModel.
				commerceShippingOptionKey = null;
		}

		return commerceShippingOptionAccountEntryRelCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceShippingOptionAccountEntryRel, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry
				<String,
				 Function<CommerceShippingOptionAccountEntryRel, Object>>
					entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceShippingOptionAccountEntryRel, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceShippingOptionAccountEntryRel)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceShippingOptionAccountEntryRel>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						CommerceShippingOptionAccountEntryRel.class,
						ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _CommerceShippingOptionAccountEntryRelId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _accountEntryId;
	private long _commerceChannelId;
	private String _commerceShippingMethodKey;
	private String _commerceShippingOptionKey;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceShippingOptionAccountEntryRel, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceShippingOptionAccountEntryRel)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"CSOptionAccountEntryRelId",
			_CommerceShippingOptionAccountEntryRelId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("accountEntryId", _accountEntryId);
		_columnOriginalValues.put("commerceChannelId", _commerceChannelId);
		_columnOriginalValues.put(
			"commerceShippingMethodKey", _commerceShippingMethodKey);
		_columnOriginalValues.put(
			"commerceShippingOptionKey", _commerceShippingOptionKey);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put(
			"CSOptionAccountEntryRelId",
			"CommerceShippingOptionAccountEntryRelId");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("CSOptionAccountEntryRelId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("accountEntryId", 128L);

		columnBitmasks.put("commerceChannelId", 256L);

		columnBitmasks.put("commerceShippingMethodKey", 512L);

		columnBitmasks.put("commerceShippingOptionKey", 1024L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceShippingOptionAccountEntryRel _escapedModel;

}