/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderPayment;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.base.CommerceOrderPaymentLocalServiceBaseImpl;
import com.liferay.commerce.util.comparator.CommerceOrderPaymentCreateDateComparator;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class CommerceOrderPaymentLocalServiceImpl
extends CommerceOrderPaymentLocalServiceBaseImpl {
    @BeanReference(type=CommerceOrderLocalService.class)
    private CommerceOrderLocalService _commerceOrderLocalService;
    @ServiceReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    public CommerceOrderPayment addCommerceOrderPayment(long commerceOrderId, int status, String result) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        User user = this._userLocalService.getUser(commerceOrder.getUserId());
        return this._getCommerceOrderPayment(status, result, commerceOrder, user);
    }

    public CommerceOrderPayment addCommerceOrderPayment(long commerceOrderId, int status, String content, ServiceContext serviceContext) throws PortalException {
        return this._getCommerceOrderPayment(status, content, this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._userLocalService.getUser(serviceContext.getUserId()));
    }

    public void deleteCommerceOrderPayments(long commerceOrderId) {
        this.commerceOrderPaymentPersistence.removeByCommerceOrderId(commerceOrderId);
    }

    public CommerceOrderPayment fetchLatestCommerceOrderPayment(long commerceOrderId) throws PortalException {
        return this.commerceOrderPaymentPersistence.fetchByCommerceOrderId_First(commerceOrderId, (OrderByComparator)new CommerceOrderPaymentCreateDateComparator());
    }

    public List<CommerceOrderPayment> getCommerceOrderPayments(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderPayment> orderByComparator) {
        return this.commerceOrderPaymentPersistence.findByCommerceOrderId(commerceOrderId, start, end, orderByComparator);
    }

    public int getCommerceOrderPaymentsCount(long commerceOrderId) {
        return this.commerceOrderPaymentPersistence.countByCommerceOrderId(commerceOrderId);
    }

    private CommerceOrderPayment _getCommerceOrderPayment(int status, String result, CommerceOrder commerceOrder, User user) {
        long commerceOrderPaymentId = this.counterLocalService.increment();
        CommerceOrderPayment commerceOrderPayment = this.commerceOrderPaymentPersistence.create(commerceOrderPaymentId);
        commerceOrderPayment.setGroupId(commerceOrder.getGroupId());
        commerceOrderPayment.setCompanyId(user.getCompanyId());
        commerceOrderPayment.setUserId(user.getUserId());
        commerceOrderPayment.setUserName(user.getFullName());
        commerceOrderPayment.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderPayment.setCommercePaymentMethodKey(commerceOrder.getCommercePaymentMethodKey());
        commerceOrderPayment.setContent(result);
        commerceOrderPayment.setStatus(status);
        return (CommerceOrderPayment)this.commerceOrderPaymentPersistence.update((BaseModel)commerceOrderPayment);
    }
}

