/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.exception.CommerceOrderValidatorException;
import com.liferay.commerce.exception.GuestCartItemMaxAllowedException;
import com.liferay.commerce.exception.NoSuchOrderItemException;
import com.liferay.commerce.exception.ProductBundleException;
import com.liferay.commerce.internal.util.CommercePriceConverterUtil;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderItemTable;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.price.CommerceProductPrice;
import com.liferay.commerce.price.CommerceProductPriceCalculation;
import com.liferay.commerce.price.CommerceProductPriceImpl;
import com.liferay.commerce.price.CommerceProductPriceRequest;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPMeasurementUnit;
import com.liferay.commerce.product.option.CommerceOptionValue;
import com.liferay.commerce.product.option.CommerceOptionValueHelper;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPMeasurementUnitLocalService;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.base.CommerceOrderItemLocalServiceBaseImpl;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CommerceOrderItemLocalServiceImpl
extends CommerceOrderItemLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "uid"};
    @ServiceReference(type=CommerceInventoryBookedQuantityLocalService.class)
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @ServiceReference(type=CommerceInventoryWarehouseItemLocalService.class)
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @ServiceReference(type=CommerceMoneyFactory.class)
    private CommerceMoneyFactory _commerceMoneyFactory;
    @ServiceReference(type=CommerceOptionValueHelper.class)
    private CommerceOptionValueHelper _commerceOptionValueHelper;
    @ServiceReference(type=CommerceOrderConfiguration.class)
    private CommerceOrderConfiguration _commerceOrderConfiguration;
    @BeanReference(type=CommerceOrderLocalService.class)
    private CommerceOrderLocalService _commerceOrderLocalService;
    @ServiceReference(type=CommerceOrderValidatorRegistry.class)
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @ServiceReference(type=CommerceProductPriceCalculation.class)
    private CommerceProductPriceCalculation _commerceProductPriceCalculation;
    @ServiceReference(type=CommerceShippingHelper.class)
    private CommerceShippingHelper _commerceShippingHelper;
    @ServiceReference(type=CommerceTaxCalculation.class)
    private CommerceTaxCalculation _commerceTaxCalculation;
    @ServiceReference(type=CPDefinitionLocalService.class)
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @ServiceReference(type=CPDefinitionOptionRelLocalService.class)
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @ServiceReference(type=CPInstanceLocalService.class)
    private CPInstanceLocalService _cpInstanceLocalService;
    @ServiceReference(type=CPMeasurementUnitLocalService.class)
    private CPMeasurementUnitLocalService _cpMeasurementUnitLocalService;
    @ServiceReference(type=ExpandoRowLocalService.class)
    private ExpandoRowLocalService _expandoRowLocalService;
    @ServiceReference(type=JsonHelper.class)
    private JsonHelper _jsonHelper;
    @ServiceReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;
    @ServiceReference(type=WorkflowDefinitionLinkLocalService.class)
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem addCommerceOrderItem(long commerceOrderId, long cpInstanceId, String json, int quantity, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)json)) {
            json = this._getCPInstanceOptionValueRelsJSONString(cpInstanceId);
        }
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        this.updateWorkflow(commerceOrder, serviceContext);
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        CommerceOrderItem commerceOrderItem = this._createCommerceOrderItem(commerceOrder.getGroupId(), user, commerceOrder, cpInstance, 0L, json, quantity, shippedQuantity, commerceContext, serviceContext);
        commerceOrderItem = (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
        List commerceOptionValues = this._commerceOptionValueHelper.getCPDefinitionCommerceOptionValues(cpInstance.getCPDefinitionId(), json);
        for (CommerceOptionValue commerceOptionValue : commerceOptionValues) {
            if (Validator.isNull((String)commerceOptionValue.getPriceType()) || this._isStaticPriceType(commerceOptionValue.getPriceType()) && commerceOptionValue.getCPInstanceId() <= 0L) continue;
            CPInstance commerceOptionValueCPInstance = this._cpInstanceLocalService.getCPInstance(commerceOptionValue.getCPInstanceId());
            int currentQuantity = quantity * commerceOptionValue.getQuantity();
            CommerceOrderItem childCommerceOrderItem = this._createCommerceOrderItem(commerceOrder.getGroupId(), user, commerceOrder, commerceOptionValueCPInstance, commerceOrderItem.getCommerceOrderItemId(), commerceOptionValue.toJSON(), currentQuantity, 0, commerceContext, serviceContext);
            if (!this._isStaticPriceType(commerceOptionValue.getPriceType())) {
                childCommerceOrderItem = (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)childCommerceOrderItem);
                continue;
            }
            CommerceProductPrice commerceProductPrice = this._getStaticCommerceProductPrice(commerceOptionValue.getCPInstanceId(), currentQuantity, commerceOptionValue.getPrice(), childCommerceOrderItem.getCommerceOrder(), commerceContext.getCommerceCurrency());
            this._setCommerceOrderItemPrice(childCommerceOrderItem, commerceProductPrice);
            this._setCommerceOrderItemDiscountValue(childCommerceOrderItem, commerceProductPrice.getDiscountValue(), false);
            this._setCommerceOrderItemDiscountValue(childCommerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
            this.commerceOrderItemPersistence.update((BaseModel)childCommerceOrderItem);
        }
        this._commerceOrderLocalService.recalculatePrice(commerceOrderItem.getCommerceOrderId(), commerceContext);
        return commerceOrderItem;
    }

    public CommerceOrderItem addOrUpdateCommerceOrderItem(long commerceOrderId, long cpInstanceId, int quantity, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        String cpInstanceOptionValueRelJSONString = this._getCPInstanceOptionValueRelsJSONString(cpInstanceId);
        return this.commerceOrderItemLocalService.addOrUpdateCommerceOrderItem(commerceOrderId, cpInstanceId, cpInstanceOptionValueRelJSONString, quantity, 0, commerceContext, serviceContext);
    }

    public CommerceOrderItem addOrUpdateCommerceOrderItem(long commerceOrderId, long cpInstanceId, String json, int quantity, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        List<CommerceOrderItem> commerceOrderItems = this.getCommerceOrderItems(commerceOrderId, cpInstanceId, -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (commerceOrderItem.getParentCommerceOrderItemId() != 0L || !this._jsonMatches(json, commerceOrderItem.getJson())) continue;
            return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), commerceOrderItem.getJson(), commerceOrderItem.getQuantity() + quantity, commerceContext, serviceContext);
        }
        return this.commerceOrderItemLocalService.addCommerceOrderItem(commerceOrderId, cpInstanceId, json, quantity, 0, commerceContext, serviceContext);
    }

    public int countSubscriptionCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemPersistence.countByC_S(commerceOrderId, true);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CommerceOrderItem deleteCommerceOrderItem(CommerceOrderItem commerceOrderItem) throws PortalException {
        this.validateParentCommerceOrderId(commerceOrderItem);
        return this._deleteCommerceOrderItem(commerceOrderItem);
    }

    @Indexable(type=IndexableType.DELETE)
    public CommerceOrderItem deleteCommerceOrderItem(CommerceOrderItem commerceOrderItem, CommerceContext commerceContext) throws PortalException {
        this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem);
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        if (this._commerceShippingHelper.isFreeShipping(commerceOrder)) {
            this._commerceOrderLocalService.updateCommerceShippingMethod(commerceOrder.getCommerceOrderId(), 0L, null, BigDecimal.ZERO, commerceContext);
        }
        this._commerceOrderLocalService.recalculatePrice(commerceOrder.getCommerceOrderId(), commerceContext);
        return commerceOrderItem;
    }

    @Override
    public CommerceOrderItem deleteCommerceOrderItem(long commerceOrderItemId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        return this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem);
    }

    public void deleteCommerceOrderItems(long commerceOrderId) throws PortalException {
        List commerceOrderItems = this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (commerceOrderItem.hasParentCommerceOrderItem()) continue;
            this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItem);
        }
    }

    public void deleteCommerceOrderItemsByCPInstanceId(long cpInstanceId) throws PortalException {
        List commerceOrderItems = this.commerceOrderItemPersistence.findByCPInstanceId(cpInstanceId);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this.deleteCommerceOrderItem(commerceOrderItem);
        }
    }

    public void deleteMissingCommerceOrderItems(long commerceOrderId, Long[] commerceOrderItemIds, String[] externalReferenceCodes) throws PortalException {
        List commerceOrderItemIdsList = (List)this.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{CommerceOrderItemTable.INSTANCE.commerceOrderItemId}).from((Table)CommerceOrderItemTable.INSTANCE).where(CommerceOrderItemTable.INSTANCE.commerceOrderId.eq((Object)commerceOrderId).and((Expression)CommerceOrderItemTable.INSTANCE.commerceOrderItemId.notIn((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{CommerceOrderItemTable.INSTANCE.commerceOrderItemId}).from((Table)CommerceOrderItemTable.INSTANCE).where(this._getPredicate(commerceOrderId, commerceOrderItemIds, externalReferenceCodes))))));
        Iterator iterator = commerceOrderItemIdsList.iterator();
        while (iterator.hasNext()) {
            long commerceOrderItemId = (Long)iterator.next();
            this.commerceOrderItemLocalService.deleteCommerceOrderItem(commerceOrderItemId);
        }
    }

    public CommerceOrderItem fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceOrderItemPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CommerceOrderItem fetchCommerceOrderItemByBookedQuantityId(long bookedQuantityId) {
        return this.commerceOrderItemPersistence.fetchByBookedQuantityId(bookedQuantityId);
    }

    public List<CommerceOrderItem> getAvailableForShipmentCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemFinder.findByAvailableQuantity(commerceOrderId);
    }

    public List<CommerceOrderItem> getChildCommerceOrderItems(long parentCommerceOrderItemId) {
        return this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(parentCommerceOrderItemId);
    }

    public int getCommerceInventoryWarehouseItemQuantity(long commerceOrderItemId, long commerceInventoryWarehouseId) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, commerceOrderItem.getSku());
        if (commerceInventoryWarehouseItem == null) {
            return 0;
        }
        return commerceInventoryWarehouseItem.getQuantity();
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end) {
        return this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.commerceOrderItemPersistence.findByCommerceOrderId(commerceOrderId, start, end, orderByComparator);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, long cpInstanceId, int start, int end) {
        return this.commerceOrderItemPersistence.findByC_CPI(commerceOrderId, cpInstanceId, start, end);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long commerceOrderId, long cpInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.commerceOrderItemPersistence.findByC_CPI(commerceOrderId, cpInstanceId, start, end, orderByComparator);
    }

    public List<CommerceOrderItem> getCommerceOrderItems(long groupId, long commerceAccountId, int[] orderStatuses, int start, int end) {
        return this.commerceOrderItemFinder.findByG_A_O(groupId, commerceAccountId, orderStatuses, start, end);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId) {
        return this.commerceOrderItemPersistence.countByCommerceOrderId(commerceOrderId);
    }

    public int getCommerceOrderItemsCount(long commerceOrderId, long cpInstanceId) {
        return this.commerceOrderItemPersistence.countByC_CPI(commerceOrderId, cpInstanceId);
    }

    public int getCommerceOrderItemsCount(long groupId, long commerceAccountId, int[] orderStatuses) {
        return this.commerceOrderItemFinder.countByG_A_O(groupId, commerceAccountId, orderStatuses);
    }

    public int getCommerceOrderItemsQuantity(long commerceOrderId) {
        return this.commerceOrderItemFinder.getCommerceOrderItemsQuantity(commerceOrderId);
    }

    public List<CommerceOrderItem> getSubscriptionCommerceOrderItems(long commerceOrderId) {
        return this.commerceOrderItemPersistence.findByC_S(commerceOrderId, true);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem importCommerceOrderItem(String externalReferenceCode, long commerceOrderItemId, long commerceOrderId, long cpInstanceId, String cpMeasurementUnitKey, BigDecimal decimalQuantity, int quantity, int shippedQuantity, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(cpInstanceId);
        this.updateWorkflow(commerceOrder, serviceContext);
        User user = this._userLocalService.getUser(serviceContext.getUserId());
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.fetchByPrimaryKey(commerceOrderItemId);
        if (commerceOrderItem == null && !Validator.isBlank((String)externalReferenceCode)) {
            commerceOrderItem = this.commerceOrderItemPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode);
        }
        commerceOrderItem = commerceOrderItem == null ? this._createCommerceOrderItem(commerceOrder.getGroupId(), user, commerceOrder, cpInstance, 0L, null, quantity, shippedQuantity, null, serviceContext) : this._updateCommerceOrderItem(commerceOrderItem, externalReferenceCode, user, commerceOrder, cpInstance, quantity, shippedQuantity, serviceContext);
        if (!Validator.isBlank((String)cpMeasurementUnitKey)) {
            CPMeasurementUnit cpMeasurementUnit = this._cpMeasurementUnitLocalService.getCPMeasurementUnitByKey(user.getCompanyId(), cpMeasurementUnitKey);
            commerceOrderItem.setCPMeasurementUnitId(cpMeasurementUnit.getCPMeasurementUnitId());
        }
        commerceOrderItem.setDecimalQuantity(decimalQuantity);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public CommerceOrderItem incrementShippedQuantity(long commerceOrderItemId, int shippedQuantity) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        shippedQuantity = commerceOrderItem.getShippedQuantity() + shippedQuantity;
        if (shippedQuantity < 0) {
            shippedQuantity = 0;
        }
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, long parentCommerceOrderItemId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(commerceOrderId, parentCommerceOrderItemId, start, end, sort);
        searchContext.setKeywords(keywords);
        return this.searchCommerceOrderItems(searchContext);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(commerceOrderId, null, start, end, sort);
        searchContext.setKeywords(keywords);
        return this.searchCommerceOrderItems(searchContext);
    }

    public BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(long commerceOrderId, String name, String sku, boolean andOperator, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(commerceOrderId, null, start, end, sort);
        searchContext.setAndSearch(andOperator);
        searchContext.setAttribute("sku", (Serializable)((Object)sku));
        searchContext.setAttribute("name", (Serializable)((Object)name));
        return this.searchCommerceOrderItems(searchContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItemId, commerceOrderItem.getJson(), quantity, commerceContext, serviceContext);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, long bookedQuantityId) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setBookedQuantityId(bookedQuantityId);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, long cpMeasurementUnitId, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem = this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItemId, commerceOrderItem.getJson(), quantity, commerceContext, serviceContext);
        commerceOrderItem.setCPMeasurementUnitId(cpMeasurementUnitId);
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem);
    }

    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, long cpMeasurementUnitId, int quantity, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem = this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItemId, commerceOrderItem.getJson(), quantity, serviceContext);
        commerceOrderItem.setCPMeasurementUnitId(cpMeasurementUnitId);
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, String json, int quantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this.validateParentCommerceOrderId(commerceOrderItem);
        List childCommerceOrderItems = this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(commerceOrderItemId);
        if (childCommerceOrderItems.isEmpty()) {
            return this._updateCommerceOrderItem(commerceOrderItemId, quantity, json, null, commerceContext, serviceContext);
        }
        List commerceOptionValues = this._commerceOptionValueHelper.toCommerceOptionValues(json);
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            CommerceOptionValue commerceOptionValue = this._commerceOptionValueHelper.toCommerceOptionValue(childCommerceOrderItem.getJson());
            CommerceOptionValue matchedCommerceOptionValue = commerceOptionValue.getFirstMatch(commerceOptionValues);
            if (matchedCommerceOptionValue == null) {
                throw new NoSuchOrderItemException("Child commerce order item does not match any JSON item");
            }
            int currentQuantity = quantity * commerceOptionValue.getQuantity();
            if (!this._isStaticPriceType(commerceOptionValue.getPriceType())) {
                this._updateCommerceOrderItem(childCommerceOrderItem.getCommerceOrderItemId(), currentQuantity, childCommerceOrderItem.getJson(), null, commerceContext, serviceContext);
                continue;
            }
            CommerceProductPrice staticCommerceProductPrice = this._getStaticCommerceProductPrice(commerceOptionValue.getCPInstanceId(), currentQuantity, commerceOptionValue.getPrice(), childCommerceOrderItem.getCommerceOrder(), commerceContext.getCommerceCurrency());
            this._updateCommerceOrderItem(childCommerceOrderItem.getCommerceOrderItemId(), currentQuantity, childCommerceOrderItem.getJson(), staticCommerceProductPrice, commerceContext, serviceContext);
        }
        return this._updateCommerceOrderItem(commerceOrderItemId, quantity, json, null, commerceContext, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItem(long commerceOrderItemId, String json, int quantity, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this.validateParentCommerceOrderId(commerceOrderItem);
        List childCommerceOrderItems = this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(commerceOrderItemId);
        if (childCommerceOrderItems.isEmpty()) {
            return this._updateCommerceOrderItem(commerceOrderItemId, quantity, json, serviceContext);
        }
        List commerceOptionValues = this._commerceOptionValueHelper.toCommerceOptionValues(json);
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            CommerceOptionValue commerceOptionValue = this._commerceOptionValueHelper.toCommerceOptionValue(childCommerceOrderItem.getJson());
            CommerceOptionValue matchedCommerceOptionValue = commerceOptionValue.getFirstMatch(commerceOptionValues);
            if (matchedCommerceOptionValue == null) {
                throw new NoSuchOrderItemException("Child commerce order item does not match any JSON item");
            }
            int currentQuantity = quantity * commerceOptionValue.getQuantity();
            this._updateCommerceOrderItem(childCommerceOrderItem.getCommerceOrderItemId(), currentQuantity, childCommerceOrderItem.getJson(), serviceContext);
        }
        return this._updateCommerceOrderItem(commerceOrderItemId, quantity, json, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemDeliveryDate(long commerceOrderItemId, Date requestedDeliveryDate) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setRequestedDeliveryDate(requestedDeliveryDate);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, long shippingAddressId, String deliveryGroup, String printedNote) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setShippingAddressId(shippingAddressId);
        commerceOrderItem.setDeliveryGroup(deliveryGroup);
        commerceOrderItem.setPrintedNote(printedNote);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, long shippingAddressId, String deliveryGroup, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear) throws PortalException {
        Date requestedDeliveryDate = PortalUtil.getDate((int)requestedDeliveryDateMonth, (int)requestedDeliveryDateDay, (int)requestedDeliveryDateYear);
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setShippingAddressId(shippingAddressId);
        commerceOrderItem.setDeliveryGroup(deliveryGroup);
        commerceOrderItem.setPrintedNote(printedNote);
        commerceOrderItem.setRequestedDeliveryDate(requestedDeliveryDate);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemInfo(long commerceOrderItemId, String deliveryGroup, long shippingAddressId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        return this.commerceOrderItemLocalService.updateCommerceOrderItemInfo(commerceOrderItemId, shippingAddressId, deliveryGroup, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrice(long commerceOrderItemId, CommerceContext commerceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        if (commerceOrderItem.isManuallyAdjusted() || commerceOrderItem.getParentCommerceOrderItemId() != 0L) {
            return commerceOrderItem;
        }
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (cpInstance == null) {
            return commerceOrderItem;
        }
        List childCommerceOrderItems = this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(commerceOrderItemId);
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            CommerceOptionValue commerceOptionValue = this._commerceOptionValueHelper.toCommerceOptionValue(childCommerceOrderItem.getJson());
            if (!this._isStaticPriceType(commerceOptionValue.getPriceType())) {
                this._setCommerceOrderItemPrice(childCommerceOrderItem, null, commerceContext);
            } else {
                this._setCommerceOrderItemPrice(childCommerceOrderItem, this._getStaticCommerceProductPrice(commerceOptionValue.getCPInstanceId(), childCommerceOrderItem.getQuantity(), commerceOptionValue.getPrice(), childCommerceOrderItem.getCommerceOrder(), commerceContext.getCommerceCurrency()), commerceContext);
            }
            this.commerceOrderItemPersistence.update((BaseModel)childCommerceOrderItem);
        }
        commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this._setCommerceOrderItemPrice(commerceOrderItem, null, commerceContext);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal discountAmount, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel4, BigDecimal finalPrice, BigDecimal promoPrice, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        this.validateParentCommerceOrderId(commerceOrderItem);
        boolean discountChanged = this._isDiscountChanged(discountAmount, commerceOrderItem);
        boolean priceChanged = this._isPriceChanged(finalPrice, promoPrice, unitPrice, commerceOrderItem);
        commerceOrderItem.setDiscountAmount((BigDecimal)GetterUtil.get((Object)discountAmount, (Number)BigDecimal.ZERO));
        if (!commerceOrderItem.isDiscountManuallyAdjusted() && discountChanged) {
            commerceOrderItem.setDiscountManuallyAdjusted(true);
        }
        commerceOrderItem.setDiscountPercentageLevel1((BigDecimal)GetterUtil.get((Object)discountPercentageLevel1, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel2((BigDecimal)GetterUtil.get((Object)discountPercentageLevel2, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel3((BigDecimal)GetterUtil.get((Object)discountPercentageLevel3, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel4((BigDecimal)GetterUtil.get((Object)discountPercentageLevel4, (Number)BigDecimal.ZERO));
        commerceOrderItem.setFinalPrice((BigDecimal)GetterUtil.get((Object)finalPrice, (Number)BigDecimal.ZERO));
        commerceOrderItem.setManuallyAdjusted(true);
        if (!commerceOrderItem.isPriceManuallyAdjusted() && priceChanged) {
            commerceOrderItem.setPriceManuallyAdjusted(true);
        }
        commerceOrderItem.setPromoPrice((BigDecimal)GetterUtil.get((Object)promoPrice, (Number)BigDecimal.ZERO));
        commerceOrderItem.setUnitPrice((BigDecimal)GetterUtil.get((Object)unitPrice, (Number)BigDecimal.ZERO));
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCommerceOrderItemPrices(long commerceOrderItemId, BigDecimal discountAmount, BigDecimal discountAmountWithTaxAmount, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel1WithTaxAmount, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel2WithTaxAmount, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel3WithTaxAmount, BigDecimal discountPercentageLevel4, BigDecimal discountPercentageLevel4WithTaxAmount, BigDecimal finalPrice, BigDecimal finalPriceWithTaxAmount, BigDecimal promoPrice, BigDecimal promoPriceWithTaxAmount, BigDecimal unitPrice, BigDecimal unitPriceWithTaxAmount) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        boolean discountChanged = this._isDiscountChanged(discountAmount, discountAmountWithTaxAmount, commerceOrderItem);
        boolean priceChanged = this._isPriceChanged(finalPrice, finalPriceWithTaxAmount, promoPrice, promoPriceWithTaxAmount, unitPrice, unitPriceWithTaxAmount, commerceOrderItem);
        commerceOrderItem.setDiscountAmount((BigDecimal)GetterUtil.get((Object)discountAmount, (Number)BigDecimal.ZERO));
        if (!commerceOrderItem.isDiscountManuallyAdjusted() && discountChanged) {
            commerceOrderItem.setDiscountManuallyAdjusted(true);
        }
        commerceOrderItem.setDiscountPercentageLevel1((BigDecimal)GetterUtil.get((Object)discountPercentageLevel1, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel2((BigDecimal)GetterUtil.get((Object)discountPercentageLevel2, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel3((BigDecimal)GetterUtil.get((Object)discountPercentageLevel3, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel4((BigDecimal)GetterUtil.get((Object)discountPercentageLevel4, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel1WithTaxAmount((BigDecimal)GetterUtil.get((Object)discountPercentageLevel1WithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel2WithTaxAmount((BigDecimal)GetterUtil.get((Object)discountPercentageLevel2WithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel3WithTaxAmount((BigDecimal)GetterUtil.get((Object)discountPercentageLevel3WithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountPercentageLevel4WithTaxAmount((BigDecimal)GetterUtil.get((Object)discountPercentageLevel4WithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setDiscountWithTaxAmount((BigDecimal)GetterUtil.get((Object)discountAmountWithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setFinalPrice((BigDecimal)GetterUtil.get((Object)finalPrice, (Number)BigDecimal.ZERO));
        commerceOrderItem.setFinalPriceWithTaxAmount((BigDecimal)GetterUtil.get((Object)finalPriceWithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setManuallyAdjusted(true);
        if (!commerceOrderItem.isPriceManuallyAdjusted() && priceChanged) {
            commerceOrderItem.setPriceManuallyAdjusted(true);
        }
        commerceOrderItem.setPromoPrice((BigDecimal)GetterUtil.get((Object)promoPrice, (Number)BigDecimal.ZERO));
        commerceOrderItem.setPromoPriceWithTaxAmount((BigDecimal)GetterUtil.get((Object)promoPriceWithTaxAmount, (Number)BigDecimal.ZERO));
        commerceOrderItem.setUnitPrice((BigDecimal)GetterUtil.get((Object)unitPrice, (Number)BigDecimal.ZERO));
        commerceOrderItem.setUnitPriceWithTaxAmount((BigDecimal)GetterUtil.get((Object)unitPriceWithTaxAmount, (Number)BigDecimal.ZERO));
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Deprecated
    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long commerceOrderItemId, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        if (!commerceOrderItem.isPriceManuallyAdjusted() && this._isPriceChanged(unitPrice, commerceOrderItem)) {
            commerceOrderItem.setPriceManuallyAdjusted(true);
        }
        commerceOrderItem.setUnitPrice(unitPrice);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long userId, long commerceOrderItemId, BigDecimal decimalQuantity, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        if (!commerceOrderItem.isPriceManuallyAdjusted() && this._isPriceChanged(unitPrice, commerceOrderItem)) {
            commerceOrderItem.setPriceManuallyAdjusted(true);
        }
        this._updateBookedQuantity(userId, commerceOrderItem, commerceOrderItem.getBookedQuantityId(), decimalQuantity.intValue(), commerceOrderItem.getQuantity());
        commerceOrderItem.setDecimalQuantity(decimalQuantity);
        commerceOrderItem.setManuallyAdjusted(true);
        commerceOrderItem.setUnitPrice(unitPrice);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    public CommerceOrderItem updateCommerceOrderItemUnitPrice(long userId, long commerceOrderItemId, int quantity, BigDecimal unitPrice) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        if (!commerceOrderItem.isPriceManuallyAdjusted() && this._isPriceChanged(unitPrice, commerceOrderItem)) {
            commerceOrderItem.setPriceManuallyAdjusted(true);
        }
        this._updateBookedQuantity(userId, commerceOrderItem, commerceOrderItem.getBookedQuantityId(), quantity, commerceOrderItem.getQuantity());
        commerceOrderItem.setManuallyAdjusted(true);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setUnitPrice(unitPrice);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrderItem updateCustomFields(long commerceOrderItemId, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        return this.commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem);
    }

    public CommerceOrderItem updateExternalReferenceCode(long commerceOrderItemId, String externalReferenceCode) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemLocalService.getCommerceOrderItem(commerceOrderItemId);
        commerceOrderItem.setExternalReferenceCode(externalReferenceCode);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }

    protected SearchContext buildSearchContext(long commerceOrderId, Long parentCommerceOrderItemId, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = new SearchContext();
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        searchContext.setAttribute("commerceOrderId", (Serializable)Long.valueOf(commerceOrderId));
        if (parentCommerceOrderItemId != null) {
            searchContext.setAttribute("parentCommerceOrderItemId", (Serializable)parentCommerceOrderItemId);
        }
        searchContext.setCompanyId(commerceOrder.getCompanyId());
        searchContext.setEnd(end);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CommerceOrderItem> getCommerceOrderItems(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceOrderItem> commerceOrderItems = new ArrayList<CommerceOrderItem>(documents.size());
        for (Document document : documents) {
            long commerceOrderItemId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceOrderItem commerceOrderItem = this.fetchCommerceOrderItem(commerceOrderItemId);
            if (commerceOrderItem == null) {
                commerceOrderItems = null;
                continue;
            }
            if (commerceOrderItems == null) continue;
            commerceOrderItems.add(commerceOrderItem);
        }
        return commerceOrderItems;
    }

    protected BaseModelSearchResult<CommerceOrderItem> searchCommerceOrderItems(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceOrderItem.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceOrderItem> commerceOrderItems = this.getCommerceOrderItems(hits);
            if (commerceOrderItems == null) continue;
            return new BaseModelSearchResult(commerceOrderItems, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected CommerceOrder updateWorkflow(CommerceOrder commerceOrder, ServiceContext serviceContext) throws PortalException {
        WorkflowDefinitionLink workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), 0L, 0L, true);
        if (workflowDefinitionLink != null && commerceOrder.isApproved()) {
            return this._commerceOrderLocalService.updateStatus(serviceContext.getUserId(), commerceOrder.getCommerceOrderId(), 2, serviceContext, Collections.emptyMap());
        }
        return commerceOrder;
    }

    protected void validate(Locale locale, CommerceOrder commerceOrder, CPDefinition cpDefinition, CPInstance cpInstance, int quantity, boolean validateOrder) throws PortalException {
        List commerceCartValidatorResults;
        int count;
        if (commerceOrder.getUserId() == 0L && (count = this.commerceOrderItemPersistence.countByCommerceOrderId(commerceOrder.getCommerceOrderId())) >= this._commerceOrderConfiguration.guestCartItemMaxAllowed()) {
            throw new GuestCartItemMaxAllowedException();
        }
        if (cpDefinition != null && cpInstance != null && cpDefinition.getCPDefinitionId() != cpInstance.getCPDefinitionId()) {
            throw new NoSuchCPInstanceException(StringBundler.concat((Object[])new Object[]{"CPInstance ", cpInstance.getCPInstanceId(), " belongs to a different CPDefinition than ", cpDefinition.getCPDefinitionId()}));
        }
        if (!ExportImportThreadLocal.isImportInProcess() && validateOrder && !(commerceCartValidatorResults = this._commerceOrderValidatorRegistry.validate(locale, commerceOrder, cpInstance, quantity)).isEmpty()) {
            throw new CommerceOrderValidatorException(commerceCartValidatorResults);
        }
    }

    protected void validateParentCommerceOrderId(CommerceOrderItem commerceOrderItem) throws PortalException {
        if (commerceOrderItem.getParentCommerceOrderItemId() != 0L) {
            throw new ProductBundleException(StringBundler.concat((Object[])new Object[]{"Operation not allowed on an item ", commerceOrderItem.getCommerceOrderItemId(), " because it is a child commerce order item ", commerceOrderItem.getParentCommerceOrderItemId()}));
        }
    }

    private CommerceOrderItem _createCommerceOrderItem(long groupId, User user, CommerceOrder commerceOrder, CPInstance cpInstance, long parentCommerceOrderItemId, String json, int quantity, int shippedQuantity, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        this.validate(serviceContext.getLocale(), commerceOrder, cpDefinition, cpInstance, quantity, GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateOrder"), (boolean)true));
        long commerceOrderItemId = this.counterLocalService.increment();
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.create(commerceOrderItemId);
        commerceOrderItem.setGroupId(groupId);
        commerceOrderItem.setCompanyId(user.getCompanyId());
        commerceOrderItem.setUserId(user.getUserId());
        commerceOrderItem.setUserName(user.getFullName());
        commerceOrderItem.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderItem.setCPInstanceId(cpInstance.getCPInstanceId());
        commerceOrderItem.setCProductId(cpDefinition.getCProductId());
        commerceOrderItem.setParentCommerceOrderItemId(parentCommerceOrderItemId);
        commerceOrderItem.setJson(json);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            CommerceProductPrice commerceProductPrice = this._getCommerceProductPrice(cpInstance.getCPDefinitionId(), cpInstance.getCPInstanceId(), json, quantity, commerceContext);
            this._setCommerceOrderItemPrice(commerceOrderItem, commerceProductPrice);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue(), false);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
        }
        commerceOrderItem.setNameMap(cpDefinition.getNameMap());
        commerceOrderItem.setManuallyAdjusted(false);
        commerceOrderItem.setSku(cpInstance.getSku());
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        commerceOrderItem.setSubscription(this._isSubscription(cpInstance));
        this._setSubscriptionInfo(commerceOrderItem, cpInstance);
        commerceOrderItem.setFreeShipping(cpDefinition.isFreeShipping());
        commerceOrderItem.setShipSeparately(cpDefinition.isShipSeparately());
        commerceOrderItem.setShippable(cpDefinition.isShippable());
        commerceOrderItem.setShippingExtraPrice(cpDefinition.getShippingExtraPrice());
        this._setDimensions(commerceOrderItem, cpInstance);
        return commerceOrderItem;
    }

    private void _deleteBundleChildrenOrderItems(long commerceOrderItemId) throws PortalException {
        List childCommerceOrderItems = this.commerceOrderItemPersistence.findByParentCommerceOrderItemId(commerceOrderItemId);
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            childCommerceOrderItem.setParentCommerceOrderItemId(0L);
            this.commerceOrderItemLocalService.deleteCommerceOrderItem(childCommerceOrderItem);
        }
    }

    private CommerceOrderItem _deleteCommerceOrderItem(CommerceOrderItem commerceOrderItem) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity;
        this._deleteBundleChildrenOrderItems(commerceOrderItem.getCommerceOrderItemId());
        this.commerceOrderItemPersistence.remove((BaseModel)commerceOrderItem);
        if (commerceOrderItem.getBookedQuantityId() > 0L && (commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.fetchCommerceInventoryBookedQuantity(commerceOrderItem.getBookedQuantityId())) != null) {
            this._commerceInventoryBookedQuantityLocalService.deleteCommerceInventoryBookedQuantity(commerceInventoryBookedQuantity);
        }
        this._expandoRowLocalService.deleteRows(commerceOrderItem.getCommerceOrderItemId());
        this.updateWorkflow(commerceOrderItem.getCommerceOrder(), ServiceContextThreadLocal.getServiceContext());
        return commerceOrderItem;
    }

    private CommerceProductPrice _getCommerceProductPrice(long cpDefinitionId, long cpInstanceId, String json, int quantity, CommerceContext commerceContext) throws PortalException {
        CommerceProductPriceRequest commerceProductPriceRequest = new CommerceProductPriceRequest();
        commerceProductPriceRequest.setCpInstanceId(cpInstanceId);
        commerceProductPriceRequest.setQuantity(quantity);
        commerceProductPriceRequest.setSecure(false);
        commerceProductPriceRequest.setCommerceContext(commerceContext);
        commerceProductPriceRequest.setCommerceOptionValues(this._getStaticOptionValuesNotLinkedToSku(cpDefinitionId, json));
        commerceProductPriceRequest.setCalculateTax(true);
        return this._commerceProductPriceCalculation.getCommerceProductPrice(commerceProductPriceRequest);
    }

    private BigDecimal _getConvertedPrice(long cpInstanceId, BigDecimal price, CommerceOrder commerceOrder) throws PortalException {
        return CommercePriceConverterUtil.getConvertedPrice(commerceOrder.getGroupId(), cpInstanceId, commerceOrder.getBillingAddressId(), commerceOrder.getShippingAddressId(), price, false, this._commerceTaxCalculation);
    }

    private String _getCPInstanceOptionValueRelsJSONString(long cpInstanceId) throws PortalException {
        JSONArray jsonArray = this._jsonHelper.toJSONArray(this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys(cpInstanceId));
        return jsonArray.toString();
    }

    private Predicate _getPredicate(long commerceOrderId, Long[] commerceOrderItemIds, String[] externalReferenceCodes) {
        return CommerceOrderItemTable.INSTANCE.commerceOrderId.eq((Object)commerceOrderId).and(() -> {
            Predicate predicate = null;
            if (ArrayUtil.isNotEmpty((Object[])commerceOrderItemIds)) {
                predicate = CommerceOrderItemTable.INSTANCE.commerceOrderItemId.in((Object[])commerceOrderItemIds);
            }
            if (ArrayUtil.isNotEmpty((Object[])externalReferenceCodes)) {
                if (predicate != null) {
                    return predicate.or((Expression)CommerceOrderItemTable.INSTANCE.externalReferenceCode.in((Object[])externalReferenceCodes));
                }
                predicate = CommerceOrderItemTable.INSTANCE.externalReferenceCode.in((Object[])externalReferenceCodes);
            }
            return predicate;
        });
    }

    private CommerceProductPrice _getStaticCommerceProductPrice(long cpInstanceId, int quantity, BigDecimal optionValuePrice, CommerceOrder commerceOrder, CommerceCurrency commerceCurrency) throws PortalException {
        CommerceProductPriceImpl commerceProductPriceImpl = new CommerceProductPriceImpl();
        if (optionValuePrice == null) {
            optionValuePrice = BigDecimal.ZERO;
        }
        commerceProductPriceImpl.setUnitPrice(this._commerceMoneyFactory.create(commerceCurrency, optionValuePrice));
        commerceProductPriceImpl.setUnitPromoPrice(this._commerceMoneyFactory.create(commerceCurrency, BigDecimal.ZERO));
        commerceProductPriceImpl.setUnitPromoPriceWithTaxAmount(this._commerceMoneyFactory.create(commerceCurrency, BigDecimal.ZERO));
        BigDecimal unitPriceWithTaxAmount = optionValuePrice;
        BigDecimal finalPriceWithTaxAmount = optionValuePrice;
        if (cpInstanceId > 0L) {
            unitPriceWithTaxAmount = this._getConvertedPrice(cpInstanceId, optionValuePrice, commerceOrder);
            optionValuePrice = optionValuePrice.multiply(BigDecimal.valueOf(quantity));
            finalPriceWithTaxAmount = this._getConvertedPrice(cpInstanceId, optionValuePrice, commerceOrder);
        }
        commerceProductPriceImpl.setUnitPriceWithTaxAmount(this._commerceMoneyFactory.create(commerceCurrency, unitPriceWithTaxAmount));
        commerceProductPriceImpl.setFinalPrice(this._commerceMoneyFactory.create(commerceCurrency, optionValuePrice));
        commerceProductPriceImpl.setFinalPriceWithTaxAmount(this._commerceMoneyFactory.create(commerceCurrency, finalPriceWithTaxAmount));
        commerceProductPriceImpl.setCommerceDiscountValue(null);
        commerceProductPriceImpl.setQuantity(quantity);
        return commerceProductPriceImpl;
    }

    private List<CommerceOptionValue> _getStaticOptionValuesNotLinkedToSku(long cpDefinitionId, String jsonArrayString) throws PortalException {
        List commerceOptionValues = this._commerceOptionValueHelper.getCPDefinitionCommerceOptionValues(cpDefinitionId, jsonArrayString);
        Stream commerceOptionValuesStream = commerceOptionValues.stream();
        Stream<CommerceOptionValue> commerceOptionValuesFiltered = commerceOptionValuesStream.filter(commerceOptionValue -> this._isStaticPriceType(commerceOptionValue.getPriceType()) && commerceOptionValue.getCPInstanceId() == 0L);
        return commerceOptionValuesFiltered.collect(Collectors.toList());
    }

    private boolean _isDiscountChanged(BigDecimal discountAmount, BigDecimal discountAmountWithTaxAmount, CommerceOrderItem commerceOrderItem) {
        if (discountAmount == null) {
            discountAmount = BigDecimal.ZERO;
        }
        if (discountAmountWithTaxAmount == null) {
            discountAmountWithTaxAmount = BigDecimal.ZERO;
        }
        int discountAmountCompareTo = 0;
        if (commerceOrderItem.getDiscountAmount() != null) {
            discountAmountCompareTo = discountAmount.compareTo(commerceOrderItem.getDiscountAmount());
        }
        int discountAmountWithTaxAmountCompareTo = 0;
        if (commerceOrderItem.getDiscountWithTaxAmount() != null) {
            discountAmountWithTaxAmountCompareTo = discountAmountWithTaxAmount.compareTo(commerceOrderItem.getDiscountWithTaxAmount());
        }
        return discountAmountCompareTo != 0 || discountAmountWithTaxAmountCompareTo != 0;
    }

    private boolean _isDiscountChanged(BigDecimal discountAmount, CommerceOrderItem commerceOrderItem) {
        if (discountAmount == null) {
            discountAmount = BigDecimal.ZERO;
        }
        int discountAmountCompareTo = 0;
        if (commerceOrderItem.getDiscountAmount() != null) {
            discountAmountCompareTo = discountAmount.compareTo(commerceOrderItem.getDiscountAmount());
        }
        return discountAmountCompareTo != 0;
    }

    private boolean _isPriceChanged(BigDecimal finalPrice, BigDecimal finalPriceWithTaxAmount, BigDecimal promoPrice, BigDecimal promoPriceWithTaxAmount, BigDecimal unitPrice, BigDecimal unitPriceWithTaxAmount, CommerceOrderItem commerceOrderItem) {
        if (finalPrice == null) {
            finalPrice = BigDecimal.ZERO;
        }
        if (promoPrice == null) {
            promoPrice = BigDecimal.ZERO;
        }
        if (unitPrice == null) {
            unitPrice = BigDecimal.ZERO;
        }
        if (promoPriceWithTaxAmount == null) {
            promoPriceWithTaxAmount = BigDecimal.ZERO;
        }
        if (finalPriceWithTaxAmount == null) {
            finalPriceWithTaxAmount = BigDecimal.ZERO;
        }
        if (unitPriceWithTaxAmount == null) {
            unitPriceWithTaxAmount = BigDecimal.ZERO;
        }
        int finalPriceCompareTo = 0;
        if (commerceOrderItem.getFinalPrice() != null) {
            finalPriceCompareTo = finalPrice.compareTo(commerceOrderItem.getFinalPrice());
        }
        int promoPriceCompareTo = 0;
        if (commerceOrderItem.getPromoPrice() != null) {
            promoPriceCompareTo = promoPrice.compareTo(commerceOrderItem.getPromoPrice());
        }
        int unitPriceCompareTo = 0;
        if (commerceOrderItem.getUnitPrice() != null) {
            unitPriceCompareTo = unitPrice.compareTo(commerceOrderItem.getUnitPrice());
        }
        int finalPriceWithTaxAmountCompareTo = 0;
        if (commerceOrderItem.getFinalPriceWithTaxAmount() != null) {
            finalPriceWithTaxAmountCompareTo = finalPriceWithTaxAmount.compareTo(commerceOrderItem.getFinalPriceWithTaxAmount());
        }
        int promoPriceWithTaxAmountCompareTo = 0;
        if (commerceOrderItem.getPromoPriceWithTaxAmount() != null) {
            promoPriceWithTaxAmountCompareTo = promoPriceWithTaxAmount.compareTo(commerceOrderItem.getPromoPriceWithTaxAmount());
        }
        int unitPriceWithTaxAmountCompareTo = 0;
        if (commerceOrderItem.getUnitPriceWithTaxAmount() != null) {
            unitPriceWithTaxAmountCompareTo = unitPriceWithTaxAmount.compareTo(commerceOrderItem.getUnitPriceWithTaxAmount());
        }
        return finalPriceCompareTo != 0 || promoPriceCompareTo != 0 || unitPriceCompareTo != 0 || finalPriceWithTaxAmountCompareTo != 0 || promoPriceWithTaxAmountCompareTo != 0 || unitPriceWithTaxAmountCompareTo != 0;
    }

    private boolean _isPriceChanged(BigDecimal finalPrice, BigDecimal promoPrice, BigDecimal unitPrice, CommerceOrderItem commerceOrderItem) {
        if (finalPrice == null) {
            finalPrice = BigDecimal.ZERO;
        }
        if (promoPrice == null) {
            promoPrice = BigDecimal.ZERO;
        }
        if (unitPrice == null) {
            unitPrice = BigDecimal.ZERO;
        }
        int finalPriceCompareTo = 0;
        if (commerceOrderItem.getFinalPrice() != null) {
            finalPriceCompareTo = finalPrice.compareTo(commerceOrderItem.getFinalPrice());
        }
        int promoPriceCompareTo = 0;
        if (commerceOrderItem.getPromoPrice() != null) {
            promoPriceCompareTo = promoPrice.compareTo(commerceOrderItem.getPromoPrice());
        }
        int unitPriceCompareTo = 0;
        if (commerceOrderItem.getUnitPrice() != null) {
            unitPriceCompareTo = unitPrice.compareTo(commerceOrderItem.getUnitPrice());
        }
        return finalPriceCompareTo != 0 || promoPriceCompareTo != 0 || unitPriceCompareTo != 0;
    }

    private boolean _isPriceChanged(BigDecimal unitPrice, CommerceOrderItem commerceOrderItem) {
        if (unitPrice == null) {
            unitPrice = BigDecimal.ZERO;
        }
        int unitPriceCompareTo = 0;
        if (commerceOrderItem.getUnitPrice() != null) {
            unitPriceCompareTo = unitPrice.compareTo(commerceOrderItem.getUnitPrice());
        }
        return unitPriceCompareTo != 0;
    }

    private boolean _isStaticPriceType(Object value) {
        return Objects.equals(value, "static");
    }

    private boolean _isSubscription(CPInstance cpInstance) throws PortalException {
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        if (cpDefinition.isSubscriptionEnabled() || cpDefinition.isDeliverySubscriptionEnabled()) {
            return true;
        }
        return cpInstance.isOverrideSubscriptionInfo() && (cpInstance.isSubscriptionEnabled() || cpInstance.isDeliverySubscriptionEnabled());
    }

    private boolean _jsonMatches(String json1, String json2) {
        return Objects.equals(json1, json2);
    }

    private void _setCommerceOrderItemDiscountValue(CommerceOrderItem commerceOrderItem, CommerceDiscountValue commerceDiscountValue, boolean includeTax) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1 && percentages[0] != null) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2 && percentages[1] != null) {
                discountPercentageLevel2 = percentages[1];
            }
            if (percentages.length >= 3 && percentages[2] != null) {
                discountPercentageLevel3 = percentages[2];
            }
            if (percentages.length >= 4 && percentages[3] != null) {
                discountPercentageLevel4 = percentages[3];
            }
        }
        if (includeTax) {
            commerceOrderItem.setDiscountPercentageLevel1WithTaxAmount(discountPercentageLevel1);
            commerceOrderItem.setDiscountPercentageLevel2WithTaxAmount(discountPercentageLevel2);
            commerceOrderItem.setDiscountPercentageLevel3WithTaxAmount(discountPercentageLevel3);
            commerceOrderItem.setDiscountPercentageLevel4WithTaxAmount(discountPercentageLevel4);
            commerceOrderItem.setDiscountWithTaxAmount(discountAmount);
        } else {
            commerceOrderItem.setDiscountAmount(discountAmount);
            commerceOrderItem.setDiscountPercentageLevel1(discountPercentageLevel1);
            commerceOrderItem.setDiscountPercentageLevel2(discountPercentageLevel2);
            commerceOrderItem.setDiscountPercentageLevel3(discountPercentageLevel3);
            commerceOrderItem.setDiscountPercentageLevel4(discountPercentageLevel4);
        }
    }

    private void _setCommerceOrderItemPrice(CommerceOrderItem commerceOrderItem, CommerceProductPrice commerceProductPrice) {
        CommerceMoney finalPriceWithTaxAmountCommerceMoney;
        CommerceMoney unitPromoPriceWithTaxAmountCommerceMoney;
        CommerceMoney unitPriceCommerceMoney = commerceProductPrice.getUnitPrice();
        commerceOrderItem.setUnitPrice(unitPriceCommerceMoney.getPrice());
        BigDecimal promoPrice = BigDecimal.ZERO;
        BigDecimal promoPriceWithTaxAmount = BigDecimal.ZERO;
        CommerceMoney unitPromoPriceCommerceMoney = commerceProductPrice.getUnitPromoPrice();
        if (!unitPromoPriceCommerceMoney.isEmpty()) {
            promoPrice = unitPromoPriceCommerceMoney.getPrice();
        }
        if (!(unitPromoPriceWithTaxAmountCommerceMoney = commerceProductPrice.getUnitPromoPriceWithTaxAmount()).isEmpty()) {
            promoPriceWithTaxAmount = unitPromoPriceWithTaxAmountCommerceMoney.getPrice();
        }
        commerceOrderItem.setPromoPrice(promoPrice);
        commerceOrderItem.setPromoPriceWithTaxAmount(promoPriceWithTaxAmount);
        CommerceMoney finalPriceCommerceMoney = commerceProductPrice.getFinalPrice();
        commerceOrderItem.setFinalPrice(finalPriceCommerceMoney.getPrice());
        CommerceMoney unitPriceWithTaxAmountCommerceMoney = commerceProductPrice.getUnitPriceWithTaxAmount();
        if (unitPriceWithTaxAmountCommerceMoney != null) {
            commerceOrderItem.setUnitPriceWithTaxAmount(unitPriceWithTaxAmountCommerceMoney.getPrice());
        }
        if ((finalPriceWithTaxAmountCommerceMoney = commerceProductPrice.getFinalPriceWithTaxAmount()) != null) {
            commerceOrderItem.setFinalPriceWithTaxAmount(finalPriceWithTaxAmountCommerceMoney.getPrice());
        }
        commerceOrderItem.setCommercePriceListId(commerceProductPrice.getCommercePriceListId());
    }

    private void _setCommerceOrderItemPrice(CommerceOrderItem commerceOrderItem, CommerceProductPrice commerceProductPrice, CommerceContext commerceContext) throws PortalException {
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (cpInstance == null || commerceOrderItem.isManuallyAdjusted()) {
            return;
        }
        if (commerceProductPrice == null) {
            commerceProductPrice = this._getCommerceProductPrice(commerceOrderItem.getCPDefinitionId(), commerceOrderItem.getCPInstanceId(), commerceOrderItem.getJson(), commerceOrderItem.getQuantity(), commerceContext);
        }
        this._setCommerceOrderItemPrice(commerceOrderItem, commerceProductPrice);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue(), false);
        this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
    }

    private void _setDimensions(CommerceOrderItem commerceOrderItem, CPInstance cpInstance) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        commerceOrderItem.setWidth(cpInstance.getWidth());
        if (commerceOrderItem.getWidth() <= 0.0) {
            commerceOrderItem.setWidth(cpDefinition.getWidth());
        }
        commerceOrderItem.setHeight(cpInstance.getHeight());
        if (commerceOrderItem.getHeight() <= 0.0) {
            commerceOrderItem.setHeight(cpDefinition.getHeight());
        }
        commerceOrderItem.setDepth(cpInstance.getDepth());
        if (commerceOrderItem.getDepth() <= 0.0) {
            commerceOrderItem.setDepth(cpDefinition.getDepth());
        }
        commerceOrderItem.setWeight(cpInstance.getWeight());
        if (commerceOrderItem.getWeight() <= 0.0) {
            commerceOrderItem.setWeight(cpDefinition.getWeight());
        }
    }

    private void _setSubscriptionInfo(CommerceOrderItem commerceOrderItem, CPInstance cpInstance) throws PortalException {
        if (cpInstance.isOverrideSubscriptionInfo()) {
            if (cpInstance.isDeliverySubscriptionEnabled()) {
                commerceOrderItem.setDeliveryMaxSubscriptionCycles(cpInstance.getDeliveryMaxSubscriptionCycles());
                commerceOrderItem.setDeliverySubscriptionLength(cpInstance.getDeliverySubscriptionLength());
                commerceOrderItem.setDeliverySubscriptionType(cpInstance.getDeliverySubscriptionType());
                commerceOrderItem.setDeliverySubscriptionTypeSettings(cpInstance.getDeliverySubscriptionTypeSettings());
            }
            if (cpInstance.isSubscriptionEnabled()) {
                commerceOrderItem.setMaxSubscriptionCycles(cpInstance.getMaxSubscriptionCycles());
                commerceOrderItem.setSubscriptionLength(cpInstance.getSubscriptionLength());
                commerceOrderItem.setSubscriptionType(cpInstance.getSubscriptionType());
                commerceOrderItem.setSubscriptionTypeSettings(cpInstance.getSubscriptionTypeSettings());
            }
        } else {
            CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
            if (cpDefinition.isDeliverySubscriptionEnabled()) {
                commerceOrderItem.setDeliveryMaxSubscriptionCycles(cpDefinition.getDeliveryMaxSubscriptionCycles());
                commerceOrderItem.setDeliverySubscriptionLength(cpDefinition.getDeliverySubscriptionLength());
                commerceOrderItem.setDeliverySubscriptionType(cpDefinition.getDeliverySubscriptionType());
                commerceOrderItem.setDeliverySubscriptionTypeSettings(cpDefinition.getDeliverySubscriptionTypeSettings());
            }
            if (cpDefinition.isSubscriptionEnabled()) {
                commerceOrderItem.setMaxSubscriptionCycles(cpDefinition.getMaxSubscriptionCycles());
                commerceOrderItem.setSubscriptionLength(cpDefinition.getSubscriptionLength());
                commerceOrderItem.setSubscriptionType(cpDefinition.getSubscriptionType());
                commerceOrderItem.setSubscriptionTypeSettings(cpDefinition.getSubscriptionTypeSettings());
            }
        }
    }

    private void _updateBookedQuantity(long userId, CommerceOrderItem commerceOrderItem, long bookedQuantityId, int quantity, int oldQuantity) throws PortalException {
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity;
        if (oldQuantity != quantity && bookedQuantityId > 0L && (commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.fetchCommerceInventoryBookedQuantity(bookedQuantityId)) != null) {
            this._commerceInventoryBookedQuantityLocalService.updateCommerceInventoryBookedQuantity(userId, commerceInventoryBookedQuantity.getCommerceInventoryBookedQuantityId(), quantity, (Map)HashMapBuilder.put((Object)"orderId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderId())).put((Object)"orderItemId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderItemId())).build(), commerceInventoryBookedQuantity.getMvccVersion());
        }
    }

    private CommerceOrderItem _updateCommerceOrderItem(CommerceOrderItem commerceOrderItem, String externalReferenceCode, User user, CommerceOrder commerceOrder, CPInstance cpInstance, int quantity, int shippedQuantity, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        this.validate(serviceContext.getLocale(), commerceOrder, cpDefinition, cpInstance, quantity, GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateOrder"), (boolean)true));
        commerceOrderItem.setExternalReferenceCode(externalReferenceCode);
        commerceOrderItem.setGroupId(commerceOrder.getGroupId());
        commerceOrderItem.setCompanyId(user.getCompanyId());
        commerceOrderItem.setUserId(user.getUserId());
        commerceOrderItem.setUserName(user.getFullName());
        commerceOrderItem.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderItem.setCPInstanceId(cpInstance.getCPInstanceId());
        commerceOrderItem.setCProductId(cpDefinition.getCProductId());
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setShippedQuantity(shippedQuantity);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            CommerceProductPrice commerceProductPrice = this._getCommerceProductPrice(cpInstance.getCPDefinitionId(), cpInstance.getCPInstanceId(), commerceOrderItem.getJson(), quantity, null);
            this._setCommerceOrderItemPrice(commerceOrderItem, commerceProductPrice);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue(), false);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
        }
        commerceOrderItem.setNameMap(cpDefinition.getNameMap());
        commerceOrderItem.setManuallyAdjusted(false);
        commerceOrderItem.setSku(cpInstance.getSku());
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        commerceOrderItem.setSubscription(this._isSubscription(cpInstance));
        this._setSubscriptionInfo(commerceOrderItem, cpInstance);
        commerceOrderItem.setFreeShipping(cpDefinition.isFreeShipping());
        commerceOrderItem.setShipSeparately(cpDefinition.isShipSeparately());
        commerceOrderItem.setShippable(cpDefinition.isShippable());
        commerceOrderItem.setShippingExtraPrice(cpDefinition.getShippingExtraPrice());
        this._setDimensions(commerceOrderItem, cpInstance);
        return commerceOrderItem;
    }

    private CommerceOrderItem _updateCommerceOrderItem(long commerceOrderItemId, int quantity, String json, CommerceProductPrice commerceProductPrice, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        this.validate(serviceContext.getLocale(), commerceOrder, commerceOrderItem.getCPDefinition(), commerceOrderItem.fetchCPInstance(), quantity, GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateOrder"), (boolean)true));
        this._updateBookedQuantity(serviceContext.getUserId(), commerceOrderItem, commerceOrderItem.getBookedQuantityId(), quantity, commerceOrderItem.getQuantity());
        commerceOrder = this.updateWorkflow(commerceOrder, serviceContext);
        commerceOrderItem.setJson(json);
        commerceOrderItem.setQuantity(quantity);
        if (commerceOrder.isOpen()) {
            if (commerceProductPrice == null) {
                commerceProductPrice = this._getCommerceProductPrice(commerceOrderItem.getCPDefinitionId(), commerceOrderItem.getCPInstanceId(), commerceOrderItem.getJson(), quantity, commerceContext);
            }
            this._setCommerceOrderItemPrice(commerceOrderItem, commerceProductPrice);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValue(), false);
            this._setCommerceOrderItemDiscountValue(commerceOrderItem, commerceProductPrice.getDiscountValueWithTaxAmount(), true);
        }
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        commerceOrderItem = (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
        if (commerceOrder.isOpen()) {
            this._commerceOrderLocalService.recalculatePrice(commerceOrderItem.getCommerceOrderId(), commerceContext);
        }
        return commerceOrderItem;
    }

    private CommerceOrderItem _updateCommerceOrderItem(long commerceOrderItemId, int quantity, String json, ServiceContext serviceContext) throws PortalException {
        CommerceOrderItem commerceOrderItem = this.commerceOrderItemPersistence.findByPrimaryKey(commerceOrderItemId);
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        this.validate(serviceContext.getLocale(), commerceOrder, commerceOrderItem.getCPDefinition(), commerceOrderItem.fetchCPInstance(), quantity, GetterUtil.getBoolean((Object)serviceContext.getAttribute("validateOrder"), (boolean)true));
        this._updateBookedQuantity(serviceContext.getUserId(), commerceOrderItem, commerceOrderItem.getBookedQuantityId(), quantity, commerceOrderItem.getQuantity());
        this.updateWorkflow(commerceOrder, serviceContext);
        commerceOrderItem.setJson(json);
        commerceOrderItem.setQuantity(quantity);
        commerceOrderItem.setExpandoBridgeAttributes(serviceContext);
        return (CommerceOrderItem)this.commerceOrderItemPersistence.update((BaseModel)commerceOrderItem);
    }
}

