/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v6_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

public class CommerceRegionUpgradeProcess
extends UpgradeProcess {
    private static final String[] _TABLE_NAMES = new String[]{"CommerceAddress", "CommerceTaxFixedRateAddressRel", "CShippingFixedOptionRel"};
    private final RegionLocalService _regionLocalService;

    public CommerceRegionUpgradeProcess(RegionLocalService regionLocalService) {
        this._regionLocalService = regionLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (Statement selectStatement = this.connection.createStatement();){
            ResultSet resultSet = selectStatement.executeQuery("select * from CommerceRegion order by commerceRegionId asc");
            while (resultSet.next()) {
                boolean active = resultSet.getBoolean("active_");
                String code = resultSet.getString("code_");
                long commerceCountryId = resultSet.getLong("commerceCountryId");
                long commerceRegionId = resultSet.getLong("commerceRegionId");
                Timestamp lastPublishDate = resultSet.getTimestamp("lastPublishDate");
                String name = resultSet.getString("name");
                Double priority = resultSet.getDouble("priority");
                Region region = this._regionLocalService.fetchRegion(commerceCountryId, code);
                region = region != null ? this._updateRegion(region, active, name, priority, code, lastPublishDate) : this._addRegion(commerceRegionId, resultSet.getLong("companyId"), resultSet.getLong("userId"), resultSet.getString("userName"), resultSet.getTimestamp("createDate"), resultSet.getTimestamp("modifiedDate"), commerceCountryId, active, name, priority, code, lastPublishDate);
                if (region.getRegionId() == commerceRegionId) continue;
                for (String tableName : _TABLE_NAMES) {
                    this._updateRegionId(tableName, region.getRegionId(), commerceRegionId);
                }
            }
            this.runSQL("drop table CommerceRegion");
        }
    }

    private Region _addRegion(long regionId, long companyId, long userId, String userName, Date createDate, Date modifiedDate, long countryId, boolean active, String name, Double position, String regionCode, Date lastPublishDate) {
        if (this._regionLocalService.fetchRegion(regionId) != null) {
            regionId = this.increment();
        }
        Region region = this._regionLocalService.createRegion(regionId);
        region.setCompanyId(companyId);
        region.setUserId(userId);
        region.setUserName(userName);
        region.setCreateDate(createDate);
        region.setModifiedDate(modifiedDate);
        region.setCountryId(countryId);
        region.setActive(active);
        region.setName(name);
        region.setPosition(position.doubleValue());
        region.setRegionCode(regionCode);
        region.setLastPublishDate(lastPublishDate);
        return this._regionLocalService.addRegion(region);
    }

    private Region _updateRegion(Region region, boolean active, String name, Double position, String regionCode, Date lastPublishDate) {
        region.setActive(active);
        region.setName(name);
        region.setPosition(position.doubleValue());
        region.setRegionCode(regionCode);
        region.setLastPublishDate(lastPublishDate);
        return this._regionLocalService.updateRegion(region);
    }

    private void _updateRegionId(String tableName, long newRegionId, long oldRegionId) throws Exception {
        this.runSQL(StringBundler.concat((Object[])new Object[]{"update ", tableName, " set regionId = ", newRegionId, " where regionId = ", oldRegionId}));
    }
}

