/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.exception.NoSuchCountryException;
import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.CommerceCountryTable;
import com.liferay.commerce.model.impl.CommerceCountryImpl;
import com.liferay.commerce.model.impl.CommerceCountryModelImpl;
import com.liferay.commerce.service.persistence.CommerceCountryPersistence;
import com.liferay.commerce.service.persistence.CommerceCountryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class CommerceCountryPersistenceImpl
extends BasePersistenceImpl<CommerceCountry>
implements CommerceCountryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceCountryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "commerceCountry.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(commerceCountry.uuid IS NULL OR commerceCountry.uuid = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "commerceCountry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(commerceCountry.uuid IS NULL OR commerceCountry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "commerceCountry.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "commerceCountry.companyId = ?";
    private FinderPath _finderPathFetchByC_Tw;
    private FinderPath _finderPathCountByC_Tw;
    private static final String _FINDER_COLUMN_C_TW_COMPANYID_2 = "commerceCountry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_TW_TWOLETTERSISOCODE_2 = "commerceCountry.twoLettersISOCode = ?";
    private static final String _FINDER_COLUMN_C_TW_TWOLETTERSISOCODE_3 = "(commerceCountry.twoLettersISOCode IS NULL OR commerceCountry.twoLettersISOCode = '')";
    private FinderPath _finderPathFetchByC_N;
    private FinderPath _finderPathCountByC_N;
    private static final String _FINDER_COLUMN_C_N_COMPANYID_2 = "commerceCountry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_N_NUMERICISOCODE_2 = "commerceCountry.numericISOCode = ?";
    private FinderPath _finderPathWithPaginationFindByC_A;
    private FinderPath _finderPathWithoutPaginationFindByC_A;
    private FinderPath _finderPathCountByC_A;
    private static final String _FINDER_COLUMN_C_A_COMPANYID_2 = "commerceCountry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_A_ACTIVE_2 = "commerceCountry.active = ?";
    private FinderPath _finderPathWithPaginationFindByC_B_A;
    private FinderPath _finderPathWithoutPaginationFindByC_B_A;
    private FinderPath _finderPathCountByC_B_A;
    private static final String _FINDER_COLUMN_C_B_A_COMPANYID_2 = "commerceCountry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_B_A_BILLINGALLOWED_2 = "commerceCountry.billingAllowed = ? AND ";
    private static final String _FINDER_COLUMN_C_B_A_ACTIVE_2 = "commerceCountry.active = ?";
    private FinderPath _finderPathWithPaginationFindByC_S_A;
    private FinderPath _finderPathWithoutPaginationFindByC_S_A;
    private FinderPath _finderPathCountByC_S_A;
    private static final String _FINDER_COLUMN_C_S_A_COMPANYID_2 = "commerceCountry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_A_SHIPPINGALLOWED_2 = "commerceCountry.shippingAllowed = ? AND ";
    private static final String _FINDER_COLUMN_C_S_A_ACTIVE_2 = "commerceCountry.active = ?";
    private int _valueObjectFinderCacheListThreshold;
    private BundleContext _bundleContext;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCECOUNTRY = "SELECT commerceCountry FROM CommerceCountry commerceCountry";
    private static final String _SQL_SELECT_COMMERCECOUNTRY_WHERE = "SELECT commerceCountry FROM CommerceCountry commerceCountry WHERE ";
    private static final String _SQL_COUNT_COMMERCECOUNTRY = "SELECT COUNT(commerceCountry) FROM CommerceCountry commerceCountry";
    private static final String _SQL_COUNT_COMMERCECOUNTRY_WHERE = "SELECT COUNT(commerceCountry) FROM CommerceCountry commerceCountry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceCountry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceCountry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceCountry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceCountryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid", "active"});
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<CommerceCountry> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<CommerceCountry> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<CommerceCountry> findByUuid(String uuid, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<CommerceCountry> findByUuid(String uuid, int start, int end, OrderByComparator<CommerceCountry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCountry commerceCountry : list) {
                if (uuid.equals(commerceCountry.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCountry.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCountry findByUuid_First(String uuid, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByUuid_First(uuid, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByUuid_First(String uuid, OrderByComparator<CommerceCountry> orderByComparator) {
        List<CommerceCountry> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry findByUuid_Last(String uuid, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByUuid_Last(uuid, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByUuid_Last(String uuid, OrderByComparator<CommerceCountry> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<CommerceCountry> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry[] findByUuid_PrevAndNext(long commerceCountryId, String uuid, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        uuid = Objects.toString(uuid, "");
        CommerceCountry commerceCountry = this.findByPrimaryKey(commerceCountryId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCountry[] array = new CommerceCountryImpl[]{this.getByUuid_PrevAndNext(session, commerceCountry, uuid, orderByComparator, true), commerceCountry, this.getByUuid_PrevAndNext(session, commerceCountry, uuid, orderByComparator, false)};
            CommerceCountry[] commerceCountryArray = array;
            return commerceCountryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCountry getByUuid_PrevAndNext(Session session, CommerceCountry commerceCountry, String uuid, OrderByComparator<CommerceCountry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCountry.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCountry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCountry)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (CommerceCountry commerceCountry : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)commerceCountry);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCECOUNTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceCountry> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<CommerceCountry> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<CommerceCountry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<CommerceCountry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<CommerceCountry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCountry commerceCountry : list) {
                if (uuid.equals(commerceCountry.getUuid()) && companyId == commerceCountry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("commerceCountry.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCountry.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCountry findByUuid_C_First(String uuid, long companyId, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<CommerceCountry> orderByComparator) {
        List<CommerceCountry> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry findByUuid_C_Last(String uuid, long companyId, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<CommerceCountry> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<CommerceCountry> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry[] findByUuid_C_PrevAndNext(long commerceCountryId, String uuid, long companyId, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        uuid = Objects.toString(uuid, "");
        CommerceCountry commerceCountry = this.findByPrimaryKey(commerceCountryId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCountry[] array = new CommerceCountryImpl[]{this.getByUuid_C_PrevAndNext(session, commerceCountry, uuid, companyId, orderByComparator, true), commerceCountry, this.getByUuid_C_PrevAndNext(session, commerceCountry, uuid, companyId, orderByComparator, false)};
            CommerceCountry[] commerceCountryArray = array;
            return commerceCountryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCountry getByUuid_C_PrevAndNext(Session session, CommerceCountry commerceCountry, String uuid, long companyId, OrderByComparator<CommerceCountry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        sb.append("commerceCountry.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCountry.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCountry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCountry)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (CommerceCountry commerceCountry : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)commerceCountry);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCECOUNTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("commerceCountry.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceCountry> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<CommerceCountry> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<CommerceCountry> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<CommerceCountry> findByCompanyId(long companyId, int start, int end, OrderByComparator<CommerceCountry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCountry commerceCountry : list) {
                if (companyId == commerceCountry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCountry.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCountry findByCompanyId_First(long companyId, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByCompanyId_First(long companyId, OrderByComparator<CommerceCountry> orderByComparator) {
        List<CommerceCountry> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry findByCompanyId_Last(long companyId, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByCompanyId_Last(long companyId, OrderByComparator<CommerceCountry> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<CommerceCountry> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry[] findByCompanyId_PrevAndNext(long commerceCountryId, long companyId, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.findByPrimaryKey(commerceCountryId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCountry[] array = new CommerceCountryImpl[]{this.getByCompanyId_PrevAndNext(session, commerceCountry, companyId, orderByComparator, true), commerceCountry, this.getByCompanyId_PrevAndNext(session, commerceCountry, companyId, orderByComparator, false)};
            CommerceCountry[] commerceCountryArray = array;
            return commerceCountryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCountry getByCompanyId_PrevAndNext(Session session, CommerceCountry commerceCountry, long companyId, OrderByComparator<CommerceCountry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
        sb.append("commerceCountry.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCountry.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCountry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCountry)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (CommerceCountry commerceCountry : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)commerceCountry);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceCountry findByC_Tw(long companyId, String twoLettersISOCode) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByC_Tw(companyId, twoLettersISOCode);
        if (commerceCountry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", twoLettersISOCode=");
            sb.append(twoLettersISOCode);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchCountryException(sb.toString());
        }
        return commerceCountry;
    }

    public CommerceCountry fetchByC_Tw(long companyId, String twoLettersISOCode) {
        return this.fetchByC_Tw(companyId, twoLettersISOCode, true);
    }

    public CommerceCountry fetchByC_Tw(long companyId, String twoLettersISOCode, boolean useFinderCache) {
        CommerceCountry commerceCountry;
        twoLettersISOCode = Objects.toString(twoLettersISOCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, twoLettersISOCode};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_Tw, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof CommerceCountry && (companyId != (commerceCountry = (CommerceCountry)result).getCompanyId() || !Objects.equals(twoLettersISOCode, commerceCountry.getTwoLettersISOCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ? AND ");
            boolean bindTwoLettersISOCode = false;
            if (twoLettersISOCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_TW_TWOLETTERSISOCODE_3);
            } else {
                bindTwoLettersISOCode = true;
                sb.append(_FINDER_COLUMN_C_TW_TWOLETTERSISOCODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindTwoLettersISOCode) {
                    queryPos.add(twoLettersISOCode);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_Tw, finderArgs, (Object)list);
                    }
                } else {
                    CommerceCountry commerceCountry2 = (CommerceCountry)list.get(0);
                    result = commerceCountry2;
                    this.cacheResult(commerceCountry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceCountry)result;
    }

    public CommerceCountry removeByC_Tw(long companyId, String twoLettersISOCode) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.findByC_Tw(companyId, twoLettersISOCode);
        return (CommerceCountry)this.remove((BaseModel)commerceCountry);
    }

    public int countByC_Tw(long companyId, String twoLettersISOCode) {
        twoLettersISOCode = Objects.toString(twoLettersISOCode, "");
        FinderPath finderPath = this._finderPathCountByC_Tw;
        Object[] finderArgs = new Object[]{companyId, twoLettersISOCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ? AND ");
            boolean bindTwoLettersISOCode = false;
            if (twoLettersISOCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_TW_TWOLETTERSISOCODE_3);
            } else {
                bindTwoLettersISOCode = true;
                sb.append(_FINDER_COLUMN_C_TW_TWOLETTERSISOCODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindTwoLettersISOCode) {
                    queryPos.add(twoLettersISOCode);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceCountry findByC_N(long companyId, int numericISOCode) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByC_N(companyId, numericISOCode);
        if (commerceCountry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", numericISOCode=");
            sb.append(numericISOCode);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchCountryException(sb.toString());
        }
        return commerceCountry;
    }

    public CommerceCountry fetchByC_N(long companyId, int numericISOCode) {
        return this.fetchByC_N(companyId, numericISOCode, true);
    }

    public CommerceCountry fetchByC_N(long companyId, int numericISOCode, boolean useFinderCache) {
        CommerceCountry commerceCountry;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, numericISOCode};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_N, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof CommerceCountry && (companyId != (commerceCountry = (CommerceCountry)result).getCompanyId() || numericISOCode != commerceCountry.getNumericISOCode())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_N_NUMERICISOCODE_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(numericISOCode);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_N, finderArgs, (Object)list);
                    }
                } else {
                    CommerceCountry commerceCountry2 = (CommerceCountry)list.get(0);
                    result = commerceCountry2;
                    this.cacheResult(commerceCountry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceCountry)result;
    }

    public CommerceCountry removeByC_N(long companyId, int numericISOCode) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.findByC_N(companyId, numericISOCode);
        return (CommerceCountry)this.remove((BaseModel)commerceCountry);
    }

    public int countByC_N(long companyId, int numericISOCode) {
        FinderPath finderPath = this._finderPathCountByC_N;
        Object[] finderArgs = new Object[]{companyId, numericISOCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_N_NUMERICISOCODE_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(numericISOCode);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceCountry> findByC_A(long companyId, boolean active) {
        return this.findByC_A(companyId, active, -1, -1, null);
    }

    public List<CommerceCountry> findByC_A(long companyId, boolean active, int start, int end) {
        return this.findByC_A(companyId, active, start, end, null);
    }

    public List<CommerceCountry> findByC_A(long companyId, boolean active, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) {
        return this.findByC_A(companyId, active, start, end, orderByComparator, true);
    }

    public List<CommerceCountry> findByC_A(long companyId, boolean active, int start, int end, OrderByComparator<CommerceCountry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_A;
                finderArgs = new Object[]{companyId, active};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_A;
            finderArgs = new Object[]{companyId, active, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCountry commerceCountry : list) {
                if (companyId == commerceCountry.getCompanyId() && active == commerceCountry.isActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ? AND ");
            sb.append("commerceCountry.active = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCountry.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(active);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCountry findByC_A_First(long companyId, boolean active, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByC_A_First(companyId, active, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", active=");
        sb.append(active);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByC_A_First(long companyId, boolean active, OrderByComparator<CommerceCountry> orderByComparator) {
        List<CommerceCountry> list = this.findByC_A(companyId, active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry findByC_A_Last(long companyId, boolean active, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByC_A_Last(companyId, active, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", active=");
        sb.append(active);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByC_A_Last(long companyId, boolean active, OrderByComparator<CommerceCountry> orderByComparator) {
        int count = this.countByC_A(companyId, active);
        if (count == 0) {
            return null;
        }
        List<CommerceCountry> list = this.findByC_A(companyId, active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry[] findByC_A_PrevAndNext(long commerceCountryId, long companyId, boolean active, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.findByPrimaryKey(commerceCountryId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCountry[] array = new CommerceCountryImpl[]{this.getByC_A_PrevAndNext(session, commerceCountry, companyId, active, orderByComparator, true), commerceCountry, this.getByC_A_PrevAndNext(session, commerceCountry, companyId, active, orderByComparator, false)};
            CommerceCountry[] commerceCountryArray = array;
            return commerceCountryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCountry getByC_A_PrevAndNext(Session session, CommerceCountry commerceCountry, long companyId, boolean active, OrderByComparator<CommerceCountry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
        sb.append("commerceCountry.companyId = ? AND ");
        sb.append("commerceCountry.active = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCountry.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(active);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCountry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCountry)list.get(1);
        }
        return null;
    }

    public void removeByC_A(long companyId, boolean active) {
        for (CommerceCountry commerceCountry : this.findByC_A(companyId, active, -1, -1, null)) {
            this.remove((BaseModel)commerceCountry);
        }
    }

    public int countByC_A(long companyId, boolean active) {
        FinderPath finderPath = this._finderPathCountByC_A;
        Object[] finderArgs = new Object[]{companyId, active};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ? AND ");
            sb.append("commerceCountry.active = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(active);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceCountry> findByC_B_A(long companyId, boolean billingAllowed, boolean active) {
        return this.findByC_B_A(companyId, billingAllowed, active, -1, -1, null);
    }

    public List<CommerceCountry> findByC_B_A(long companyId, boolean billingAllowed, boolean active, int start, int end) {
        return this.findByC_B_A(companyId, billingAllowed, active, start, end, null);
    }

    public List<CommerceCountry> findByC_B_A(long companyId, boolean billingAllowed, boolean active, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) {
        return this.findByC_B_A(companyId, billingAllowed, active, start, end, orderByComparator, true);
    }

    public List<CommerceCountry> findByC_B_A(long companyId, boolean billingAllowed, boolean active, int start, int end, OrderByComparator<CommerceCountry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_B_A;
                finderArgs = new Object[]{companyId, billingAllowed, active};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_B_A;
            finderArgs = new Object[]{companyId, billingAllowed, active, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCountry commerceCountry : list) {
                if (companyId == commerceCountry.getCompanyId() && billingAllowed == commerceCountry.isBillingAllowed() && active == commerceCountry.isActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_B_A_BILLINGALLOWED_2);
            sb.append("commerceCountry.active = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCountry.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(billingAllowed);
                queryPos.add(active);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCountry findByC_B_A_First(long companyId, boolean billingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByC_B_A_First(companyId, billingAllowed, active, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", billingAllowed=");
        sb.append(billingAllowed);
        sb.append(", active=");
        sb.append(active);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByC_B_A_First(long companyId, boolean billingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator) {
        List<CommerceCountry> list = this.findByC_B_A(companyId, billingAllowed, active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry findByC_B_A_Last(long companyId, boolean billingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByC_B_A_Last(companyId, billingAllowed, active, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", billingAllowed=");
        sb.append(billingAllowed);
        sb.append(", active=");
        sb.append(active);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByC_B_A_Last(long companyId, boolean billingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator) {
        int count = this.countByC_B_A(companyId, billingAllowed, active);
        if (count == 0) {
            return null;
        }
        List<CommerceCountry> list = this.findByC_B_A(companyId, billingAllowed, active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry[] findByC_B_A_PrevAndNext(long commerceCountryId, long companyId, boolean billingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.findByPrimaryKey(commerceCountryId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCountry[] array = new CommerceCountryImpl[]{this.getByC_B_A_PrevAndNext(session, commerceCountry, companyId, billingAllowed, active, orderByComparator, true), commerceCountry, this.getByC_B_A_PrevAndNext(session, commerceCountry, companyId, billingAllowed, active, orderByComparator, false)};
            CommerceCountry[] commerceCountryArray = array;
            return commerceCountryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCountry getByC_B_A_PrevAndNext(Session session, CommerceCountry commerceCountry, long companyId, boolean billingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
        sb.append("commerceCountry.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_B_A_BILLINGALLOWED_2);
        sb.append("commerceCountry.active = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCountry.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(billingAllowed);
        queryPos.add(active);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCountry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCountry)list.get(1);
        }
        return null;
    }

    public void removeByC_B_A(long companyId, boolean billingAllowed, boolean active) {
        for (CommerceCountry commerceCountry : this.findByC_B_A(companyId, billingAllowed, active, -1, -1, null)) {
            this.remove((BaseModel)commerceCountry);
        }
    }

    public int countByC_B_A(long companyId, boolean billingAllowed, boolean active) {
        FinderPath finderPath = this._finderPathCountByC_B_A;
        Object[] finderArgs = new Object[]{companyId, billingAllowed, active};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_B_A_BILLINGALLOWED_2);
            sb.append("commerceCountry.active = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(billingAllowed);
                queryPos.add(active);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceCountry> findByC_S_A(long companyId, boolean shippingAllowed, boolean active) {
        return this.findByC_S_A(companyId, shippingAllowed, active, -1, -1, null);
    }

    public List<CommerceCountry> findByC_S_A(long companyId, boolean shippingAllowed, boolean active, int start, int end) {
        return this.findByC_S_A(companyId, shippingAllowed, active, start, end, null);
    }

    public List<CommerceCountry> findByC_S_A(long companyId, boolean shippingAllowed, boolean active, int start, int end, OrderByComparator<CommerceCountry> orderByComparator) {
        return this.findByC_S_A(companyId, shippingAllowed, active, start, end, orderByComparator, true);
    }

    public List<CommerceCountry> findByC_S_A(long companyId, boolean shippingAllowed, boolean active, int start, int end, OrderByComparator<CommerceCountry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_S_A;
                finderArgs = new Object[]{companyId, shippingAllowed, active};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_S_A;
            finderArgs = new Object[]{companyId, shippingAllowed, active, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceCountry commerceCountry : list) {
                if (companyId == commerceCountry.getCompanyId() && shippingAllowed == commerceCountry.isShippingAllowed() && active == commerceCountry.isActive()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_S_A_SHIPPINGALLOWED_2);
            sb.append("commerceCountry.active = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceCountry.priority ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(shippingAllowed);
                queryPos.add(active);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceCountry findByC_S_A_First(long companyId, boolean shippingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByC_S_A_First(companyId, shippingAllowed, active, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", shippingAllowed=");
        sb.append(shippingAllowed);
        sb.append(", active=");
        sb.append(active);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByC_S_A_First(long companyId, boolean shippingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator) {
        List<CommerceCountry> list = this.findByC_S_A(companyId, shippingAllowed, active, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry findByC_S_A_Last(long companyId, boolean shippingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.fetchByC_S_A_Last(companyId, shippingAllowed, active, orderByComparator);
        if (commerceCountry != null) {
            return commerceCountry;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", shippingAllowed=");
        sb.append(shippingAllowed);
        sb.append(", active=");
        sb.append(active);
        sb.append("}");
        throw new NoSuchCountryException(sb.toString());
    }

    public CommerceCountry fetchByC_S_A_Last(long companyId, boolean shippingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator) {
        int count = this.countByC_S_A(companyId, shippingAllowed, active);
        if (count == 0) {
            return null;
        }
        List<CommerceCountry> list = this.findByC_S_A(companyId, shippingAllowed, active, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceCountry[] findByC_S_A_PrevAndNext(long commerceCountryId, long companyId, boolean shippingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator) throws NoSuchCountryException {
        CommerceCountry commerceCountry = this.findByPrimaryKey(commerceCountryId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceCountry[] array = new CommerceCountryImpl[]{this.getByC_S_A_PrevAndNext(session, commerceCountry, companyId, shippingAllowed, active, orderByComparator, true), commerceCountry, this.getByC_S_A_PrevAndNext(session, commerceCountry, companyId, shippingAllowed, active, orderByComparator, false)};
            CommerceCountry[] commerceCountryArray = array;
            return commerceCountryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCountry getByC_S_A_PrevAndNext(Session session, CommerceCountry commerceCountry, long companyId, boolean shippingAllowed, boolean active, OrderByComparator<CommerceCountry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_COMMERCECOUNTRY_WHERE);
        sb.append("commerceCountry.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_S_A_SHIPPINGALLOWED_2);
        sb.append("commerceCountry.active = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceCountry.priority ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(shippingAllowed);
        queryPos.add(active);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceCountry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceCountry)list.get(1);
        }
        return null;
    }

    public void removeByC_S_A(long companyId, boolean shippingAllowed, boolean active) {
        for (CommerceCountry commerceCountry : this.findByC_S_A(companyId, shippingAllowed, active, -1, -1, null)) {
            this.remove((BaseModel)commerceCountry);
        }
    }

    public int countByC_S_A(long companyId, boolean shippingAllowed, boolean active) {
        FinderPath finderPath = this._finderPathCountByC_S_A;
        Object[] finderArgs = new Object[]{companyId, shippingAllowed, active};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_COMMERCECOUNTRY_WHERE);
            sb.append("commerceCountry.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_S_A_SHIPPINGALLOWED_2);
            sb.append("commerceCountry.active = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(shippingAllowed);
                queryPos.add(active);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceCountryPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        dbColumnNames.put("active", "active_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(CommerceCountry.class);
        this.setModelImplClass(CommerceCountryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CommerceCountryTable.INSTANCE);
    }

    public void cacheResult(CommerceCountry commerceCountry) {
        this.entityCache.putResult(CommerceCountryImpl.class, (Serializable)Long.valueOf(commerceCountry.getPrimaryKey()), (Serializable)commerceCountry);
        this.finderCache.putResult(this._finderPathFetchByC_Tw, new Object[]{commerceCountry.getCompanyId(), commerceCountry.getTwoLettersISOCode()}, (Object)commerceCountry);
        this.finderCache.putResult(this._finderPathFetchByC_N, new Object[]{commerceCountry.getCompanyId(), commerceCountry.getNumericISOCode()}, (Object)commerceCountry);
    }

    public void cacheResult(List<CommerceCountry> commerceCountries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && commerceCountries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (CommerceCountry commerceCountry : commerceCountries) {
            if (this.entityCache.getResult(CommerceCountryImpl.class, (Serializable)Long.valueOf(commerceCountry.getPrimaryKey())) != null) continue;
            this.cacheResult(commerceCountry);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceCountryImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceCountry commerceCountry) {
        this.entityCache.removeResult(CommerceCountryImpl.class, (BaseModel)commerceCountry);
    }

    public void clearCache(List<CommerceCountry> commerceCountries) {
        for (CommerceCountry commerceCountry : commerceCountries) {
            this.entityCache.removeResult(CommerceCountryImpl.class, (BaseModel)commerceCountry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceCountryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CommerceCountryModelImpl commerceCountryModelImpl) {
        Object[] args = new Object[]{commerceCountryModelImpl.getCompanyId(), commerceCountryModelImpl.getTwoLettersISOCode()};
        this.finderCache.putResult(this._finderPathCountByC_Tw, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_Tw, args, (Object)commerceCountryModelImpl, false);
        args = new Object[]{commerceCountryModelImpl.getCompanyId(), commerceCountryModelImpl.getNumericISOCode()};
        this.finderCache.putResult(this._finderPathCountByC_N, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_N, args, (Object)commerceCountryModelImpl, false);
    }

    public CommerceCountry create(long commerceCountryId) {
        CommerceCountryImpl commerceCountry = new CommerceCountryImpl();
        commerceCountry.setNew(true);
        commerceCountry.setPrimaryKey(commerceCountryId);
        String uuid = PortalUUIDUtil.generate();
        commerceCountry.setUuid(uuid);
        commerceCountry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceCountry;
    }

    public CommerceCountry remove(long commerceCountryId) throws NoSuchCountryException {
        return this.remove(Long.valueOf(commerceCountryId));
    }

    public CommerceCountry remove(Serializable primaryKey) throws NoSuchCountryException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceCountry commerceCountry = (CommerceCountry)session.get(CommerceCountryImpl.class, primaryKey);
            if (commerceCountry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCountryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceCountry commerceCountry2 = (CommerceCountry)this.remove((BaseModel)commerceCountry);
            return commerceCountry2;
        }
        catch (NoSuchCountryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceCountry removeImpl(CommerceCountry commerceCountry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceCountry)) {
                commerceCountry = (CommerceCountry)session.get(CommerceCountryImpl.class, commerceCountry.getPrimaryKeyObj());
            }
            if (commerceCountry != null) {
                session.delete((Object)commerceCountry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceCountry != null) {
            this.clearCache(commerceCountry);
        }
        return commerceCountry;
    }

    public CommerceCountry updateImpl(CommerceCountry commerceCountry) {
        boolean isNew = commerceCountry.isNew();
        if (!(commerceCountry instanceof CommerceCountryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceCountry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceCountry);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceCountry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceCountry implementation " + commerceCountry.getClass());
        }
        CommerceCountryModelImpl commerceCountryModelImpl = (CommerceCountryModelImpl)commerceCountry;
        if (Validator.isNull((String)commerceCountry.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            commerceCountry.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && commerceCountry.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceCountry.setCreateDate(date);
            } else {
                commerceCountry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!commerceCountryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceCountry.setModifiedDate(date);
            } else {
                commerceCountry.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceCountry);
            } else {
                commerceCountry = (CommerceCountry)session.merge((Object)commerceCountry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CommerceCountryImpl.class, (BaseModel)commerceCountryModelImpl, false, true);
        this.cacheUniqueFindersCache(commerceCountryModelImpl);
        if (isNew) {
            commerceCountry.setNew(false);
        }
        commerceCountry.resetOriginalValues();
        return commerceCountry;
    }

    public CommerceCountry findByPrimaryKey(Serializable primaryKey) throws NoSuchCountryException {
        CommerceCountry commerceCountry = (CommerceCountry)this.fetchByPrimaryKey(primaryKey);
        if (commerceCountry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCountryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceCountry;
    }

    public CommerceCountry findByPrimaryKey(long commerceCountryId) throws NoSuchCountryException {
        return this.findByPrimaryKey(Long.valueOf(commerceCountryId));
    }

    public CommerceCountry fetchByPrimaryKey(long commerceCountryId) {
        return (CommerceCountry)this.fetchByPrimaryKey(Long.valueOf(commerceCountryId));
    }

    public List<CommerceCountry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceCountry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceCountry> findAll(int start, int end, OrderByComparator<CommerceCountry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceCountry> findAll(int start, int end, OrderByComparator<CommerceCountry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCECOUNTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCECOUNTRY;
                sql = sql.concat(" ORDER BY commerceCountry.priority ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceCountry commerceCountry : this.findAll()) {
            this.remove((BaseModel)commerceCountry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCECOUNTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "commerceCountryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_COMMERCECOUNTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceCountryModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Bundle bundle = FrameworkUtil.getBundle(CommerceCountryPersistenceImpl.class);
        this._bundleContext = bundle.getBundleContext();
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new CommerceCountryModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)CommerceCountry.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathWithPaginationFindByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathWithoutPaginationFindByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        this._finderPathCountByCompanyId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, false);
        this._finderPathFetchByC_Tw = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_Tw", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "twoLettersISOCode"}, true);
        this._finderPathCountByC_Tw = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_Tw", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "twoLettersISOCode"}, false);
        this._finderPathFetchByC_N = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_N", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"companyId", "numericISOCode"}, true);
        this._finderPathCountByC_N = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_N", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"companyId", "numericISOCode"}, false);
        this._finderPathWithPaginationFindByC_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_A", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "active_"}, true);
        this._finderPathWithoutPaginationFindByC_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_A", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "active_"}, true);
        this._finderPathCountByC_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_A", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "active_"}, false);
        this._finderPathWithPaginationFindByC_B_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_B_A", new String[]{Long.class.getName(), Boolean.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "billingAllowed", "active_"}, true);
        this._finderPathWithoutPaginationFindByC_B_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_B_A", new String[]{Long.class.getName(), Boolean.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "billingAllowed", "active_"}, true);
        this._finderPathCountByC_B_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_B_A", new String[]{Long.class.getName(), Boolean.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "billingAllowed", "active_"}, false);
        this._finderPathWithPaginationFindByC_S_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_S_A", new String[]{Long.class.getName(), Boolean.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "shippingAllowed", "active_"}, true);
        this._finderPathWithoutPaginationFindByC_S_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_S_A", new String[]{Long.class.getName(), Boolean.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "shippingAllowed", "active_"}, true);
        this._finderPathCountByC_S_A = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S_A", new String[]{Long.class.getName(), Boolean.class.getName(), Boolean.class.getName()}, new String[]{"companyId", "shippingAllowed", "active_"}, false);
        CommerceCountryUtil.setPersistence((CommerceCountryPersistence)this);
    }

    public void destroy() {
        CommerceCountryUtil.setPersistence(null);
        this.entityCache.removeCache(CommerceCountryImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class CommerceCountryModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private CommerceCountryModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            CommerceCountryModelImpl commerceCountryModelImpl = (CommerceCountryModelImpl)baseModel;
            long columnBitmask = commerceCountryModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return CommerceCountryModelArgumentsResolver._getValue(commerceCountryModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | CommerceCountryModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return CommerceCountryModelArgumentsResolver._getValue(commerceCountryModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(CommerceCountryModelImpl commerceCountryModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? commerceCountryModelImpl.getColumnOriginalValue(columnName) : commerceCountryModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= CommerceCountryModelImpl.getColumnBitmask("priority");
        }
    }
}

