/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.upgrade.v2_1_0;

import com.liferay.commerce.internal.upgrade.base.BaseCommerceServiceUpgradeProcess;
import com.liferay.commerce.model.impl.CPDAvailabilityEstimateModelImpl;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;

public class CPDAvailabilityEstimateUpgradeProcess
extends BaseCommerceServiceUpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CPDAvailabilityEstimateUpgradeProcess.class);
    private final CPDefinitionLocalService _cpDefinitionLocalService;

    public CPDAvailabilityEstimateUpgradeProcess(CPDefinitionLocalService cpDefinitionLocalService) {
        this._cpDefinitionLocalService = cpDefinitionLocalService;
    }

    @Override
    protected void doUpgrade() throws Exception {
        this.addColumn(CPDAvailabilityEstimateModelImpl.class, "CPDAvailabilityEstimate", "CProductId", "LONG");
        this._addIndexes("CPDAvailabilityEstimate");
        try (PreparedStatement ps = this.connection.prepareStatement("update CPDAvailabilityEstimate set CProductId = ? where CPDefinitionId = ?");
             Statement s = this.connection.createStatement();
             ResultSet rs = s.executeQuery("select distinct CPDefinitionId from CPDAvailabilityEstimate");){
            while (rs.next()) {
                long cpDefinitionId = rs.getLong("CPDefinitionId");
                CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
                ps.setLong(1, cpDefinition.getCProductId());
                ps.setLong(2, cpDefinitionId);
                ps.execute();
            }
        }
        if (this.hasIndex("CPDAvailabilityEstimate", "IX_86A2368F")) {
            this.runSQL("drop index IX_86A2368F on CPDAvailabilityEstimate");
        }
        this.runSQL("alter table CPDAvailabilityEstimate drop column CPDefinitionId");
    }

    private void _addIndexes(String tableName) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        List indexesSQL = this.getIndexesSQL(clazz.getClassLoader(), tableName);
        for (ObjectValuePair indexSQL : indexesSQL) {
            IndexMetadata indexMetadata = (IndexMetadata)indexSQL.getValue();
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("Adding index %s to table %s", indexMetadata.getIndexName(), tableName));
            }
            if (!this.hasIndex(tableName, indexMetadata.getIndexName())) {
                this.runSQL(indexMetadata.getCreateSQL(null));
                continue;
            }
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)String.format("Index %s already exists on table %s", indexMetadata.getIndexName(), tableName));
        }
    }
}

