/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order;

import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderValidator;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"commerce.order.validator.key=availability", "commerce.order.validator.priority:Integer=20"}, service={CommerceOrderValidator.class})
public class AvailabilityCommerceOrderValidatorImpl
implements CommerceOrderValidator {
    public static final String KEY = "availability";
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;

    public String getKey() {
        return KEY;
    }

    public CommerceOrderValidatorResult validate(Locale locale, CommerceOrder commerceOrder, CPInstance cpInstance, int quantity) throws PortalException {
        if (cpInstance == null) {
            return new CommerceOrderValidatorResult(false, this._getLocalizedMessage(locale, "the-product-is-no-longer-available"));
        }
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        if (!(cpDefinition.isApproved() && cpInstance.isApproved() && cpInstance.isPublished() && cpInstance.isPurchasable())) {
            return new CommerceOrderValidatorResult(false, this._getLocalizedMessage(locale, "the-product-is-no-longer-available"));
        }
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpDefinition.getCPDefinitionId());
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        if (cpDefinitionInventoryEngine.isBackOrderAllowed(cpInstance)) {
            return new CommerceOrderValidatorResult(true);
        }
        int availableQuantity = this._commerceInventoryEngine.getStockQuantity(cpInstance.getCompanyId(), commerceOrder.getGroupId(), cpInstance.getSku());
        if (quantity > availableQuantity) {
            return new CommerceOrderValidatorResult(false, this._getLocalizedMessage(locale, "that-quantity-is-unavailable"));
        }
        return new CommerceOrderValidatorResult(true);
    }

    public CommerceOrderValidatorResult validate(Locale locale, CommerceOrderItem commerceOrderItem) throws PortalException {
        CPInstance cpInstance = commerceOrderItem.fetchCPInstance();
        if (cpInstance == null) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "the-product-is-no-longer-available"));
        }
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        if (!(cpDefinition.isApproved() && cpInstance.isApproved() && cpInstance.isPublished() && cpInstance.isPurchasable())) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "the-product-is-no-longer-available"));
        }
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpDefinition.getCPDefinitionId());
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        if (cpDefinitionInventoryEngine.isBackOrderAllowed(cpInstance)) {
            return new CommerceOrderValidatorResult(true);
        }
        CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.fetchCommerceInventoryBookedQuantity(commerceOrderItem.getBookedQuantityId());
        int availableQuantity = this._commerceInventoryEngine.getStockQuantity(cpInstance.getCompanyId(), commerceOrderItem.getGroupId(), cpInstance.getSku());
        int orderQuantity = commerceOrderItem.getQuantity();
        if (orderQuantity > availableQuantity && commerceInventoryBookedQuantity == null) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "that-quantity-is-unavailable"));
        }
        if (commerceInventoryBookedQuantity != null && commerceOrderItem.getQuantity() != commerceInventoryBookedQuantity.getQuantity()) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, this._getLocalizedMessage(locale, "that-quantity-is-not-allowed"));
        }
        return new CommerceOrderValidatorResult(true);
    }

    private String _getLocalizedMessage(Locale locale, String key) {
        if (locale == null) {
            return key;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)key);
    }
}

