/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.workflow.assigment;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.workflow.kaleo.KaleoTaskAssignmentFactory;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.assignment.TaskAssignmentSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"assignee.class.name=com.liferay.portal.kernel.model.Role", "service.ranking:Integer=100"}, service={TaskAssignmentSelector.class})
public class GroupAwareRoleTaskAssignmentSelector
implements TaskAssignmentSelector {
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private KaleoTaskAssignmentFactory _kaleoTaskAssignmentFactory;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;

    public Collection<KaleoTaskAssignment> calculateTaskAssignments(KaleoTaskAssignment kaleoTaskAssignment, ExecutionContext executionContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        long groupId = kaleoInstanceToken.getGroupId();
        Role role = this._roleLocalService.getRole(kaleoTaskAssignment.getAssigneeClassPK());
        return this.createKaleoTaskAssigments(groupId, role);
    }

    protected List<KaleoTaskAssignment> createKaleoTaskAssigments(long groupId, Role role) throws PortalException {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        Group group = null;
        if (groupId != 0L) {
            group = this._groupLocalService.getGroup(groupId);
            if (group.isOrganization()) {
                groupIds.addAll(this.getAncestorOrganizationGroupIds(group, role));
            }
            if (group.isSite()) {
                groupIds.addAll(this.getAncestorGroupIds(group, role));
            }
            if (group.isLayout()) {
                group = this._groupLocalService.getGroup(group.getParentGroupId());
            }
        }
        if (this.isValidAssignment(group, role)) {
            groupIds.add(groupId);
        }
        return this.createKaleoTaskAssigments(role, groupIds);
    }

    protected List<KaleoTaskAssignment> createKaleoTaskAssigments(Role role, List<Long> groupIds) throws PortalException {
        ArrayList<KaleoTaskAssignment> kaleoTaskAssignments = new ArrayList<KaleoTaskAssignment>();
        for (Long groupId : groupIds) {
            kaleoTaskAssignments.add(this.createKaleoTaskAssignment(role, groupId));
        }
        return kaleoTaskAssignments;
    }

    protected KaleoTaskAssignment createKaleoTaskAssignment(Role role, long groupId) {
        KaleoTaskAssignment kaleoTaskAssignment = this._kaleoTaskAssignmentFactory.createKaleoTaskAssignment();
        kaleoTaskAssignment.setGroupId(groupId);
        kaleoTaskAssignment.setAssigneeClassName(Role.class.getName());
        kaleoTaskAssignment.setAssigneeClassPK(role.getRoleId());
        return kaleoTaskAssignment;
    }

    protected List<Long> getAncestorGroupIds(Group group, Role role) throws PortalException {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        for (Group ancestorGroup : group.getAncestors()) {
            if (!this.isValidAssignment(group, role)) continue;
            groupIds.add(ancestorGroup.getGroupId());
        }
        return groupIds;
    }

    protected List<Long> getAncestorOrganizationGroupIds(Group group, Role role) throws PortalException {
        ArrayList<Long> groupIds = new ArrayList<Long>();
        Organization organization = this._organizationLocalService.getOrganization(group.getClassPK());
        for (Organization ancestorOrganization : organization.getAncestors()) {
            if (!this.isValidAssignment(group, role)) continue;
            groupIds.add(ancestorOrganization.getGroupId());
        }
        return groupIds;
    }

    protected boolean isValidAssignment(Group group, Role role) throws PortalException {
        if (role.getType() == 1) {
            return true;
        }
        if (group != null && group.isOrganization() && role.getType() == 3) {
            return true;
        }
        if (group != null && group.isSite() && role.getType() == 2) {
            return true;
        }
        return group != null && this._isAccount(group) && role.getType() == 2;
    }

    private boolean _isAccount(Group group) {
        long classNameId = this._portal.getClassNameId(CommerceAccount.class.getName());
        return group.getClassNameId() == classNameId;
    }
}

